/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public class TestMRCJCFileOutputCommitter
extends TestCase {
    private static Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), "output");
    private static String attempt = "attempt_200707121733_0001_m_000000_0";
    private static String partFile = "part-m-00000";
    private static TaskAttemptID taskID = TaskAttemptID.forName((String)attempt);
    private Text key1 = new Text("key1");
    private Text key2 = new Text("key2");
    private Text val1 = new Text("val1");
    private Text val2 = new Text("val2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(RecordWriter theRecordWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        NullWritable nullWritable = NullWritable.get();
        try {
            theRecordWriter.write((Object)this.key1, (Object)this.val1);
            theRecordWriter.write(null, (Object)nullWritable);
            theRecordWriter.write(null, (Object)this.val1);
            theRecordWriter.write((Object)nullWritable, (Object)this.val2);
            theRecordWriter.write((Object)this.key2, (Object)nullWritable);
            theRecordWriter.write((Object)this.key1, null);
            theRecordWriter.write(null, null);
            theRecordWriter.write((Object)this.key2, (Object)this.val2);
        }
        finally {
            theRecordWriter.close(context);
        }
    }

    private static void cleanup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = outDir.getFileSystem(conf);
        fs.delete(outDir, true);
    }

    public void setUp() throws IOException {
        TestMRCJCFileOutputCommitter.cleanup();
    }

    public void tearDown() throws IOException {
        TestMRCJCFileOutputCommitter.cleanup();
    }

    public void testCommitter() throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
        committer.commitJob((JobContext)jContext);
        File expectedFile = new File(new Path(outDir, partFile).toString());
        StringBuffer expectedOutput = new StringBuffer();
        expectedOutput.append(this.key1).append('\t').append(this.val1).append("\n");
        expectedOutput.append(this.val1).append("\n");
        expectedOutput.append(this.val2).append("\n");
        expectedOutput.append(this.key2).append("\n");
        expectedOutput.append(this.key1).append("\n");
        expectedOutput.append(this.key2).append('\t').append(this.val2).append("\n");
        String output = UtilsForTests.slurp(expectedFile);
        TestMRCJCFileOutputCommitter.assertEquals((String)output, (String)expectedOutput.toString());
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    public void testEmptyOutput() throws Exception {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        committer.commitTask((TaskAttemptContext)tContext);
        committer.commitJob((JobContext)jContext);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    public void testAbort() throws IOException, InterruptedException {
        Job job = Job.getInstance();
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", attempt);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        committer.abortTask((TaskAttemptContext)tContext);
        File expectedFile = new File(new Path(committer.getWorkPath(), partFile).toString());
        TestMRCJCFileOutputCommitter.assertFalse((String)"task temp dir still exists", (boolean)expectedFile.exists());
        committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        expectedFile = new File(new Path(outDir, "_temporary").toString());
        TestMRCJCFileOutputCommitter.assertFalse((String)"job temp dir still exists", (boolean)expectedFile.exists());
        TestMRCJCFileOutputCommitter.assertEquals((String)"Output directory not empty", (int)0, (int)new File(outDir.toString()).listFiles().length);
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    public void testFailAbort() throws IOException, InterruptedException {
        Job job = Job.getInstance();
        Configuration conf = job.getConfiguration();
        conf.set("fs.defaultFS", "faildel:///");
        conf.setClass("fs.faildel.impl", FakeFileSystem.class, FileSystem.class);
        conf.set("mapreduce.task.attempt.id", attempt);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        JobContextImpl jContext = new JobContextImpl(conf, taskID.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, taskID);
        FileOutputCommitter committer = new FileOutputCommitter(outDir, (TaskAttemptContext)tContext);
        committer.setupJob((JobContext)jContext);
        committer.setupTask((TaskAttemptContext)tContext);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((TaskAttemptContext)tContext);
        this.writeOutput(theRecordWriter, (TaskAttemptContext)tContext);
        IOException th = null;
        try {
            committer.abortTask((TaskAttemptContext)tContext);
        }
        catch (IOException ie) {
            th = ie;
        }
        TestMRCJCFileOutputCommitter.assertNotNull((Object)th);
        TestMRCJCFileOutputCommitter.assertTrue((boolean)(th instanceof IOException));
        TestMRCJCFileOutputCommitter.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        File jobTmpDir = new File(committer.getJobAttemptPath((JobContext)jContext).toUri().getPath());
        File taskTmpDir = new File(committer.getTaskAttemptPath((TaskAttemptContext)tContext).toUri().getPath());
        File expectedFile = new File(taskTmpDir, partFile);
        TestMRCJCFileOutputCommitter.assertTrue((String)(expectedFile + " does not exists"), (boolean)expectedFile.exists());
        th = null;
        try {
            committer.abortJob((JobContext)jContext, JobStatus.State.FAILED);
        }
        catch (IOException ie) {
            th = ie;
        }
        TestMRCJCFileOutputCommitter.assertNotNull((Object)th);
        TestMRCJCFileOutputCommitter.assertTrue((boolean)(th instanceof IOException));
        TestMRCJCFileOutputCommitter.assertTrue((boolean)th.getMessage().contains("fake delete failed"));
        TestMRCJCFileOutputCommitter.assertTrue((String)"job temp dir does not exists", (boolean)jobTmpDir.exists());
        FileUtil.fullyDelete((File)new File(outDir.toString()));
    }

    public static class FakeFileSystem
    extends RawLocalFileSystem {
        public URI getUri() {
            return URI.create("faildel:///");
        }

        public boolean delete(Path p, boolean recursive) throws IOException {
            throw new IOException("fake delete failed");
        }
    }
}

