/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBinaryTokenFile {
    private static final String KEY_SECURITY_TOKEN_FILE_NAME = "key-security-token-file";
    private static final String DELEGATION_TOKEN_KEY = "Hdfs";
    private static MiniMRYarnCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static final Path TEST_DIR;
    private static final Path binaryTokenFileName;
    private static final int numSlaves = 1;
    private static final int noOfNMs = 1;
    private static Path p1;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.set("yarn.resourcemanager.principal", "jt_id/_HOST@APACHE.ORG");
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.checkExitOnShutdown(true);
        builder.numDataNodes(1);
        builder.format(true);
        builder.racks(null);
        dfsCluster = builder.build();
        mrCluster = new MiniMRYarnCluster(TestBinaryTokenFile.class.getName(), 1);
        mrCluster.init(conf);
        mrCluster.start();
        NameNodeAdapter.getDtSecretManager((FSNamesystem)dfsCluster.getNamesystem()).startThreads();
        DistributedFileSystem fs = dfsCluster.getFileSystem();
        p1 = new Path("file1");
        p1 = fs.makeQualified(p1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createBinaryTokenFile(Configuration conf) {
        try {
            Credentials cred1 = new Credentials();
            Credentials cred2 = new Credentials();
            TokenCache.obtainTokensForNamenodesInternal((Credentials)cred1, (Path[])new Path[]{p1}, (Configuration)conf);
            for (Token t : cred1.getAllTokens()) {
                cred2.addToken(new Text(DELEGATION_TOKEN_KEY), t);
            }
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(binaryTokenFileName.toString()));){
                cred2.writeTokenStorageToStream(os);
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Exception " + e));
        }
    }

    @Test
    public void testBinaryTokenFile() throws IOException {
        Configuration conf = mrCluster.getConfig();
        String nnUri = dfsCluster.getURI(0).toString();
        conf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new MySleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    @Test
    public void testTokenCacheFile() throws IOException {
        Configuration conf = mrCluster.getConfig();
        TestBinaryTokenFile.createBinaryTokenFile(conf);
        String nnUri = dfsCluster.getURI(0).toString();
        conf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri);
        String[] args = new String[]{"-tokenCacheFile", binaryTokenFileName.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    static {
        TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
        binaryTokenFileName = new Path(TEST_DIR, "tokenFile.binary");
    }

    class MySleepJob
    extends SleepJob {
        MySleepJob() {
        }

        @Override
        public Job createJob(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) throws IOException {
            Job job = super.createJob(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount);
            job.setMapperClass(MySleepMapper.class);
            this.setupBinaryTokenFile(job);
            return job;
        }

        private void setupBinaryTokenFile(Job job) {
            TestBinaryTokenFile.createBinaryTokenFile(job.getConfiguration());
            job.getConfiguration().set("mapreduce.job.credentials.binary", binaryTokenFileName.toString());
            job.getConfiguration().set(TestBinaryTokenFile.KEY_SECURITY_TOKEN_FILE_NAME, binaryTokenFileName.toString());
        }
    }

    static class MySleepMapper
    extends SleepJob.SleepMapper {
        MySleepMapper() {
        }

        @Override
        public void map(IntWritable key, IntWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Credentials contextCredentials = context.getCredentials();
            Collection contextTokenCollection = contextCredentials.getAllTokens();
            for (Token t : contextTokenCollection) {
                System.out.println("Context token: [" + t + "]");
            }
            if (contextTokenCollection.size() != 2) {
                throw new RuntimeException("Exactly 2 tokens are expected in the contextTokenCollection: one job token and one delegation token, but was found " + contextTokenCollection.size() + " tokens.");
            }
            Token dt = contextCredentials.getToken(new Text(TestBinaryTokenFile.DELEGATION_TOKEN_KEY));
            if (dt == null) {
                throw new RuntimeException("Token for key [Hdfs] not found in the job context.");
            }
            String tokenFile0 = context.getConfiguration().get("mapreduce.job.credentials.binary");
            if (tokenFile0 != null) {
                throw new RuntimeException("Token file key [mapreduce.job.credentials.binary] found in the configuration. It should have been removed from the configuration.");
            }
            String tokenFile = context.getConfiguration().get(TestBinaryTokenFile.KEY_SECURITY_TOKEN_FILE_NAME);
            if (tokenFile == null) {
                throw new RuntimeException("Token file key [key-security-token-file] not found in the job configuration.");
            }
            Credentials binaryCredentials = new Credentials();
            binaryCredentials.readTokenStorageStream(new DataInputStream(new FileInputStream(tokenFile)));
            Collection binaryTokenCollection = binaryCredentials.getAllTokens();
            if (binaryTokenCollection.size() != 1) {
                throw new RuntimeException("The token collection read from file [" + tokenFile + "] must have size = 1.");
            }
            Token binTok = (Token)binaryTokenCollection.iterator().next();
            System.out.println("The token read from binary file: t = [" + binTok + "]");
            if (!dt.equals((Object)binTok)) {
                throw new RuntimeException("Delegation token in job is not same as the token passed in file: tokenInFile=[" + binTok + "], dt=[" + dt + "].");
            }
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Collection ugiTokenCollection = ugi.getTokens();
            for (Token t : ugiTokenCollection) {
                System.out.println("UGI token: [" + t + "]");
            }
            Token ugiToken = ugi.getCredentials().getToken(new Text(TestBinaryTokenFile.DELEGATION_TOKEN_KEY));
            if (ugiToken == null) {
                throw new RuntimeException("Token for key [Hdfs] not found among the UGI tokens.");
            }
            if (!ugiToken.equals((Object)binTok)) {
                throw new RuntimeException("UGI token is not same as the token passed in binary file: tokenInBinFile=[" + binTok + "], ugiTok=[" + ugiToken + "].");
            }
            super.map(key, value, context);
        }
    }
}

