/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Random;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFVariations {
    private static final String TEST_ROOT_DIR = GenericTestUtils.getTestDir("testdfvariations").getAbsolutePath();
    private static File test_root = null;

    @Before
    public void setup() throws IOException {
        test_root = new File(TEST_ROOT_DIR);
        test_root.mkdirs();
    }

    @After
    public void after() throws IOException {
        FileUtil.setWritable((File)test_root, (boolean)true);
        FileUtil.fullyDelete((File)test_root);
        Assert.assertTrue((!test_root.exists() ? 1 : 0) != 0);
    }

    public void testMount() throws Exception {
        XXDF df = new XXDF();
        String expectedMount = Shell.WINDOWS ? df.getDirPath().substring(0, 2) : "/foo/bar";
        Assert.assertEquals((String)"Invalid mount point", (Object)expectedMount, (Object)df.getMount());
    }

    @Test(timeout=5000L)
    public void testFileSystem() throws Exception {
        XXDF df = new XXDF();
        String expectedFileSystem = Shell.WINDOWS ? df.getDirPath().substring(0, 2) : "/dev/sda3";
        Assert.assertEquals((String)"Invalid filesystem", (Object)expectedFileSystem, (Object)df.getFilesystem());
    }

    @Test(timeout=5000L)
    public void testDFInvalidPath() throws Exception {
        Random random = new Random(3735928559L);
        File file = null;
        byte[] bytes = new byte[64];
        while (file == null) {
            random.nextBytes(bytes);
            String invalid = new String("/" + bytes);
            File invalidFile = new File(invalid);
            if (invalidFile.exists()) continue;
            file = invalidFile;
        }
        DF df = new DF(file, 0L);
        try {
            df.getMount();
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains(file.getName(), e);
        }
    }

    @Test(timeout=5000L)
    public void testDFMalformedOutput() throws Exception {
        DF df = new DF(new File("/"), 0L);
        BufferedReader reader = new BufferedReader(new StringReader("Filesystem     1K-blocks     Used Available Use% Mounted on\n/dev/sda5       19222656 10597036   7649060  59% /"));
        df.parseExecResult(reader);
        df.parseOutput();
        reader = new BufferedReader(new StringReader("Filesystem     1K-blocks     Used Available Use% Mounted on"));
        df.parseExecResult(reader);
        try {
            df.parseOutput();
            Assert.fail((String)"Expected exception with missing line!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Fewer lines of output than expected", e);
            System.out.println(e.toString());
        }
        reader = new BufferedReader(new StringReader("Filesystem     1K-blocks     Used Available Use% Mounted on\n "));
        df.parseExecResult(reader);
        try {
            df.parseOutput();
            Assert.fail((String)"Expected exception with empty line!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Unexpected empty line", e);
            System.out.println(e.toString());
        }
        reader = new BufferedReader(new StringReader("Filesystem     1K-blocks     Used Available Use% Mounted on\n       19222656 10597036   7649060  59% /"));
        df.parseExecResult(reader);
        try {
            df.parseOutput();
            Assert.fail((String)"Expected exception with missing field!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Could not parse line: ", e);
            System.out.println(e.toString());
        }
    }

    @Test(timeout=5000L)
    public void testGetMountCurrentDirectory() throws Exception {
        File currentDirectory = new File(".");
        String workingDir = currentDirectory.getAbsoluteFile().getCanonicalPath();
        DF df = new DF(new File(workingDir), 0L);
        String mountPath = df.getMount();
        File mountDir = new File(mountPath);
        Assert.assertTrue((String)("Mount dir [" + mountDir.getAbsolutePath() + "] should exist."), (boolean)mountDir.exists());
        Assert.assertTrue((String)("Mount dir [" + mountDir.getAbsolutePath() + "] should be directory."), (boolean)mountDir.isDirectory());
        Assert.assertTrue((String)("Working dir [" + workingDir + "] should start with [" + mountPath + "]."), (boolean)workingDir.startsWith(mountPath));
    }

    public static class XXDF
    extends DF {
        public XXDF() throws IOException {
            super(test_root, 0L);
        }

        protected String[] getExecString() {
            return new String[]{"echo", "IGNORE\n", "/dev/sda3", "453115160", "53037920", "400077240", "11%", "/foo/bar\n"};
        }
    }
}

