/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMappingWithDependency;
import org.junit.Test;

public class TestScriptBasedMappingWithDependency
extends TestCase {
    @Test
    public void testNoArgsMeansNoResult() {
        Configuration conf = new Configuration();
        conf.setInt("net.topology.script.number.args", 0);
        conf.set("net.topology.script.file.name", "any-filename-1");
        conf.set("net.topology.dependency.script.file.name", "any-filename-2");
        conf.setInt("net.topology.script.number.args", 10);
        ScriptBasedMappingWithDependency mapping = this.createMapping(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("some.machine.name");
        names.add("other.machine.name");
        List result = mapping.resolve(names);
        TestScriptBasedMappingWithDependency.assertNull((String)"Expected an empty list for resolve", (Object)result);
        result = mapping.getDependency("some.machine.name");
        TestScriptBasedMappingWithDependency.assertNull((String)"Expected an empty list for getDependency", (Object)result);
    }

    @Test
    public void testNoFilenameMeansSingleSwitch() throws Throwable {
        Configuration conf = new Configuration();
        ScriptBasedMappingWithDependency mapping = this.createMapping(conf);
        TestScriptBasedMappingWithDependency.assertTrue((String)"Expected to be single switch", (boolean)mapping.isSingleSwitch());
        TestScriptBasedMappingWithDependency.assertTrue((String)"Expected to be single switch", (boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping));
    }

    @Test
    public void testFilenameMeansMultiSwitch() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("net.topology.script.file.name", "any-filename");
        ScriptBasedMappingWithDependency mapping = this.createMapping(conf);
        TestScriptBasedMappingWithDependency.assertFalse((String)"Expected to be multi switch", (boolean)mapping.isSingleSwitch());
        mapping.setConf(new Configuration());
        TestScriptBasedMappingWithDependency.assertTrue((String)"Expected to be single switch", (boolean)mapping.isSingleSwitch());
    }

    @Test
    public void testNullConfig() throws Throwable {
        ScriptBasedMappingWithDependency mapping = this.createMapping(null);
        TestScriptBasedMappingWithDependency.assertTrue((String)"Expected to be single switch", (boolean)mapping.isSingleSwitch());
    }

    private ScriptBasedMappingWithDependency createMapping(Configuration conf) {
        ScriptBasedMappingWithDependency mapping = new ScriptBasedMappingWithDependency();
        mapping.setConf(conf);
        return mapping;
    }
}

