/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

class MakeDeleteEntries
extends MasterRepo {
    private static final long serialVersionUID = 1L;

    MakeDeleteEntries() {
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        log.info((Object)"creating delete entries for merged metadata tablets");
        Connector conn = master.getConnector();
        BatchWriter bw = conn.createBatchWriter("!METADATA", new BatchWriterConfig());
        String tableDir = Constants.getMetadataTableDir((AccumuloConfiguration)master.getConfiguration().getConfiguration());
        for (FileStatus fs : master.getFileSystem().listStatus(new Path(tableDir))) {
            if (!fs.isDir() || !fs.getPath().getName().matches("^t-.*")) continue;
            bw.addMutation(MetadataTable.createDeleteMutation("!0", "/" + fs.getPath().getName()));
        }
        bw.close();
        return null;
    }
}

