/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metanalysis;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.server.logger.LogFileKey;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class LogFileOutputFormat
extends FileOutputFormat<LogFileKey, LogFileValue> {
    public RecordWriter<LogFileKey, LogFileValue> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Path outputPath = this.getDefaultWorkFile(context, "");
        return new LogFileRecordWriter(outputPath);
    }

    private static class LogFileRecordWriter
    extends RecordWriter<LogFileKey, LogFileValue> {
        private FSDataOutputStream out;

        public LogFileRecordWriter(Path outputPath) throws IOException {
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            this.out = fs.create(outputPath);
        }

        public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
            this.out.close();
        }

        public void write(LogFileKey key, LogFileValue val) throws IOException, InterruptedException {
            key.write((DataOutput)this.out);
            val.write((DataOutput)this.out);
        }
    }
}

