/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class SecurityConstants {
    private static SecurityPermission SYSTEM_CREDENTIALS_PERMISSION = new SecurityPermission("systemCredentialsPermission");
    static Logger log = Logger.getLogger(SecurityConstants.class);
    public static final String SYSTEM_PRINCIPAL = "!SYSTEM";
    private static final AuthenticationToken SYSTEM_TOKEN = SecurityConstants.makeSystemPassword();
    private static final TCredentials systemCredentials = CredentialHelper.createSquelchError((String)"!SYSTEM", (AuthenticationToken)SYSTEM_TOKEN, (String)HdfsZooInstance.getInstance().getInstanceID());
    public static byte[] confChecksum = null;

    public static AuthenticationToken getSystemToken() {
        return SYSTEM_TOKEN;
    }

    public static TCredentials getSystemCredentials() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SYSTEM_CREDENTIALS_PERMISSION);
        }
        return systemCredentials;
    }

    public static String getSystemPrincipal() {
        return SYSTEM_PRINCIPAL;
    }

    private static AuthenticationToken makeSystemPassword() {
        int wireVersion = Constants.WIRE_VERSION;
        byte[] inst = HdfsZooInstance.getInstance().getInstanceID().getBytes(Constants.UTF8);
        try {
            confChecksum = SecurityConstants.getSystemConfigChecksum();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute configuration checksum", e);
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(12 + inst.length + confChecksum.length);
        DataOutputStream out = new DataOutputStream(bytes);
        try {
            out.write(wireVersion * -1);
            out.write(inst.length);
            out.write(inst);
            out.write(confChecksum.length);
            out.write(confChecksum);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new PasswordToken(Base64.encodeBase64((byte[])bytes.toByteArray()));
    }

    private static byte[] getSystemConfigChecksum() throws NoSuchAlgorithmException {
        if (confChecksum == null) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(Constants.WIRE_VERSION.toString().getBytes(Constants.UTF8));
            md.update(HdfsZooInstance.getInstance().getInstanceID().getBytes(Constants.UTF8));
            for (Map.Entry entry : ServerConfiguration.getSiteConfiguration()) {
                if (!((String)entry.getKey()).startsWith(Property.INSTANCE_PREFIX.toString())) continue;
                md.update(((String)entry.getKey()).getBytes(Constants.UTF8));
                md.update(((String)entry.getValue()).getBytes(Constants.UTF8));
            }
            confChecksum = md.digest();
        }
        return confChecksum;
    }
}

