/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.trace;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.trace.TraceFormatter;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.AccumuloClassLoader;
import org.apache.accumulo.trace.thrift.RemoteSpan;
import org.apache.accumulo.trace.thrift.SpanReceiver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class TraceServer
implements Watcher {
    private static final Logger log = Logger.getLogger(TraceServer.class);
    private final ServerConfiguration serverConfiguration;
    private final TServer server;
    private BatchWriter writer = null;
    private Connector connector;
    final String table;

    private static void put(Mutation m, String cf, String cq, byte[] bytes, int len) {
        m.put(new Text(cf), new Text(cq), new Value(bytes, 0, len));
    }

    public TraceServer(ServerConfiguration serverConfiguration, String hostname) throws Exception {
        this.serverConfiguration = serverConfiguration;
        AccumuloConfiguration conf = serverConfiguration.getConfiguration();
        this.table = conf.get(Property.TRACE_TABLE);
        while (true) {
            try {
                PasswordToken at;
                String principal = conf.get(Property.TRACE_USER);
                Map loginMap = conf.getAllPropertiesWithPrefix(Property.TRACE_TOKEN_PROPERTY_PREFIX);
                if (loginMap.isEmpty()) {
                    Property p = Property.TRACE_PASSWORD;
                    at = new PasswordToken(conf.get(p).getBytes());
                } else {
                    AuthenticationToken.Properties props = new AuthenticationToken.Properties();
                    AuthenticationToken token = AccumuloClassLoader.getClassLoader().loadClass(conf.get(Property.TRACE_TOKEN_TYPE)).asSubclass(AuthenticationToken.class).newInstance();
                    int prefixLength = Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey().length() + 1;
                    for (Map.Entry entry : loginMap.entrySet()) {
                        props.put(((String)entry.getKey()).substring(prefixLength), (CharSequence)entry.getValue());
                    }
                    token.init(props);
                    at = token;
                }
                this.connector = serverConfiguration.getInstance().getConnector(principal, (AuthenticationToken)at);
                if (!this.connector.tableOperations().exists(this.table)) {
                    this.connector.tableOperations().create(this.table);
                }
                this.connector.tableOperations().setProperty(this.table, Property.TABLE_FORMATTER_CLASS.getKey(), TraceFormatter.class.getName());
            }
            catch (Exception ex) {
                log.info((Object)("waiting to checking/create the trace table: " + ex));
                UtilWaitThread.sleep((long)1000L);
                continue;
            }
            break;
        }
        int port = conf.getPort(Property.TRACE_PORT);
        ServerSocket sock = ServerSocketChannel.open().socket();
        sock.setReuseAddress(true);
        sock.bind(new InetSocketAddress(port));
        TServerSocket transport = new TServerSocket(sock);
        TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)transport);
        options.processor((TProcessor)new SpanReceiver.Processor((SpanReceiver.Iface)new Receiver()));
        this.server = new TThreadPoolServer(options);
        InetSocketAddress address = new InetSocketAddress(hostname, sock.getLocalPort());
        this.registerInZooKeeper(AddressUtil.toString((InetSocketAddress)address));
        this.writer = this.connector.createBatchWriter(this.table, new BatchWriterConfig().setMaxLatency(5L, TimeUnit.SECONDS));
    }

    public void run() throws Exception {
        SimpleTimer.getInstance().schedule(new Runnable(){

            @Override
            public void run() {
                TraceServer.this.flush();
            }
        }, 1000L, 1000L);
        this.server.serve();
    }

    private void flush() {
        try {
            this.writer.flush();
        }
        catch (MutationsRejectedException e) {
            log.error((Object)"Error flushing traces", (Throwable)e);
            this.resetWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetWriter() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error closing batch writer", (Throwable)ex);
        }
        finally {
            this.writer = null;
            try {
                this.writer = this.connector.createBatchWriter(this.table, new BatchWriterConfig());
            }
            catch (Exception ex) {
                log.error((Object)("Unable to create a batch writer: " + ex));
            }
        }
    }

    private void registerInZooKeeper(String name) throws Exception {
        String root = ZooUtil.getRoot((Instance)this.serverConfiguration.getInstance()) + "/tracers";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        String path = zoo.putEphemeralSequential(root + "/trace-", name.getBytes());
        zoo.exists(path, this);
    }

    public static void main(String[] args) throws Exception {
        SecurityUtil.serverLogin();
        Instance instance = HdfsZooInstance.getInstance();
        ServerConfiguration conf = new ServerConfiguration(instance);
        FileSystem fs = FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)conf.getConfiguration());
        Accumulo.init(fs, conf, "tracer");
        String hostname = Accumulo.getLocalAddress(args);
        TraceServer server = new TraceServer(conf, hostname);
        Accumulo.enableTracing(hostname, "tserver");
        server.run();
        log.info((Object)"tracer stopping");
    }

    public void process(WatchedEvent event) {
        log.debug((Object)("event " + event.getPath() + " " + event.getType() + " " + event.getState()));
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            log.warn((Object)("Trace server lost zookeeper registration at " + event.getPath()));
            this.server.stop();
        } else if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
            log.warn((Object)("Trace server zookeeper entry lost " + event.getPath()));
            this.server.stop();
        }
        if (event.getPath() != null) {
            try {
                if (ZooReaderWriter.getInstance().exists(event.getPath(), this)) {
                    return;
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
            log.warn((Object)"Trace server unable to reset watch on zookeeper registration");
            this.server.stop();
        }
    }

    class Receiver
    implements SpanReceiver.Iface {
        Receiver() {
        }

        public void span(RemoteSpan s) throws TException {
            String idString = Long.toHexString(s.traceId);
            String startString = Long.toHexString(s.start);
            Mutation spanMutation = new Mutation(new Text(idString));
            Mutation indexMutation = new Mutation(new Text("idx:" + s.svc + ":" + startString));
            long diff = s.stop - s.start;
            indexMutation.put(new Text(s.description), new Text(s.sender), new Value((idString + ":" + Long.toHexString(diff)).getBytes()));
            ByteArrayTransport transport = new ByteArrayTransport();
            TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
            s.write((TProtocol)protocol);
            String parentString = Long.toHexString(s.parentId);
            if (s.parentId == 0L) {
                parentString = "";
            }
            TraceServer.put(spanMutation, "span", parentString + ":" + Long.toHexString(s.spanId), transport.get(), transport.len());
            Mutation timeMutation = null;
            if (s.parentId == 0L) {
                timeMutation = new Mutation(new Text("start:" + startString));
                TraceServer.put(timeMutation, "id", idString, transport.get(), transport.len());
            }
            try {
                if (TraceServer.this.writer == null) {
                    TraceServer.this.resetWriter();
                }
                if (TraceServer.this.writer == null) {
                    return;
                }
                TraceServer.this.writer.addMutation(spanMutation);
                TraceServer.this.writer.addMutation(indexMutation);
                if (timeMutation != null) {
                    TraceServer.this.writer.addMutation(timeMutation);
                }
            }
            catch (Exception ex) {
                log.error((Object)("Unable to write mutation to table: " + spanMutation), (Throwable)ex);
            }
        }
    }

    static class ByteArrayTransport
    extends TTransport {
        TByteArrayOutputStream out = new TByteArrayOutputStream();

        ByteArrayTransport() {
        }

        public boolean isOpen() {
            return true;
        }

        public void open() throws TTransportException {
        }

        public void close() {
        }

        public int read(byte[] buf, int off, int len) {
            return 0;
        }

        public void write(byte[] buf, int off, int len) throws TTransportException {
            this.out.write(buf, off, len);
        }

        public byte[] get() {
            return this.out.get();
        }

        public int len() {
            return this.out.len();
        }
    }
}

