/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class RemoveEntriesForMissingFiles {
    private static Logger log = Logger.getLogger(RemoveEntriesForMissingFiles.class);

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(RemoveEntriesForMissingFiles.class.getName(), args, new Object[]{scanOpts, bwOpts});
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        Connector connector = opts.getConnector();
        Scanner metadata = connector.createScanner("!METADATA", opts.auths);
        metadata.setBatchSize(scanOpts.scanBatchSize);
        metadata.setRange(Constants.METADATA_KEYSPACE);
        metadata.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        int count = 0;
        int missing = 0;
        BatchWriter writer = null;
        if (opts.fix) {
            writer = connector.createBatchWriter("!METADATA", bwOpts.getBatchWriterConfig());
        }
        for (Map.Entry entry : metadata) {
            Path map;
            ++count;
            Key key = (Key)entry.getKey();
            String table = new String(KeyExtent.tableOfMetadataRow((Text)((Key)entry.getKey()).getRow()));
            String file = key.getColumnQualifier().toString();
            if (!file.startsWith("/")) {
                file = "/" + file;
            }
            if (fs.exists(map = new Path(ServerConstants.getTablesDir() + "/" + table + file))) continue;
            ++missing;
            log.info((Object)("File " + map + " is missing"));
            Mutation m = new Mutation(key.getRow());
            m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
            if (writer == null) continue;
            writer.addMutation(m);
            log.info((Object)("entry removed from metadata table: " + m));
        }
        if (writer != null && missing > 0) {
            writer.close();
        }
        log.info((Object)String.format("%d files of %d missing", missing, count));
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--fix"})
        boolean fix = false;

        Opts() {
        }
    }
}

