/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class RegexpNode
extends Node
implements ILiteralNode {
    private RubyRegexp pattern;
    private final ByteList value;
    private final RegexpOptions options;

    public RegexpNode(ISourcePosition position, ByteList value2, RegexpOptions options2) {
        super(position);
        this.value = value2;
        this.options = options2;
    }

    public Encoding getEncoding() {
        return this.value.getEncoding();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.REGEXPNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRegexpNode(this);
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    public ByteList getValue() {
        return this.value;
    }

    public RubyRegexp loadPattern(Ruby runtime) {
        if (this.pattern == null || runtime.getKCode() != this.pattern.getKCode()) {
            this.setPattern(RubyRegexp.newRegexp(runtime, this.value, this.options));
        }
        return this.pattern;
    }

    public void setPattern(RubyRegexp p2) {
        this.pattern = p2;
        this.pattern.setLiteral();
    }

    public RubyRegexp getPattern() {
        return this.pattern;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return this.loadPattern(runtime);
    }
}

