/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import org.apache.pig.ErrorHandler;
import org.apache.pig.ErrorHandling;
import org.apache.pig.LoadFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;

public class LoadFuncDecorator {
    private final LoadFunc loader;
    private final String udfSignature;
    private boolean shouldHandleErrors;
    private ErrorHandler errorHandler;

    public LoadFuncDecorator(LoadFunc loader, String udfSignature) {
        this.loader = loader;
        this.udfSignature = udfSignature;
        this.init();
    }

    private void init() {
        if (UDFContext.getUDFContext().isFrontend()) {
            return;
        }
        if (this.loader instanceof ErrorHandling && this.allowErrors()) {
            this.errorHandler = ((ErrorHandling)((Object)this.loader)).getErrorHandler();
            this.shouldHandleErrors = true;
        }
    }

    private boolean allowErrors() {
        return UDFContext.getUDFContext().getJobConf().getBoolean("pig.error-handling.enabled", false);
    }

    public Tuple getNext() throws IOException {
        Tuple t = null;
        try {
            t = this.loader.getNext();
            if (this.shouldHandleErrors) {
                this.errorHandler.onSuccess(this.udfSignature);
            }
        }
        catch (Exception e) {
            if (this.shouldHandleErrors) {
                this.errorHandler.onError(this.udfSignature, e);
            }
            throw new IOException(e);
        }
        return t;
    }

    public LoadFunc getLoader() {
        return this.loader;
    }

    public boolean getErrorHandling() {
        return this.shouldHandleErrors;
    }
}

