/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.UnsupportedEncodingException;
import javax.crypto.SecretKey;
import org.apache.hadoop.hbase.security.token.AuthenticationKey;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestAuthenticationKey {
    @Test
    public void test() throws UnsupportedEncodingException {
        SecretKey secret = (SecretKey)Mockito.mock(SecretKey.class);
        Mockito.when((Object)secret.getEncoded()).thenReturn((Object)"secret".getBytes("UTF-8"));
        AuthenticationKey key = new AuthenticationKey(0, 1234L, secret);
        Assert.assertEquals((long)key.hashCode(), (long)new AuthenticationKey(0, 1234L, secret).hashCode());
        Assert.assertEquals((Object)key, (Object)new AuthenticationKey(0, 1234L, secret));
        AuthenticationKey otherID = new AuthenticationKey(1, 1234L, secret);
        Assert.assertNotEquals((long)key.hashCode(), (long)otherID.hashCode());
        Assert.assertNotEquals((Object)key, (Object)otherID);
        AuthenticationKey otherExpiry = new AuthenticationKey(0, 8765L, secret);
        Assert.assertNotEquals((long)key.hashCode(), (long)otherExpiry.hashCode());
        Assert.assertNotEquals((Object)key, (Object)otherExpiry);
        SecretKey other = (SecretKey)Mockito.mock(SecretKey.class);
        Mockito.when((Object)secret.getEncoded()).thenReturn((Object)"other".getBytes("UTF-8"));
        AuthenticationKey otherSecret = new AuthenticationKey(0, 1234L, other);
        Assert.assertNotEquals((long)key.hashCode(), (long)otherSecret.hashCode());
        Assert.assertNotEquals((Object)key, (Object)otherSecret);
    }
}

