/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.common.util.Backoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);

    public static <T> void retryAsynchronously(Supplier<CompletableFuture<T>> supplier, Backoff backoff, ScheduledExecutorService scheduledExecutorService, CompletableFuture<T> callback) {
        if (backoff.getMax() <= 0L) {
            throw new IllegalArgumentException("Illegal max retry time");
        }
        if (backoff.getInitial() <= 0L) {
            throw new IllegalArgumentException("Illegal initial time");
        }
        scheduledExecutorService.execute(() -> RetryUtil.executeWithRetry(supplier, backoff, scheduledExecutorService, callback));
    }

    private static <T> void executeWithRetry(Supplier<CompletableFuture<T>> supplier, Backoff backoff, ScheduledExecutorService scheduledExecutorService, CompletableFuture<T> callback) {
        supplier.get().whenComplete((result, e) -> {
            if (e != null) {
                long next = backoff.next();
                boolean isMandatoryStop = backoff.isMandatoryStopMade();
                if (isMandatoryStop) {
                    callback.completeExceptionally((Throwable)e);
                } else {
                    log.warn("Execution with retry fail, because of {}, will retry in {} ms", (Object)e.getMessage(), (Object)next);
                    scheduledExecutorService.schedule(() -> RetryUtil.lambda$executeWithRetry$1((Supplier)supplier, backoff, scheduledExecutorService, callback), next, TimeUnit.MILLISECONDS);
                }
                return;
            }
            callback.complete(result);
        });
    }

    private static /* synthetic */ void lambda$executeWithRetry$1(Supplier supplier, Backoff backoff, ScheduledExecutorService scheduledExecutorService, CompletableFuture callback) {
        RetryUtil.executeWithRetry(supplier, backoff, scheduledExecutorService, callback);
    }
}

