/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.util;

import org.apache.qpid.protonj2.engine.util.SequenceNumber;
import org.apache.qpid.protonj2.types.UnsignedInteger;

public class DeliveryIdTracker
extends Number
implements Comparable<DeliveryIdTracker> {
    private static final long serialVersionUID = -334270502498254343L;
    private int deliveryId;
    private boolean empty = true;

    public DeliveryIdTracker() {
    }

    public DeliveryIdTracker(int startValue) {
        this.deliveryId = startValue;
        this.empty = false;
    }

    public void set(int value) {
        this.deliveryId = value;
        this.empty = false;
    }

    public void reset() {
        this.deliveryId = 0;
        this.empty = true;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public int compareTo(Number other) {
        if (this.isEmpty()) {
            return -1;
        }
        return Integer.compareUnsigned(this.intValue(), other.intValue());
    }

    @Override
    public int compareTo(int other) {
        if (this.isEmpty()) {
            return -1;
        }
        return Integer.compareUnsigned(this.intValue(), other);
    }

    @Override
    public int compareTo(DeliveryIdTracker other) {
        if (this.isEmpty() || other.isEmpty()) {
            return -1;
        }
        return Integer.compareUnsigned(this.intValue(), other.deliveryId);
    }

    @Override
    public int intValue() {
        return this.deliveryId;
    }

    @Override
    public long longValue() {
        return Integer.toUnsignedLong(this.deliveryId);
    }

    @Override
    public float floatValue() {
        return Float.intBitsToFloat(this.deliveryId);
    }

    @Override
    public double doubleValue() {
        return Float.floatToIntBits(this.deliveryId);
    }

    public boolean equals(Object other) {
        if (other instanceof DeliveryIdTracker) {
            return ((DeliveryIdTracker)other).deliveryId == this.deliveryId;
        }
        if (other instanceof SequenceNumber) {
            return ((SequenceNumber)other).intValue() == this.deliveryId;
        }
        if (other instanceof UnsignedInteger) {
            return ((UnsignedInteger)other).intValue() == this.deliveryId;
        }
        return false;
    }

    public boolean equals(int other) {
        return Integer.compareUnsigned(this.deliveryId, other) == 0;
    }

    public int hashCode() {
        return Integer.hashCode(this.deliveryId);
    }

    public UnsignedInteger toUnsignedInteger() {
        return this.empty ? null : UnsignedInteger.valueOf(this.deliveryId);
    }

    public String toString() {
        return Integer.toUnsignedString(this.deliveryId);
    }
}

