/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.util.Preconditions;

public class BinaryExpression
implements Expression {
    private final Op op;
    private final Expression left;
    private final Expression right;

    BinaryExpression(byte[] buf, int offset) {
        Preconditions.assertTrue(buf[offset] == Expression.Type.BINARY.byteValue());
        this.op = Op.valueOf(buf[offset + 1]);
        this.left = Expression.Utils.bytes2Expression(buf, offset + 2);
        this.right = Expression.Utils.bytes2Expression(buf, offset + 2 + this.left.length());
    }

    public BinaryExpression(Op op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public int toBytes(byte[] buf, int offset) {
        buf[offset] = Expression.Type.BINARY.byteValue();
        buf[offset + 1] = this.op.byteValue();
        int l = this.left.toBytes(buf, offset + 2);
        int r = this.right.toBytes(buf, offset + 2 + l);
        return 2 + l + r;
    }

    @Override
    public int length() {
        return 2 + this.left.length() + this.right.length();
    }

    @Override
    public Double evaluate(Map<String, Double> variableMap) {
        double l = this.left.evaluate(variableMap);
        double r = this.right.evaluate(variableMap);
        switch (this.op) {
            case ADD: {
                return l + r;
            }
            case SUBTRACT: {
                return l - r;
            }
            case MULT: {
                return l * r;
            }
            case DIV: {
                return l / r;
            }
        }
        throw new AssertionError((Object)("Unexpected op value: " + this.op));
    }

    public String toString() {
        return "(" + this.left + " " + this.op + " " + this.right + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        return this.op == that.op && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(this.op);
    }

    public static enum Op implements BinaryOperator<Expression>
    {
        ADD("+"),
        SUBTRACT("-"),
        MULT("*"),
        DIV("/");

        private final String symbol;
        static final Op[] VALUES;

        private Op(String symbol) {
            this.symbol = symbol;
        }

        byte byteValue() {
            return (byte)this.ordinal();
        }

        @Override
        public BinaryExpression apply(Expression l, Expression r) {
            return new BinaryExpression(this, l, r);
        }

        @Override
        public BinaryExpression apply(double l, Expression r) {
            return this.apply((Expression)new DoubleValue(l), r);
        }

        @Override
        public BinaryExpression apply(Expression l, double r) {
            return this.apply(l, (Expression)new DoubleValue(r));
        }

        @Override
        public BinaryExpression apply(double l, double r) {
            return this.apply((Expression)new DoubleValue(l), (Expression)new DoubleValue(r));
        }

        public String toString() {
            return this.symbol;
        }

        static Op valueOf(byte b) {
            Preconditions.assertTrue(b < VALUES.length);
            return VALUES[b];
        }

        public String getSymbol() {
            return this.symbol;
        }

        static {
            VALUES = Op.values();
        }
    }
}

