/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelId;

class ChannelMap {
    private final Map<ChannelId, Map<ClientInvocationId, ClientInvocationId>> map = new ConcurrentHashMap<ChannelId, Map<ClientInvocationId, ClientInvocationId>>();

    ChannelMap() {
    }

    void add(ChannelId channelId, ClientInvocationId clientInvocationId) {
        this.map.computeIfAbsent(channelId, e -> new ConcurrentHashMap()).put(clientInvocationId, clientInvocationId);
    }

    void remove(ChannelId channelId, ClientInvocationId clientInvocationId) {
        Optional.ofNullable(this.map.get(channelId)).ifPresent(ids -> {
            ClientInvocationId cfr_ignored_0 = (ClientInvocationId)ids.remove(clientInvocationId);
        });
    }

    Set<ClientInvocationId> remove(ChannelId channelId) {
        return Optional.ofNullable(this.map.remove(channelId)).map(Map::keySet).orElse(Collections.emptySet());
    }
}

