/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.or;

import org.apache.log4j.Layout;
import org.apache.log4j.or.ObjectRenderer;

public class ThreadGroupRenderer
implements ObjectRenderer {
    public String doRender(Object o) {
        if (o instanceof ThreadGroup) {
            StringBuilder sbuf = new StringBuilder();
            ThreadGroup tg = (ThreadGroup)o;
            sbuf.append("java.lang.ThreadGroup[name=");
            sbuf.append(tg.getName());
            sbuf.append(", maxpri=");
            sbuf.append(tg.getMaxPriority());
            sbuf.append("]");
            Thread[] t2 = new Thread[tg.activeCount()];
            tg.enumerate(t2);
            for (int i = 0; i < t2.length; ++i) {
                sbuf.append(Layout.LINE_SEP);
                sbuf.append("   Thread=[");
                sbuf.append(t2[i].getName());
                sbuf.append(",");
                sbuf.append(t2[i].getPriority());
                sbuf.append(",");
                sbuf.append(t2[i].isDaemon());
                sbuf.append("]");
            }
            return sbuf.toString();
        }
        try {
            return o.toString();
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }
}

