/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.util.List;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.sling.maven.feature.launcher.Launch;
import org.apache.sling.maven.feature.launcher.ProcessTracker;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo
extends AbstractMojo {
    @Parameter(required=true)
    private List<Launch> launches;
    @Component
    private ProcessTracker processes;
    @Parameter(property="feature-launcher.waitForInput", required=false, defaultValue="false")
    protected boolean waitForInput;
    @Component
    private Prompter prompter;
    @Parameter(defaultValue="${session.request}", readonly=true)
    private MavenExecutionRequest executionRequest;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.waitForInput) {
            if (this.executionRequest.isInteractiveMode()) {
                this.waitForUserInput();
            } else {
                this.getLog().warn((CharSequence)"Don't wait for user input as Maven is not running in interactive mode");
            }
        }
        try {
            for (Launch launch : this.launches) {
                if (launch.isSkip()) {
                    this.getLog().info((CharSequence)("Skipping stopping launch with id " + launch.getId()));
                    continue;
                }
                this.getLog().info((CharSequence)("Stopping launch with id " + launch.getId()));
                this.processes.stop(launch.getId());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void waitForUserInput() throws MojoFailureException {
        try {
            String message = MessageUtils.buffer().warning((Object)"Waiting for user input before build continues...").toString();
            this.getLog().warn((CharSequence)message);
            this.prompter.prompt("Press Enter to continue");
        }
        catch (PrompterException e) {
            throw new MojoFailureException("Could not prompt for user input. Do not use parameter 'waitForInput' in that case", (Throwable)e);
        }
    }
}

