% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{repartitionByRange}
\alias{repartitionByRange}
\alias{repartitionByRange,SparkDataFrame-method}
\title{Repartition by range}
\usage{
repartitionByRange(x, ...)

\S4method{repartitionByRange}{SparkDataFrame}(x, numPartitions = NULL, col = NULL, ...)
}
\arguments{
\item{x}{a SparkDataFrame.}

\item{...}{additional column(s) to be used in the range partitioning.}

\item{numPartitions}{the number of partitions to use.}

\item{col}{the column by which the range partitioning will be performed.}
}
\description{
The following options for repartition by range are possible:
\itemize{
 \item{1.} {Return a new SparkDataFrame range partitioned by
                     the given columns into \code{numPartitions}.}
 \item{2.} {Return a new SparkDataFrame range partitioned by the given column(s),
                     using \code{spark.sql.shuffle.partitions} as number of partitions.}
}
At least one partition-by expression must be specified.
When no explicit sort order is specified, "ascending nulls first" is assumed.
}
\details{
Note that due to performance reasons this method uses sampling to estimate the ranges.
Hence, the output may not be consistent, since sampling can return different values.
The sample size can be controlled by the config
\code{spark.sql.execution.rangeExchange.sampleSizePerPartition}.
}
\note{
repartitionByRange since 2.4.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
newDF <- repartitionByRange(df, col = df$col1, df$col2)
newDF <- repartitionByRange(df, 3L, col = df$col1, df$col2)
}
}
\seealso{
\link{repartition}, \link{coalesce}

Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapply}()},
\code{\link{dapplyCollect}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{drop}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{dtypes}()},
\code{\link{except}()},
\code{\link{exceptAll}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapply}()},
\code{\link{gapplyCollect}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersect}()},
\code{\link{intersectAll}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{select}()},
\code{\link{selectExpr}()},
\code{\link{show}()},
\code{\link{showDF}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{union}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{unpersist}()},
\code{\link{unpivot}()},
\code{\link{with}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
