/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.HeapNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.HeapNonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.HeapWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.Util;

final class HeapWritableBufferImpl
extends NativeWritableBufferImpl {
    private static final int id = 64;
    private final Object unsafeObj;
    private final MemoryRequestServer memReqSvr;
    private final byte typeId;

    HeapWritableBufferImpl(Object unsafeObj, long regionOffset, long capacityBytes, int typeId, MemoryRequestServer memReqSvr) {
        super(unsafeObj, 0L, regionOffset, capacityBytes);
        this.unsafeObj = unsafeObj;
        this.memReqSvr = memReqSvr;
        this.typeId = (byte)(0x40 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = HeapWritableBufferImpl.setReadOnlyType(this.typeId, readOnly) | 2;
        return Util.isNativeByteOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type, this.memReqSvr) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = HeapWritableBufferImpl.setReadOnlyType(this.typeId, readOnly) | 4;
        return Util.isNativeByteOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.memReqSvr) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.memReqSvr);
    }

    @Override
    BaseWritableMemoryImpl toWritableMemory(boolean readOnly, ByteOrder byteOrder) {
        byte type = HeapWritableBufferImpl.setReadOnlyType(this.typeId, readOnly);
        return Util.isNativeByteOrder(byteOrder) ? new HeapWritableMemoryImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.memReqSvr) : new HeapNonNativeWritableMemoryImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.memReqSvr);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

