/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class LineageInfo
implements NodeProcessor {
    TreeSet<String> inputTableList = new TreeSet();
    TreeSet<String> OutputTableList = new TreeSet();

    public TreeSet<String> getInputTableList() {
        return this.inputTableList;
    }

    public TreeSet<String> getOutputTableList() {
        return this.OutputTableList;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        ASTNode pt = (ASTNode)nd;
        switch (pt.getToken().getType()) {
            case 948: {
                this.OutputTableList.add(BaseSemanticAnalyzer.getUnescapedName((ASTNode)pt.getChild(0)));
                break;
            }
            case 977: {
                ASTNode tabTree = (ASTNode)pt.getChild(0);
                String table_name = tabTree.getChildCount() == 1 ? BaseSemanticAnalyzer.getUnescapedName((ASTNode)tabTree.getChild(0)) : BaseSemanticAnalyzer.getUnescapedName((ASTNode)tabTree.getChild(0)) + "." + tabTree.getChild(1);
                this.inputTableList.add(table_name);
            }
        }
        return null;
    }

    public void getLineageInfo(String query) throws ParseException, SemanticException {
        ASTNode tree = ParseUtils.parse(query, null);
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        this.inputTableList.clear();
        this.OutputTableList.clear();
        LinkedHashMap<Rule, NodeProcessor> rules = new LinkedHashMap<Rule, NodeProcessor>();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this, rules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(tree);
        ogw.startWalking(topNodes, null);
    }

    public static void main(String[] args) throws IOException, ParseException, SemanticException {
        String query = args[0];
        LineageInfo lep = new LineageInfo();
        lep.getLineageInfo(query);
        for (String tab : lep.getInputTableList()) {
            System.out.println("InputTable=" + tab);
        }
        for (String tab : lep.getOutputTableList()) {
            System.out.println("OutputTable=" + tab);
        }
    }
}

