/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUtil;

class ItemsPmfCdfImpl {
    ItemsPmfCdfImpl() {
    }

    static <T> double[] getPMFOrCDF(ItemsSketch<T> sketch, T[] splitPoints, boolean isCDF) {
        double[] buckets = ItemsPmfCdfImpl.internalBuildHistogram(splitPoints, sketch);
        long n = sketch.getN();
        if (isCDF) {
            double subtotal = 0.0;
            for (int j = 0; j < buckets.length; ++j) {
                buckets[j] = (subtotal += buckets[j]) / (double)n;
            }
        } else {
            int j = 0;
            while (j < buckets.length) {
                int n2 = j++;
                buckets[n2] = buckets[n2] / (double)n;
            }
        }
        return buckets;
    }

    private static <T> double[] internalBuildHistogram(T[] splitPoints, ItemsSketch<T> sketch) {
        long myBitPattern;
        Object[] samples = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        ItemsUtil.validateValues(splitPoints, sketch.getComparator());
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        double[] counters = new double[numCounters];
        long weight = 1L;
        if (numSplitPoints < 50) {
            ItemsPmfCdfImpl.bilinearTimeIncrementHistogramCounters(samples, 0, bbCount, weight, splitPoints, counters, sketch.getComparator());
        } else {
            Arrays.sort(samples, 0, bbCount, sketch.getComparator());
            ItemsPmfCdfImpl.linearTimeIncrementHistogramCounters(samples, 0, bbCount, weight, splitPoints, counters, sketch.getComparator());
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight <<= 1;
            if ((myBitPattern & 1L) > 0L) {
                ItemsPmfCdfImpl.linearTimeIncrementHistogramCounters(samples, (2 + lvl) * k, k, weight, splitPoints, counters, sketch.getComparator());
            }
            ++lvl;
        }
        return counters;
    }

    private static <T> void bilinearTimeIncrementHistogramCounters(T[] samples, int offset, int numSamples, long weight, T[] splitPoints, double[] counters, Comparator<? super T> comparator) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < numSamples; ++i) {
            T splitpoint;
            T sample = samples[i + offset];
            int j = 0;
            for (j = 0; j < splitPoints.length && comparator.compare(sample, splitpoint = splitPoints[j]) >= 0; ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + (double)weight;
        }
    }

    private static <T> void linearTimeIncrementHistogramCounters(T[] samples, int offset, int numSamples, long weight, T[] splitPoints, double[] counters, Comparator<? super T> comparator) {
        int i = 0;
        int j = 0;
        while (i < numSamples && j < splitPoints.length) {
            if (comparator.compare(samples[i + offset], splitPoints[j]) < 0) {
                int n = j;
                counters[n] = counters[n] + (double)weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + (double)(weight * (long)(numSamples - i));
        }
    }
}

