% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{write.stream}
\alias{write.stream}
\alias{write.stream,SparkDataFrame-method}
\title{Write the streaming SparkDataFrame to a data source.}
\usage{
write.stream(df, source = NULL, outputMode = NULL, ...)

\S4method{write.stream}{SparkDataFrame}(
  df,
  source = NULL,
  outputMode = NULL,
  partitionBy = NULL,
  trigger.processingTime = NULL,
  trigger.once = NULL,
  ...
)
}
\arguments{
\item{df}{a streaming SparkDataFrame.}

\item{source}{a name for external data source.}

\item{outputMode}{one of 'append', 'complete', 'update'.}

\item{...}{additional external data source specific named options.}

\item{partitionBy}{a name or a list of names of columns to partition the output by on the file
system. If specified, the output is laid out on the file system similar to Hive's
partitioning scheme.}

\item{trigger.processingTime}{a processing time interval as a string, e.g. '5 seconds',
'1 minute'. This is a trigger that runs a query periodically based on the processing
time. If value is '0 seconds', the query will run as fast as possible, this is the
default. Only one trigger can be set.}

\item{trigger.once}{a logical, must be set to \code{TRUE}. This is a trigger that processes only
one batch of data in a streaming query then terminates the query. Only one trigger can be
set.}
}
\description{
The data source is specified by the \code{source} and a set of options (...).
If \code{source} is not specified, the default data source configured by
spark.sql.sources.default will be used.
}
\details{
Additionally, \code{outputMode} specifies how data of a streaming SparkDataFrame is written to a
output data source. There are three modes:
\itemize{
  \item append: Only the new rows in the streaming SparkDataFrame will be written out. This
                output mode can be only be used in queries that do not contain any aggregation.
  \item complete: All the rows in the streaming SparkDataFrame will be written out every time
                  there are some updates. This output mode can only be used in queries that
                  contain aggregations.
  \item update: Only the rows that were updated in the streaming SparkDataFrame will be written
                out every time there are some updates. If the query doesn't contain aggregations,
                it will be equivalent to \code{append} mode.
}
}
\note{
write.stream since 2.2.0

experimental
}
\examples{
\dontrun{
sparkR.session()
df <- read.stream("socket", host = "localhost", port = 9999)
isStreaming(df)
wordCounts <- count(group_by(df, "value"))

# console
q <- write.stream(wordCounts, "console", outputMode = "complete")
# text stream
q <- write.stream(df, "text", path = "/home/user/out", checkpointLocation = "/home/user/cp",
                  partitionBy = c("year", "month"), trigger.processingTime = "30 seconds")
# memory stream
q <- write.stream(wordCounts, "memory", queryName = "outs", outputMode = "complete")
head(sql("SELECT * from outs"))
queryName(q)

stopQuery(q)
}
}
\seealso{
\link{read.stream}

Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapplyCollect}()},
\code{\link{dapply}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{drop}()},
\code{\link{dtypes}()},
\code{\link{exceptAll}()},
\code{\link{except}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapplyCollect}()},
\code{\link{gapply}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersectAll}()},
\code{\link{intersect}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartitionByRange}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{selectExpr}()},
\code{\link{select}()},
\code{\link{showDF}()},
\code{\link{show}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{union}()},
\code{\link{unpersist}()},
\code{\link{unpivot}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{with}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
