/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.cdx.CdxFields;
import org.netpreserve.jwarc.cdx.CdxFormat;

public class CdxRecord {
    private final String[] values;
    private final CdxFormat format;

    CdxRecord(String line, CdxFormat format) throws IOException {
        this.values = line.split(" ");
        if (format != null) {
            this.format = format;
        } else if (this.values.length == 9) {
            this.format = CdxFormat.CDX9;
        } else if (this.values.length == 10) {
            this.format = CdxFormat.CDX10;
        } else if (this.values.length == 11) {
            this.format = CdxFormat.CDX11;
        } else {
            throw new IOException("Unable to determine the CDX format");
        }
    }

    public String get(int field) {
        int i = this.format.indexOf(field);
        if (i == -1) {
            return null;
        }
        String value = this.values[i];
        return value.equals("-") ? null : value;
    }

    public Instant date() {
        String value = this.get(98);
        return value == null ? null : CdxFields.DATE_FORMAT.parse((CharSequence)value, Instant::from);
    }

    public String filename() {
        return this.get(103);
    }

    public String target() {
        return this.get(97);
    }

    public URI targetURI() {
        String value = this.target();
        return value == null ? null : URIs.parseLeniently(value);
    }

    public Long size() {
        String value = this.get(83);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Long position() {
        String value = this.get(86);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Integer status() {
        String value = this.get(115);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public String digest() {
        return this.get(107);
    }

    public String redirect() {
        return this.get(114);
    }

    public MediaType contentType() {
        String value = this.get(109);
        return value == null ? null : MediaType.parseLeniently(value);
    }
}

