/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ApplicationObjectInputStream;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.context.ExternalContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializationProviderFactory {
    private static final SerializationProvider JAVA_PROVIDER = new JavaSerializationProvider();
    private static final String SERIALIZATION_PROVIDER_PROPERTY = "com.sun.faces.SerializationProvider";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public static SerializationProvider createInstance(ExternalContext extContext) {
        String providerClass = SerializationProviderFactory.findProviderClass(extContext);
        SerializationProvider provider = SerializationProviderFactory.getProviderInstance(providerClass);
        if (provider.getClass() != JavaSerializationProvider.class && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "faces.spi.serialization.provider_configured", new Object[]{provider.getClass().getName()});
        }
        return provider;
    }

    private static SerializationProvider getProviderInstance(String className) {
        SerializationProvider provider;
        block8: {
            provider = JAVA_PROVIDER;
            if (className != null) {
                try {
                    Class clazz = Util.loadClass(className, SerializationProviderFactory.class);
                    if (SerializationProviderFactory.implementsSerializationProvider(clazz)) {
                        provider = (SerializationProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "faces.spi.serialization.provider_not_implemented", new Object[]{className});
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "faces.spi.serialization.provider_not_found", new Object[]{className});
                    }
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, "faces.spi.serialization.provider_cannot_instantiate", new Object[]{className});
                    LOGGER.log(Level.SEVERE, "", ie);
                }
            }
        }
        return provider;
    }

    private static boolean implementsSerializationProvider(Class<?> clazz) {
        return SerializationProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext extContext) {
        WebConfiguration webConfig = WebConfiguration.getInstance(extContext);
        String provider = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.SerializationProviderClass);
        if (provider != null) {
            return provider;
        }
        return System.getProperty(SERIALIZATION_PROVIDER_PROPERTY);
    }

    private static final class JavaSerializationProvider
    implements SerializationProvider {
        private JavaSerializationProvider() {
        }

        @Override
        public ObjectOutputStream createObjectOutputStream(OutputStream destination) throws IOException {
            return new ObjectOutputStream(destination);
        }

        @Override
        public ObjectInputStream createObjectInputStream(InputStream source) throws IOException {
            return new ApplicationObjectInputStream(source);
        }
    }
}

