/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NamingException;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.tomcat.InstanceManager;

public class Tomcat7AnnotationInjectionProvider
extends InjectionProvider {
    private WeakHashMap<ClassLoader, InstanceManager> instanceManagers = new WeakHashMap();

    public Tomcat7AnnotationInjectionProvider(ExternalContext externalContext) {
    }

    @Override
    public Object inject(Object instance) throws InjectionProviderException {
        return null;
    }

    @Override
    public void preDestroy(Object instance, Object creationMetaData) throws InjectionProviderException {
        InstanceManager manager = this.instanceManagers.get(ClassUtils.getContextClassLoader());
        if (manager != null) {
            try {
                manager.destroyInstance(instance);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new InjectionProviderException(ex);
            }
        }
    }

    @Override
    public void postConstruct(Object instance, Object creationMetaData) throws InjectionProviderException {
        InstanceManager manager = this.instanceManagers.get(ClassUtils.getContextClassLoader());
        if (manager == null) {
            manager = this.initManager();
        }
        if (manager != null) {
            try {
                manager.newInstance(instance);
            }
            catch (IllegalAccessException | InvocationTargetException | NamingException ex) {
                throw new InjectionProviderException(ex);
            }
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            FacesContext facesContext;
            Class c = ClassUtils.classForName("org.apache.tomcat.InstanceManager");
            return c == null || !ExternalSpecifications.isCDIAvailable((facesContext = FacesContext.getCurrentInstance()).getExternalContext());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private InstanceManager initManager() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return null;
        }
        ExternalContext extCtx = context.getExternalContext();
        if (extCtx == null) {
            return null;
        }
        Map applicationMap = extCtx.getApplicationMap();
        InstanceManager instanceManager = (InstanceManager)applicationMap.get(InstanceManager.class.getName());
        if (instanceManager != null) {
            this.instanceManagers.put(ClassUtils.getContextClassLoader(), instanceManager);
        }
        return instanceManager;
    }
}

