/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pudl;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInputStream;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFOutputStream;
import de.tu_darmstadt.sp.paul.PDFStream;
import de.tu_darmstadt.sp.paul.PDFTextString;
import de.tu_darmstadt.sp.pudl.Annotation;
import de.tu_darmstadt.sp.pudl.AnnotationFactory;
import de.tu_darmstadt.sp.pudl.DocStructType;
import de.tu_darmstadt.sp.pudl.PDFAnnotationException;
import de.tu_darmstadt.sp.pudl.PDFRectangle;
import de.tu_darmstadt.sp.pudl.PageLabel;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Page
implements DocStructType {
    PDFDictionary pageDict;
    PDFDictionary pageNumber;

    public Page(double llx, double lly, double urx, double ury) {
        this(new PDFRectangle(llx, lly, urx, ury));
    }

    public Page(PDFDictionary dict) {
        this.pageDict = dict;
        this.pageDict.setIndirect();
        this.pageNumber = new PDFDictionary();
    }

    public Page(PDFRectangle mediaBox) {
        this.createPageDict((PDFArray)mediaBox.getRepresentation());
        this.pageNumber = new PDFDictionary();
    }

    public Page(Page otherPage) {
        this.pageDict = new PDFDictionary(otherPage.getPageDictionary());
        this.pageNumber = new PDFDictionary(otherPage.pageNumber);
    }

    public void addAnnot(Annotation annot) {
        annot.getRepresentation().setIndirect();
        PDFDictionary dict = (PDFDictionary)this.getRepresentation();
        try {
            PDFArray annots = (PDFArray)dict.get(PDFName.ANNOTS);
            annots.add(annot.getRepresentation());
        }
        catch (NullPointerException nullPointerException) {
            PDFArray annotsarray = new PDFArray();
            annotsarray.add(annot.getRepresentation());
            dict.put(PDFName.ANNOTS, (PDFObject)annotsarray);
        }
    }

    public void addStream(int index, PDFStream stream) throws IndexOutOfBoundsException {
        stream.setIndirect();
        if (index < 0 || index > this.numStreams()) {
            throw new IndexOutOfBoundsException("called addStream with " + index + " but numStreams()=" + this.numStreams());
        }
        if (this.pageDict.containsKey(PDFName.CONTENTS)) {
            PDFObject contents = this.pageDict.get(PDFName.CONTENTS);
            if (contents instanceof PDFArray) {
                ((PDFArray)contents).add(index, stream);
            } else {
                PDFArray newContents = new PDFArray();
                newContents.add(contents);
                newContents.add(index, stream);
                this.pageDict.put(PDFName.CONTENTS, (PDFObject)newContents);
            }
        } else {
            this.pageDict.put(PDFName.CONTENTS, (PDFObject)stream);
        }
    }

    public void addStream(PDFStream stream) {
        try {
            this.addStream(this.numStreams(), stream);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    public Object clone() {
        return new Page(this);
    }

    private void createPageDict(PDFArray mediaBox) {
        this.pageDict = new PDFDictionary();
        this.pageDict.put(PDFName.TYPE, (PDFObject)PDFName.PAGE);
        this.pageDict.put(PDFName.MEDIABOX, (PDFObject)mediaBox);
        this.pageDict.put(PDFName.RESOURCES, (PDFObject)new PDFDictionary());
        this.pageDict.setIndirect();
    }

    public boolean equiv(Object obj) {
        return obj instanceof Page && this.pageDict.equiv(((Page)obj).getPageDictionary());
    }

    public List getAllAnnots() {
        AnnotationFactory factory = new AnnotationFactory();
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (!this.pageDict.containsKey(PDFName.ANNOTS)) {
            return result;
        }
        PDFObject annots = this.pageDict.get(PDFName.ANNOTS);
        if (annots instanceof PDFArray) {
            int len = ((PDFArray)annots).size();
            int i = 0;
            while (i < len) {
                Annotation annotation = AnnotationFactory.createAnnotation((PDFDictionary)((PDFArray)annots).get(i));
                result.add(annotation);
                ++i;
            }
            return result;
        }
        throw new PDFAnnotationException("invalid Annotation entry in key PAGE.ANNOTS");
    }

    public PDFObject getAttribute(PDFName key) {
        return this.pageDict.get(key);
    }

    public InputStream getContentStream() {
        PDFObject cont = this.pageDict.get(PDFName.CONTENTS);
        if (cont instanceof PDFStream) {
            if (cont instanceof PDFInputStream) {
                return ((PDFInputStream)cont).getInputStream();
            }
            return new PDFInputStream((PDFOutputStream)cont).getInputStream();
        }
        if (cont instanceof PDFArray) {
            Vector<InputStream> allStreams = new Vector<InputStream>();
            int i = 0;
            while (i < ((PDFArray)cont).size()) {
                if (((PDFArray)cont).get(i) instanceof PDFInputStream) {
                    allStreams.add(((PDFInputStream)((PDFArray)cont).get(i)).getInputStream());
                } else {
                    allStreams.add(new PDFInputStream((PDFOutputStream)((PDFArray)cont).get(i)).getInputStream());
                }
                ++i;
            }
            return new SequenceInputStream(allStreams.elements());
        }
        throw new RuntimeException("wrong content descibtion");
    }

    public List getContents() {
        PDFObject cont = this.pageDict.get(PDFName.CONTENTS);
        if (cont instanceof PDFStream) {
            ArrayList<PDFObject> contList = new ArrayList<PDFObject>();
            contList.add(cont);
            return contList;
        }
        if (cont instanceof PDFArray) {
            ArrayList<PDFObject> contList = new ArrayList<PDFObject>();
            int i = 0;
            while (i < ((PDFArray)cont).size()) {
                contList.add(((PDFArray)cont).get(i));
                ++i;
            }
            return contList;
        }
        throw new RuntimeException("wrong content descibtion");
    }

    public PDFRectangle getMediaBox() {
        return new PDFRectangle((PDFArray)this.pageDict.get(PDFName.MEDIABOX));
    }

    public PDFDictionary getPageDictionary() {
        return new PDFDictionary(this.pageDict);
    }

    public PDFObject getRepresentation() {
        return this.pageDict;
    }

    public void moveAnnotTo(Annotation t, Page p) {
        p.addAnnot(t);
        this.remAnnot(t);
    }

    public int numStreams() {
        PDFObject contents = this.pageDict.get(PDFName.CONTENTS);
        if (contents == null) {
            return 0;
        }
        if (contents instanceof PDFArray) {
            return ((PDFArray)contents).size();
        }
        return 1;
    }

    public void remAnnot(Annotation annot) {
        PDFDictionary dict = (PDFDictionary)this.getRepresentation();
        if (dict.containsKey(PDFName.ANNOTS)) {
            PDFArray annots = (PDFArray)dict.get(PDFName.ANNOTS);
            int i = annots.size() - 1;
            while (i >= 0) {
                if (annot.getRepresentation().equiv(annots.get(i))) {
                    annots.remove(i);
                }
                --i;
            }
            if (annots.size() == 0) {
                dict.remove(PDFName.ANNOTS);
            }
        } else {
            return;
        }
    }

    public void removeAllStreams() {
        this.pageDict.remove(PDFName.CONTENTS);
    }

    public void setAttribute(PDFName key, PDFObject val) {
        this.pageDict.put(key, val);
    }

    public void setPageNumber(char style) {
        PDFName getStyle = PageLabel.getValidStyle(style);
        if (getStyle != null) {
            this.pageNumber.put(PDFName.S, (PDFObject)getStyle);
        }
    }

    public void setPageNumber(char style, String prefix, int number) {
        this.setPageNumber(style);
        this.setPageNumber(prefix);
        this.setPageNumber(number);
    }

    public void setPageNumber(int number) {
        this.pageNumber.put(PDFName.St, (PDFObject)PDFInteger.forInt(number));
    }

    public void setPageNumber(String prefix) {
        if (!prefix.equals("")) {
            this.pageNumber.put("P", (PDFObject)new PDFTextString(prefix));
        }
    }
}

