#!/usr/bin/env perl

use strict;
use warnings;
use FASTX::Reader;

my $file = $ARGV[0] || 't/test.fa';

my $parser = FASTX::Reader->new({ filename => "$file" });

my $seq_count = 0;
my $total_length = 0;

while (my $seq = $parser->getRead()) {
    $seq_count++;
    $total_length += length($seq->{seq});
}

print "Number of sequences: $seq_count\n";
print "Total length: $total_length\n";
