# Generated by default/object.tt
package Paws::Macie2::S3Bucket;
  use Moose;
  has AllowsUnencryptedObjectUploads => (is => 'ro', isa => 'Str', request_name => 'allowsUnencryptedObjectUploads', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has DefaultServerSideEncryption => (is => 'ro', isa => 'Paws::Macie2::ServerSideEncryption', request_name => 'defaultServerSideEncryption', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Owner => (is => 'ro', isa => 'Paws::Macie2::S3BucketOwner', request_name => 'owner', traits => ['NameInRequest']);
  has PublicAccess => (is => 'ro', isa => 'Paws::Macie2::BucketPublicAccess', request_name => 'publicAccess', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::KeyValuePair]', request_name => 'tags', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::S3Bucket

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::S3Bucket object:

  $service_obj->Method(Att1 => { AllowsUnencryptedObjectUploads => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::S3Bucket object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowsUnencryptedObjectUploads

=head1 DESCRIPTION

Provides information about the S3 bucket that a finding applies to.

=head1 ATTRIBUTES


=head2 AllowsUnencryptedObjectUploads => Str

Specifies whether the bucket policy for the bucket requires server-side
encryption of objects when objects are uploaded to the bucket. Possible
values are:

=over

=item *

FALSE - The bucket policy requires server-side encryption of new
objects. PutObject requests must include the
x-amz-server-side-encryption header and the value for that header must
be AES256 or aws:kms.

=item *

TRUE - The bucket doesn't have a bucket policy or it has a bucket
policy that doesn't require server-side encryption of new objects. If a
bucket policy exists, it doesn't require PutObject requests to include
the x-amz-server-side-encryption header and it doesn't require the
value for that header to be AES256 or aws:kms.

=item *

UNKNOWN - Amazon Macie can't determine whether the bucket policy
requires server-side encryption of objects.

=back



=head2 Arn => Str

The Amazon Resource Name (ARN) of the bucket.


=head2 CreatedAt => Str

The date and time, in UTC and extended ISO 8601 format, when the bucket
was created.


=head2 DefaultServerSideEncryption => L<Paws::Macie2::ServerSideEncryption>

The type of server-side encryption that's used by default to encrypt
objects in the bucket.


=head2 Name => Str

The name of the bucket.


=head2 Owner => L<Paws::Macie2::S3BucketOwner>

The display name and Amazon Web Services account ID for the user who
owns the bucket.


=head2 PublicAccess => L<Paws::Macie2::BucketPublicAccess>

The permissions settings that determine whether the bucket is publicly
accessible.


=head2 Tags => ArrayRef[L<Paws::Macie2::KeyValuePair>]

The tags that are associated with the bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

