/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;

public class Shape
implements Positionable,
IShapePseudo,
Hideable {
    private final ShapeType type;
    private final double width;
    private final double height;
    private final String uid;
    private final int color;
    private double minX;
    private double minY;
    private final int shield;
    private final EntityPosition entityPosition;
    private final IEntityImage image;
    private Cluster cluster;
    private final boolean top;

    public EntityPosition getEntityPosition() {
        return this.entityPosition;
    }

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Shape(IEntityImage iEntityImage, ShapeType shapeType, double d, double d2, ColorSequence colorSequence, boolean bl, int n, EntityPosition entityPosition) {
        this.entityPosition = entityPosition;
        this.image = iEntityImage;
        this.top = bl;
        this.type = shapeType;
        this.width = d;
        this.height = d2;
        this.color = colorSequence.getValue();
        this.uid = String.format("sh%04d", this.color);
        this.shield = n;
        if (n > 0 && shapeType != ShapeType.RECTANGLE) {
            throw new IllegalArgumentException();
        }
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public void appendShape(StringBuilder stringBuilder) {
        if (this.type == ShapeType.RECTANGLE && this.shield > 0) {
            this.appendHtml(stringBuilder);
            return;
        }
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        this.appendShapeInternal(stringBuilder);
        stringBuilder.append(",");
        stringBuilder.append("label=\"\"");
        stringBuilder.append(",");
        stringBuilder.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        stringBuilder.append(",");
        stringBuilder.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        stringBuilder.append(",");
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.color) + "\"");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendHtml(StringBuilder stringBuilder) {
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        stringBuilder.append("shape=plaintext,");
        stringBuilder.append("label=<");
        this.appendLabelHtml(stringBuilder);
        stringBuilder.append(">");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendLabelHtml(StringBuilder stringBuilder) {
        stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder);
        this.appendTd(stringBuilder, this.shield, this.shield);
        this.appendTd(stringBuilder);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder, this.shield, this.shield);
        stringBuilder.append("<TD BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\"");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + this.getHeight() + "\"");
        stringBuilder.append(" PORT=\"h\">");
        stringBuilder.append("</TD>");
        this.appendTd(stringBuilder, this.shield, this.shield);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder);
        this.appendTd(stringBuilder, this.shield, this.shield);
        this.appendTd(stringBuilder);
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    private void appendTd(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append("<TD");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + n + "\" HEIGHT=\"" + n2 + "\"");
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
    }

    private void appendTd(StringBuilder stringBuilder) {
        stringBuilder.append("<TD>");
        stringBuilder.append("</TD>");
    }

    private void appendShapeInternal(StringBuilder stringBuilder) {
        if (this.type == ShapeType.RECTANGLE && this.shield > 0) {
            throw new UnsupportedOperationException();
        }
        if (this.type == ShapeType.RECTANGLE) {
            stringBuilder.append("shape=rect");
        } else if (this.type == ShapeType.DIAMOND) {
            stringBuilder.append("shape=diamond");
        } else if (this.type == ShapeType.CIRCLE) {
            stringBuilder.append("shape=circle");
        } else if (this.type == ShapeType.CIRCLE_IN_RECT) {
            stringBuilder.append("shape=circle");
        } else if (this.type == ShapeType.OVAL) {
            stringBuilder.append("shape=ellipse");
        } else if (this.type == ShapeType.ROUND_RECTANGLE) {
            stringBuilder.append("shape=rect,style=rounded");
        } else {
            throw new IllegalStateException(this.type.toString());
        }
    }

    public final String getUid() {
        if (this.uid == null) {
            throw new IllegalStateException();
        }
        return this.uid;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public IEntityImage getImage() {
        return this.image;
    }

    public final boolean isTop() {
        return this.top;
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.minX, this.minY);
    }

    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
    }

    public boolean isShielded() {
        return this.shield > 0;
    }

    public void moveSvek(double d, double d2) {
        this.minX += d;
        this.minY += d2;
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        EntityImageStateBorder entityImageStateBorder = (EntityImageStateBorder)this.image;
        return entityImageStateBorder.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    public boolean isHidden() {
        return this.image.isHidden();
    }
}

