/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.ColumnFilter;

public class NonNumericToWildcardFilter
implements ColumnFilter {
    static final int STATE_NUMBERS = 0;
    static final int STATE_NON_NUMBERS = 1;
    char wildcard = (char)37;
    boolean leadingWildcard = false;
    boolean trailingWildcard = false;

    public static ColumnFilter getInstance() {
        return new NonNumericToWildcardFilter();
    }

    public void setWildcardCharacter(char wild) {
        this.wildcard = wild;
    }

    public void setForceLeadingWildcard(boolean enabled) {
        this.leadingWildcard = enabled;
    }

    public void setForceTrailingWildcard(boolean enabled) {
        this.trailingWildcard = enabled;
    }

    @Override
    public String filter(String in) {
        boolean state = false;
        StringBuffer out = new StringBuffer(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch < '0' || ch > '9') {
                if (!state) {
                    out.append(this.wildcard);
                }
                state = true;
                continue;
            }
            out.append(ch);
            state = false;
        }
        if (out.charAt(0) != this.wildcard) {
            out.insert(0, this.wildcard);
        }
        if (out.charAt(out.length() - 1) != this.wildcard) {
            out.append(this.wildcard);
        }
        return out.toString();
    }
}

