/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.util.Monitorable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ProgressWatcher
implements ActionListener {
    private JProgressBar bar = null;
    private boolean hideProgressBarWhenFinished = false;
    private ProgressMonitor pm = null;
    private Monitorable monitorable = null;
    private JLabel label = null;
    private boolean hideLabelWhenFinished = false;
    private Timer timer;
    private static final Logger logger = Logger.getLogger(ProgressWatcher.class);

    public ProgressWatcher(JProgressBar bar, Monitorable monitorable) {
        this(bar, monitorable, null);
    }

    public ProgressWatcher(JProgressBar bar, Monitorable monitorable, JLabel label) {
        this.bar = bar;
        this.monitorable = monitorable;
        this.label = label;
    }

    public ProgressWatcher(ProgressMonitor pm, Monitorable monitorable) {
        this.pm = pm;
        this.monitorable = monitorable;
    }

    public void start() {
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public static void watchProgress(JProgressBar bar, Monitorable monitorable) {
        ProgressWatcher watcher = new ProgressWatcher(bar, monitorable);
        watcher.start();
    }

    public static void watchProgress(JProgressBar bar, Monitorable monitorable, JLabel label) {
        ProgressWatcher watcher = new ProgressWatcher(bar, monitorable, label);
        watcher.start();
    }

    public static void watchProgress(ProgressMonitor pm, Monitorable monitorable) {
        ProgressWatcher watcher = new ProgressWatcher(pm, monitorable);
        watcher.start();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        logger.debug((Object)"updating progress bar...");
        Integer jobSize = this.monitorable.getJobSize();
        if (this.bar != null) {
            if (this.monitorable.hasStarted()) {
                if (jobSize == null) {
                    this.bar.setIndeterminate(true);
                } else {
                    this.bar.setIndeterminate(false);
                    this.bar.setMaximum(jobSize);
                    this.bar.setValue(this.monitorable.getProgress());
                }
                this.bar.setVisible(true);
            }
            if (this.monitorable.isFinished() && this.hideProgressBarWhenFinished) {
                this.bar.setVisible(false);
            }
        }
        if (this.label != null) {
            this.label.setVisible(true);
            this.label.setText(this.monitorable.getMessage());
        }
        if (this.pm != null && this.monitorable.hasStarted()) {
            this.monitorable.setCancelled(this.pm.isCanceled());
            if (jobSize != null) {
                this.pm.setMaximum(jobSize);
            }
            this.pm.setProgress(this.monitorable.getProgress());
            logger.debug((Object)("progress: " + this.monitorable.getProgress()));
            this.pm.setNote(this.monitorable.getMessage());
        }
        logger.debug((Object)("monitorable.isFinished():" + this.monitorable.isFinished()));
        if (this.monitorable.isFinished()) {
            if (this.label != null && this.hideLabelWhenFinished) {
                this.label.setText("");
            }
            if (this.bar != null) {
                this.bar.setValue(0);
                this.bar.setIndeterminate(false);
            }
            if (this.pm != null) {
                logger.debug((Object)("pm done, max was: " + this.pm.getMaximum()));
                this.pm.close();
            }
            logger.debug((Object)"trying to stop timer thread...");
            this.timer.stop();
            logger.debug((Object)"did the timer thread stop???");
        }
    }

    public boolean isHideProgressBarWhenFinished() {
        return this.hideProgressBarWhenFinished;
    }

    public void setHideProgressBarWhenFinished(boolean hideProgressBarWhenFinished) {
        this.hideProgressBarWhenFinished = hideProgressBarWhenFinished;
    }

    public boolean isHideLabelWhenFinished() {
        return this.hideLabelWhenFinished;
    }

    public void setHideLabelWhenFinished(boolean hideLabelWhenFinished) {
        this.hideLabelWhenFinished = hideLabelWhenFinished;
    }
}

