/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemoveLocalFromSSA
extends StatedTransformer {
    static <T extends Value> void replaceAssign(List<AssignStmt> assignStmtList, Map<Local, T> toReplace) {
        for (AssignStmt as : assignStmtList) {
            Value right = as.getOp2();
            Value to = (Value)toReplace.get(right);
            if (to == null) continue;
            as.setOp2(to);
        }
    }

    private boolean simpleAssign(List<LabelStmt> phiLabels, List<AssignStmt> assignStmtList, Map<Local, Local> toReplace, StmtList stmts) {
        HashSet<Value> usedInPhi = new HashSet<Value>();
        if (phiLabels != null) {
            for (LabelStmt labelStmt : phiLabels) {
                for (AssignStmt phi : labelStmt.phis) {
                    usedInPhi.addAll(Arrays.asList(phi.getOp2().getOps()));
                }
            }
        }
        boolean changed = false;
        Iterator<AssignStmt> it = assignStmtList.iterator();
        while (it.hasNext()) {
            AssignStmt as = it.next();
            if (usedInPhi.contains(as.getOp1())) continue;
            it.remove();
            stmts.remove(as);
            toReplace.put((Local)as.getOp1(), (Local)as.getOp2());
            changed = true;
        }
        return changed;
    }

    private void replacePhi(List<LabelStmt> phiLabels, Map<Local, Local> toReplace, Set<Value> set) {
        if (phiLabels != null) {
            for (LabelStmt labelStmt : phiLabels) {
                for (AssignStmt phi : labelStmt.phis) {
                    Value[] ops;
                    Value[] valueArray = ops = phi.getOp2().getOps();
                    int n = ops.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Value op = valueArray[n2];
                        Value n3 = toReplace.get(op);
                        if (n3 != null) {
                            set.add(n3);
                        } else {
                            set.add(op);
                        }
                        ++n2;
                    }
                    set.remove(phi.getOp1());
                    phi.getOp2().setOps(set.toArray(new Value[set.size()]));
                    set.clear();
                }
            }
        }
    }

    public static PhiObject getOrCreate(Map<Local, PhiObject> map, Local local) {
        PhiObject po = map.get(local);
        if (po == null) {
            po = new PhiObject();
            po.local = local;
            map.put(local, po);
        }
        return po;
    }

    public static void linkPhiObject(PhiObject parent, PhiObject child) {
        parent.children.add(child);
        child.parent.add(parent);
    }

    private boolean simplePhi(List<LabelStmt> phiLabels, Map<Local, Local> toReplace, Set<Value> set) {
        boolean changed = false;
        if (phiLabels != null) {
            Iterator<LabelStmt> itLabel = phiLabels.iterator();
            while (itLabel.hasNext()) {
                LabelStmt labelStmt = itLabel.next();
                Iterator<AssignStmt> it = labelStmt.phis.iterator();
                while (it.hasNext()) {
                    AssignStmt phi = it.next();
                    set.addAll(Arrays.asList(phi.getOp2().getOps()));
                    set.remove(phi.getOp1());
                    if (set.size() == 1) {
                        it.remove();
                        changed = true;
                        toReplace.put((Local)phi.getOp1(), (Local)set.iterator().next());
                    }
                    set.clear();
                }
                if (labelStmt.phis.size() != 0) continue;
                labelStmt.phis = null;
                itLabel.remove();
            }
        }
        return changed;
    }

    private boolean removeLoopFromPhi(List<LabelStmt> phiLabels, Map<Local, Local> toReplace) {
        boolean changed = false;
        if (phiLabels != null) {
            HashSet<Local> toDeletePhiAssign = new HashSet<Local>();
            Map<Local, PhiObject> phis = this.collectPhiObjects(phiLabels);
            UniqueQueue q = new UniqueQueue();
            q.addAll(phis.values());
            while (!q.isEmpty()) {
                PhiObject po = (PhiObject)q.poll();
                for (PhiObject phiObject : po.children) {
                    if (!phiObject.isInitByPhi || !phiObject.parent.addAll(po.parent)) continue;
                    q.add(phiObject);
                }
            }
            for (PhiObject po : phis.values()) {
                if (!po.isInitByPhi) continue;
                Local local = null;
                for (PhiObject p : po.parent) {
                    if (p.isInitByPhi) continue;
                    if (local == null) {
                        local = p.local;
                        continue;
                    }
                    local = null;
                    break;
                }
                if (local == null) continue;
                toReplace.put(po.local, local);
                toDeletePhiAssign.add(po.local);
                changed = true;
            }
            Iterator<LabelStmt> itLabel = phiLabels.iterator();
            while (itLabel.hasNext()) {
                LabelStmt labelStmt = itLabel.next();
                Iterator<AssignStmt> it = labelStmt.phis.iterator();
                while (it.hasNext()) {
                    AssignStmt phi = it.next();
                    if (!toDeletePhiAssign.contains(phi.getOp1())) continue;
                    it.remove();
                }
                if (labelStmt.phis.size() != 0) continue;
                labelStmt.phis = null;
                itLabel.remove();
            }
        }
        return changed;
    }

    private Map<Local, PhiObject> collectPhiObjects(List<LabelStmt> phiLabels) {
        HashMap<Local, PhiObject> phis = new HashMap<Local, PhiObject>();
        for (LabelStmt labelStmt : phiLabels) {
            for (AssignStmt as : labelStmt.phis) {
                Local local = (Local)as.getOp1();
                PhiObject child = RemoveLocalFromSSA.getOrCreate(phis, local);
                child.isInitByPhi = true;
                Value[] valueArray = as.getOp2().getOps();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value op = valueArray[n2];
                    if (op != local) {
                        PhiObject parent = RemoveLocalFromSSA.getOrCreate(phis, (Local)op);
                        RemoveLocalFromSSA.linkPhiObject(parent, child);
                    }
                    ++n2;
                }
            }
        }
        return phis;
    }

    static <T> void fixReplace(Map<Local, T> toReplace) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Map.Entry<Local, T> e : toReplace.entrySet()) {
                T b = e.getValue();
                T n = toReplace.get(b);
                if (n == null || b == n) continue;
                changed = true;
                e.setValue(n);
            }
        }
    }

    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean irChanged = false;
        ArrayList<AssignStmt> assignStmtList = new ArrayList<AssignStmt>();
        List<LabelStmt> phiLabels = method.phiLabels;
        Stmt p = method.stmts.getFirst();
        while (p != null) {
            if (p.st == Stmt.ST.ASSIGN) {
                AssignStmt as = (AssignStmt)p;
                if (as.getOp1().vt == Value.VT.LOCAL && as.getOp2().vt == Value.VT.LOCAL) {
                    assignStmtList.add(as);
                }
            }
            p = p.getNext();
        }
        final HashMap<Local, Local> toReplace = new HashMap<Local, Local>();
        HashSet<Value> set = new HashSet<Value>();
        boolean changed = true;
        while (changed) {
            changed = false;
            if (this.removeLoopFromPhi(phiLabels, toReplace)) {
                RemoveLocalFromSSA.fixReplace(toReplace);
                this.replacePhi(phiLabels, toReplace, set);
            }
            while (this.simplePhi(phiLabels, toReplace, set)) {
                RemoveLocalFromSSA.fixReplace(toReplace);
                this.replacePhi(phiLabels, toReplace, set);
            }
            while (this.simpleAssign(phiLabels, assignStmtList, toReplace, method.stmts)) {
                RemoveLocalFromSSA.fixReplace(toReplace);
                RemoveLocalFromSSA.replaceAssign(assignStmtList, toReplace);
                changed = true;
                irChanged = true;
            }
            this.replacePhi(phiLabels, toReplace, set);
        }
        for (Local local : toReplace.keySet()) {
            method.locals.remove(local);
            irChanged = true;
        }
        if (toReplace.size() > 0) {
            Cfg.travelMod(method.stmts, new Cfg.TravelCallBack(){

                @Override
                public Value onAssign(Local v, AssignStmt as) {
                    return v;
                }

                @Override
                public Value onUse(Local v) {
                    Local n = (Local)toReplace.get(v);
                    return n == null ? v : n;
                }
            }, true);
        }
        return irChanged;
    }

    static class PhiObject {
        Set<PhiObject> parent = new HashSet<PhiObject>();
        Set<PhiObject> children = new HashSet<PhiObject>();
        Local local;
        boolean isInitByPhi = false;

        PhiObject() {
        }
    }
}

