#!/bin/sh
#
# Modfied from the following:
# ptetex3 -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#
# This script searches following automatically.
# -- Japanese TrueType font for xdvi
# -- CMap for dvipdfmx
# It also install essential CMaps which can't found in system directory.


export PATH="$PATH:/bin:/usr/bin:/opt/teTeX/bin"
export TEXDIR=/opt/teTeX
TEXMF=/opt/teTeX/share/texmf
YES=$1
CMAP=$TEXMF/fonts/cmap
TRUETYPE=$TEXMF/fonts/truetype
OPENTYPE=$TEXMF/fonts/opentype
CP="/bin/cp -pf"
LN="/bin/ln -sf"
RM="/bin/rm -f"
MKDIR="/bin/mkdir -p"
RMDIR="/bin/rmdir -p"
MKTEXLSR="/opt/teTeX/bin/texconfig-sys rehash"
UPDMAP="/opt/teTeX/bin/updmap-sys"

perlprint() {
    echo "[rewriting]  $2"
    perl -pi -e "$1" "$2" || exit
}

yesno() {
    test "$YES" = "yes" && return 0
    read REPLY <&2
    case $REPLY in
	y*|Y*) true;;
	*) false;;
    esac
}

# usage: lns dist-link src-dir1 src-dir2 ...
lns() {
    LINK=notyet
    DIST="$1"
    shift
    #echo "DIST=$DIST"
    test -h "$DIST" && return
    while test -n "$1" -a $LINK = "notyet"; do
	#echo "  $1"
	if test -f "$1" -o -d "$1"; then
	    echo ""
	    echo "[$1]"
	    ls -F "$1"
	    echo -n "exec '$LN \"$1\" \"$DIST\"' ? (yes/No) "
	    if yesno; then
		$LN "$1" "$DIST"
		LINK=already
	    fi
	fi
	shift
    done
}

mksymlink(){
    $MKDIR $1
    while read line; do
	case $line in \#*) continue;; esac # skip comment
	eval lns $1/$line
    done
}


setrmlgbm() {
    if test -n "$2"; then
	echo "set '$2' as $1."
	perlprint "s/^replace\\s$1\\s.*/replace $1 $2/" \
	    $TEXMF/xdvi/${P}xdvi.cfg
    else
	echo "$0: No font was found as $1."
	test "$JAPANESE" != "without" -a "$PXDVI" != "echo" && exit 1
    fi
}

rmlgbm() {
    while read FONT; do
	case $FONT in
	    \#*) continue;;
	esac
	case $MINGOTH in
	    xdviRml) MINGOTH=xdviGbm;;
	    *)       MINGOTH=xdviRml;;
	esac
	g=0
	kpsewhich -format 'truetype fonts' $FONT > /dev/null && g=1
	kpsewhich -format 'opentype fonts' $FONT > /dev/null && g=1
	if test $g != 0; then
	    echo "'$FONT' was found as '$MINGOTH'"
	    eval $MINGOTH=$FONT
	fi
    done
    setrmlgbm Ryumin-Light     $xdviRml
    setrmlgbm GothicBBB-Medium $xdviGbm
}


## check if exsit, and install
cmapinstall() {
CMAPDIR=$CMAP/ptetex
# Don't 'cd $1', because kpsewhich searches current directory, too.
    for f in `ls $1`; do
	if kpsewhich --format="cmap files" $f > /dev/null; then
	    kpsewhich --format="cmap files" $f
	else
	    echo "'$f' copying to '$CMAPDIR'"
	    test -d "$CMAPDIR" || mkdir "$CMAPDIR"
	    cp -p $1/$f "$CMAPDIR"
	fi
    done
}

# -----------------------------------

mksymlink $CMAP <<EOF
### ̾  ǥ쥯ȥ/ե
Acrobat4    {/usr,/opt}{,/local,/sfw}{,/lib}/Acrobat4/Resource/CMap
Acrobat5    {/usr,/opt}{,/local,/sfw}{,/lib}/Acrobat5/Resource/Font
Acrobat7    {/usr,/opt}{,/local,/sfw}{,/lib}{,/Adobe}/Acrobat7.0/Resource/CMap
Acrobat8    {/usr,/opt}{,/local,/sfw}{,/lib}{,/Adobe}{/Reader8,/Acrobat8.0}/Resource/CMap
ghostscript /usr{,/local,/sfw}/{share,lib}/ghostscript{,/*}/Resource/CMap
#openwinja   /usr/openwin/lib/locale/ja/X11/Resource/CMap
#openwinko   /usr/openwin/lib/locale/ko/X11/Resource/CMap
#openwinzh   /usr/openwin/lib/locale/zh/X11/Resource/CMap
#openwintw   /usr/openwin/lib/locale/zh_TW.BIG5/X11/Resource/CMap
EOF

mksymlink $TRUETYPE <<EOF
### ̾  ǥ쥯ȥ/ե
x11       /usr{,/local,/X11R7,/pkg}/lib/X11/fonts/truetype
X11       /usr{,/local,/X11R7,/pkg}/lib/X11/fonts/TrueType
X11TTF    /usr{,/local,/X11R7,/pkg}/lib/X11/fonts/TTF
truetype  /usr{,/local}/share/fonts/truetype
TrueType  /usr{,/local}/share/fonts/TrueType
TTF	  /usr{,/local}/share/fonts/TTF
ja        /usr{,/local}/share/fonts/ja/TrueType
japanese  /usr{,/local}/share/fonts/japanese/TrueType
openwin   /usr/openwin/lib/locale/ja/X11/fonts/TT
QtPalmtop /opt/QtPalmtop/lib/X11/fonts/TrueType
f8sazanami-min  /usr/share/fonts/sazanami-fonts-mincho
f8sazanami-goth /usr/share/fonts/sazanami-fonts-gothic
EOF

mksymlink $OPENTYPE <<EOF
### ̾  ǥ쥯ȥ/ե
# for test (contains white space)
hoge "/tmp/hoge hoge"
QtPalmtop /opt/QtPalmtop/lib/X11/fonts/opentype
EOF

echo ""
echo "searching xdvi fonts..."
$MKTEXLSR 2> /dev/null

# xdvi ǻȤեȥե̾Υꥹ
# īΤȥåΤ򣲹԰Ȥ󤹤롣
# Ǹ˸ĤäΤѤ롣
#  the former, more general
#  the latter, higher quality
rmlgbm <<EOF
# in case of no mincho font (mainly for Mandriva)
	umeplus-gothic.ttf
	dummy
	VL-Gothic-Regular.ttf
	dummy
# kochi (distribution stopped)
	kochi-mincho.ttf
	kochi-gothic.ttf
# kochi-subst (former of sazanami)
	kochi-mincho-subst.ttf
	kochi-gothic-subst.ttf
# sazanami http://wiki.fdiary.net/font/?sazanami
	sazanami-mincho.ttf
	sazanami-gothic.ttf
# UmePlus gothic font family (Mandriva Cooker 20080104)
# http://www.geocities.jp/ep3797/modified_fonts_01.html
	dummy
	umeplus-gothic.ttf
# VL gothic font family http://dicey.org/vlgothic/
	dummy
	VL-Gothic-Regular.ttf
# IPA mona http://www.geocities.jp/ipa_mona/
# (opfc-ModuleHP-1.1.1_withIPAMonaFonts-1.0.5.tar.gz)
	ipam-mona.ttf
	ipag-mona.ttf
# IPA font http://ossipedia.ipa.go.jp/ipafont/
	ipam.ttf
	ipag.ttf
# DynaLab
	dfmimp3.ttc
	dfgotp5.ttc
# Windows native
	msmincho.ttc
	msgothic.ttc
# Ricoh TTF
	lxmincho.ttc
	lxgothic.ttc
# Turbo Linux 10
	tlmincho.ttc
	tlgothic.ttc
# Solaris 9
	HG-MinchoL.ttf
	HG-GothicB.ttf
# Solaris 10
	hgmlsun.ttf
	hggbsun.ttf
# Kozuka
	KozMinStd-Regular.otf
	KozGoStd-Regular.otf
	KozMinPro-Regular.otf
	KozGoPro-Medium.otf
	KozMinProVI-Regular.otf
	KozGoProVI-Medium.otf
# Hiragino
	HiraMinPro-W3.otf
	HiraKakuPro-W3.otf
EOF

#echo ""
#echo "searching cmaps..."
#
#cmapinstall ./cmap
#
echo ""
echo "Rebuilding the TeXSystem ..."

$MKTEXLSR 
$UPDMAP  
