/*
  unicode-jp.h -- JIS X 0208 <=> UCS-2 converter
  written by N. Tsuchimura
*/

#ifndef PTEXENC_UNICODE_JP_H
#define PTEXENC_UNICODE_JP_H

#include <kpathsea/c-proto.h>
#include <kpathsea/types.h>

/* convert a JIS X 0208 char to UCS-2 */
extern KPSEDLL int JIStoUCS2 P1H(int jis);

/* convert a UCS-2 char to JIS X 0208 */
extern KPSEDLL int UCS2toJIS P1H(int ucs2);

/* for U+3099 or  U+309A */
extern KPSEDLL int get_voiced_sound P2H(int ucs2, boolean semi);

#define U_BOM			0xFEFF
#define U_REPLACEMENT_CHARACTER	0xFFFD
#define U_VOICED		0x3099
#define U_SEMI_VOICED		0x309A

#endif /* PTEXENC_UNICODE_JP_H */
