/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;

public final class LoadFile
extends Task {
    private File srcFile = null;
    private boolean failOnError = true;
    private String encoding = null;
    private String property = null;
    private final Vector filterChains = new Vector();

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final void setProperty(String property) {
        this.property = property;
    }

    public final void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public final void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute() throws BuildException {
        block20: {
            FileInputStream fis;
            block19: {
                if (this.srcFile == null) {
                    throw new BuildException("source file not defined");
                }
                if (this.property == null) {
                    throw new BuildException("output property not defined");
                }
                fis = null;
                BufferedInputStream bis = null;
                Reader instream = null;
                this.log("loading " + this.srcFile + " into property " + this.property, 3);
                long len = this.srcFile.length();
                this.log("file size = " + len, 4);
                int size = (int)len;
                fis = new FileInputStream(this.srcFile);
                bis = new BufferedInputStream(fis);
                instream = this.encoding == null ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, this.encoding);
                String text = "";
                if (size != 0) {
                    ChainReaderHelper crh = new ChainReaderHelper();
                    crh.setBufferSize(size);
                    crh.setPrimaryReader(instream);
                    crh.setFilterChains(this.filterChains);
                    crh.setProject(this.getProject());
                    instream = crh.getAssembledReader();
                    text = crh.readFully(instream);
                }
                if (text == null || text.length() <= 0) break block19;
                this.getProject().setNewProperty(this.property, text);
                this.log("loaded " + text.length() + " characters", 3);
                this.log(this.property + " := " + text, 4);
            }
            Object var10_9 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                break block20;
            }
            catch (IOException ioex) {}
            break block20;
            {
                catch (IOException ioe) {
                    String message = "Unable to load file: " + ioe.toString();
                    if (this.failOnError) {
                        throw new BuildException(message, ioe, this.getLocation());
                    }
                    this.log(message, 0);
                    Object var10_10 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block20;
                    }
                    catch (IOException ioex) {}
                    break block20;
                }
                catch (BuildException be) {
                    if (this.failOnError) {
                        throw be;
                    }
                    this.log(be.getMessage(), 0);
                    Object var10_11 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block20;
                    }
                    catch (IOException ioex) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public final void addFilterChain(FilterChain filter) {
        this.filterChains.addElement(filter);
    }
}

