#
# This file is part of Dist-Zilla-Plugin-Git
#
# This software is copyright (c) 2009 by Jerome Quelin.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
# This Makefile.PL for Dist-Zilla-Plugin-Git was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.010;
use ExtUtils::MakeMaker;

# this section comes from Makefile.git.PL and is inserted into Makefile.PL
# Git 1.5.4 introduced the --exclude-standard option to git ls-files,
# which Git::Check needs to work properly.
use version;
my $need_version = version->parse('1.5.4');
eval {
  my $git_version = `git --version` or die "Unable to execute git\n";
  $git_version =~ /git \s+ version \s* ( \d+ (?: \.\d+ )+ )( [-.]rc\d+)?/x
      or die "Unable to determine git version\n";
  my $rc = $2 || '';

  $git_version = version->parse("$1");
  die "git $need_version or later required, you have $git_version$rc\n"
      if $git_version < $need_version or $git_version == $need_version and $rc;
  1;
} or do {
  print $@;

  if (parse_args()->{FORCE_INSTALL}) {
    print "FORCE_INSTALL specified, attempting to install anyway.\n";
  } else {
    print <<"END MESSAGE";
\nDist::Zilla::Plugin::Git requires git $need_version or later in your PATH,
and it wasn't found.  If you want to install anyway, run

  PERL_MM_OPT=FORCE_INSTALL $^X Makefile.PL
END MESSAGE

    exit 0;                  # Indicate missing non-Perl prerequisite
  } # end else not FORCE_INSTALL
}; # end do when Git prerequisite is not met

sub parse_args {
  require ExtUtils::MakeMaker;
  require Text::ParseWords;
  ExtUtils::MakeMaker::parse_args(
    my $tmp = {},
    Text::ParseWords::shellwords($ENV{PERL_MM_OPT} || ''),
    @ARGV,
  );
  return $tmp->{ARGS} || {};
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Update your git repository after release",
  "AUTHOR" => "Jerome Quelin",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "Text::ParseWords" => 0,
    "version" => 0
  },
  "DISTNAME" => "Dist-Zilla-Plugin-Git",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME" => "Dist::Zilla::Plugin::Git",
  "PREREQ_PM" => {
    "Cwd" => 0,
    "DateTime" => 0,
    "Dist::Zilla" => 4,
    "Dist::Zilla::Plugin::GatherDir" => "4.200016",
    "Dist::Zilla::Role::AfterBuild" => 0,
    "Dist::Zilla::Role::AfterMint" => 0,
    "Dist::Zilla::Role::AfterRelease" => 0,
    "Dist::Zilla::Role::BeforeRelease" => 0,
    "Dist::Zilla::Role::FilePruner" => 0,
    "Dist::Zilla::Role::GitConfig" => 0,
    "Dist::Zilla::Role::PluginBundle" => 0,
    "Dist::Zilla::Role::VersionProvider" => 0,
    "File::Spec::Functions" => 0,
    "File::Temp" => 0,
    "File::chdir" => 0,
    "Git::Wrapper" => "0.021",
    "IPC::Open3" => 0,
    "IPC::System::Simple" => 0,
    "List::Util" => "1.45",
    "Module::Runtime" => 0,
    "Moose" => 0,
    "Moose::Role" => 0,
    "MooseX::Has::Sugar" => 0,
    "Path::Tiny" => "0.048",
    "String::Formatter" => 0,
    "Try::Tiny" => 0,
    "Type::Utils" => 0,
    "Types::Path::Tiny" => 0,
    "Types::Standard" => 0,
    "Version::Next" => 0,
    "constant" => 0,
    "namespace::autoclean" => "0.09",
    "strict" => 0,
    "version" => "0.80",
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "CPAN::Meta::Check" => "0.011",
    "CPAN::Meta::Requirements" => 0,
    "Dist::Zilla::File::InMemory" => 0,
    "Dist::Zilla::Plugin::Config::Git" => 0,
    "Dist::Zilla::Role::Releaser" => 0,
    "Dist::Zilla::Tester" => 0,
    "Encode" => 0,
    "Exporter" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Copy" => 0,
    "File::Copy::Recursive" => 0,
    "File::Path" => "2.07",
    "File::Spec" => 0,
    "File::Which" => 0,
    "File::pushd" => 0,
    "Log::Dispatchouli" => 0,
    "Test::DZil" => 0,
    "Test::Fatal" => 0,
    "Test::More" => "0.88",
    "lib" => 0,
    "utf8" => 0
  },
  "VERSION" => "2.048",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "CPAN::Meta::Check" => "0.011",
  "CPAN::Meta::Requirements" => 0,
  "Cwd" => 0,
  "DateTime" => 0,
  "Dist::Zilla" => 4,
  "Dist::Zilla::File::InMemory" => 0,
  "Dist::Zilla::Plugin::Config::Git" => 0,
  "Dist::Zilla::Plugin::GatherDir" => "4.200016",
  "Dist::Zilla::Role::AfterBuild" => 0,
  "Dist::Zilla::Role::AfterMint" => 0,
  "Dist::Zilla::Role::AfterRelease" => 0,
  "Dist::Zilla::Role::BeforeRelease" => 0,
  "Dist::Zilla::Role::FilePruner" => 0,
  "Dist::Zilla::Role::GitConfig" => 0,
  "Dist::Zilla::Role::PluginBundle" => 0,
  "Dist::Zilla::Role::Releaser" => 0,
  "Dist::Zilla::Role::VersionProvider" => 0,
  "Dist::Zilla::Tester" => 0,
  "Encode" => 0,
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Copy" => 0,
  "File::Copy::Recursive" => 0,
  "File::Path" => "2.07",
  "File::Spec" => 0,
  "File::Spec::Functions" => 0,
  "File::Temp" => 0,
  "File::Which" => 0,
  "File::chdir" => 0,
  "File::pushd" => 0,
  "Git::Wrapper" => "0.021",
  "IPC::Open3" => 0,
  "IPC::System::Simple" => 0,
  "List::Util" => "1.45",
  "Log::Dispatchouli" => 0,
  "Module::Runtime" => 0,
  "Moose" => 0,
  "Moose::Role" => 0,
  "MooseX::Has::Sugar" => 0,
  "Path::Tiny" => "0.048",
  "String::Formatter" => 0,
  "Test::DZil" => 0,
  "Test::Fatal" => 0,
  "Test::More" => "0.88",
  "Try::Tiny" => 0,
  "Type::Utils" => 0,
  "Types::Path::Tiny" => 0,
  "Types::Standard" => 0,
  "Version::Next" => 0,
  "constant" => 0,
  "lib" => 0,
  "namespace::autoclean" => "0.09",
  "strict" => 0,
  "utf8" => 0,
  "version" => "0.80",
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
