//start of LhaInputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaInputStream.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.util.Properties;
import jp.gr.java_conf.dangan.io.LimitedInputStream;
import jp.gr.java_conf.dangan.io.DisconnectableInputStream;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;

//import exceptions
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.NullPointerException;

import java.lang.Error;


/**
 * ڑꂽXg[LHAɃf[^ǂ݂݁A
 * Gg𓀂ǂݍނ߂̃[eBeBNXB<br>
 * java.util.zip.ZipInputStream ƎC^[tFCX悤ɍB<br>
 * ꂽɂ̏ɊւĂ͉ꂽGgȍ~
 * ĂȂGgɓǂ݂߂Ȃ\B<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaInputStream.java,v $
 * Revision 1.1.2.1  2003/07/20 13:22:31  dangan
 * [bug fix]
 *     getNextEntry()  CompressMethod.connectDecoder  
 *     this.limit nׂƂ this.in nĂB
 *
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [maintenance]
 *     LhaConstants  CompressMethod ւ̃NX̕ύXɍ킹ďCB
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     RXgN^  String encode ̂p~A
 *     Properties Ɏ̂ǉB
 *     ɏI[ɒBꍇ͂ȏǂݍ߂Ȃ悤ɏCB
 *     available() ̐U镑 java.util.zip.ZipInputStream Ɠ悤
 *     Gg̏I[ɒBĂȂꍇ 1 Gg̏I[ɒBꍇ 0 Ԃ悤ɕύXB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1.2.1 $
 */
public class LhaInputStream extends InputStream{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream source
    //  private boolean alreadyOpenedFirstEnrty
    //  private boolean reachedEndOfArchive
    //------------------------------------------------------------------
    /**
     * LHAɌ`̃f[^InputStreamB
     */
    private InputStream source;

    /**
     * ɍŏ̃Ggǂݍł邩B
     */
    private boolean alreadyOpenedFirstEnrty;

    /**
     * ɏI[ɒBB
     */
    private boolean reachedEndOfArchive;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  for taking out a file from the archive
    //------------------------------------------------------------------
    //  private InputStream in
    //  private LimitedInputStream limit
    //  private boolean reachedEndOfEntry
    //------------------------------------------------------------------
    /**
     * LHAɓ̂PGg̉𓀂ꂽf[^
     *  InputStreamB
     */
    private InputStream in;

    /**
     * LHAɓ̂PGg̈kꂽf[^
     * LimitedInputStreamB
     * closeEntry ɃXLbv邽߁B
     */
    private LimitedInputStream limit;

    /**
     * ݏ̃Gg̏I[ɒB true ɃZbgB
     */
    private boolean reachedEndOfEntry;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private boolean markReachedEndOfEntry
    //------------------------------------------------------------------
    /** reachEndOfEntry ̃obNAbvp */
    private boolean markReachedEndOfEntry;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  properties
    //------------------------------------------------------------------
    //  private Properties property
    //------------------------------------------------------------------
    /**
     * ek`ɑΉ̐܂܂vpeB
     */
    private Properties property;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LhaInputStream()
    //  public LhaInputStream( InputStream in )
    //  public LhaInputStream( InputStream in, Properties property )
    //  private void constructerHelper( InputStream in, Properties property )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private LhaInputStream(){   }

    /**
     * in  LHAɂ̃f[^ǂݎ InputStream \zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param in LHAɌ`̃f[^̓Xg[
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaInputStream( InputStream in ){
        Properties property = LhaProperty.getProperties();

        try{
            this.constructerHelper( in, property );                             //After Java 1.1 throws UnsupportedEncodingException
        }catch( UnsupportedEncodingException exception ){
            throw new Error( "Unsupported encoding \"" + property.getProperty( "lha.encoding" ) + "\"." );
        }
    }

    /**
     * in  LHAɂ̃f[^ǂݎ InputStream\zB<br>
     * 
     * @param in       LHAɌ`̃f[^̓Xg[
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception UnsupportedEncodingException
     *                 property.getProperty( "lha.encoding" ) œꂽ
     *                 GR[fBOT|[gȂꍇ
     */
    public LhaInputStream( InputStream in, Properties property )
                                         throws UnsupportedEncodingException {

        this.constructerHelper( in, property );                                 //After Java 1.1 throws UnsupportedEncodingException
    }

    /**
     * RXgN^̏S郁\bhB
     * 
     * @param in       LHAɌ`̃f[^̓Xg[
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception UnsupportedEncodingException
     *               encode T|[gȂꍇ
     */
    private void constructerHelper( InputStream in, Properties property )
                                        throws UnsupportedEncodingException {

        if( in != null && property != null ){
            String encoding = property.getProperty( "lha.encoding" ); 
            if( encoding == null ){
                encoding = LhaProperty.getProperty( "lha.encoding" );
            }

            //encoding`FbN
            encoding.getBytes( encoding );                                      //After Java 1.1 throws UnsupportedEncodingException

            if( in.markSupported() ){
                this.source = in;
            }else{
                this.source = new BufferedInputStream( in );
            }

            this.in                  = null;
            this.limit               = null;
            this.property            = (Properties)property.clone();
            this.reachedEndOfEntry   = false;
            this.reachedEndOfArchive = false;

        }else if( in == null ){
            throw new NullPointerException( "in" );
        }else{
            throw new NullPointerException( "property" );
        }
    }

    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //  public long skip( long length )
    //------------------------------------------------------------------
    /**
     * ݂̃Gg 1oCg̃f[^ǂݍށB
     * 
     * @return ǂ݂܂ꂽ 1oCg̃f[^B<br>
     *         ɃGg̏I[ɒBꍇ -1
     * 
     * @exception IOException ݓǂݍݒ̃Gg
     *                        o̓G[ꍇ
     */
    public int read() throws IOException {
        if( this.in != null ){
            int ret = this.in.read();                                           //throws IOException
            if( ret < 0 ){
                this.reachedEndOfEntry = true;
            }
            return ret;
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ݂̃Gg buffer 𖞂悤Ƀf[^ǂݍށB
     * 
     * @param buffer f[^ǂݍރobt@
     * 
     * @return ǂ݂܂ꂽf[^̗ʁB<br>
     *         ɃGg̏I[ɒBꍇ -1B
     * 
     * @exception IOException ݓǂݍݒ̃Gg
     *                        o̓G[ꍇ
     */
    public int read( byte[] buffer ) throws IOException {
        return this.read( buffer, 0, buffer.length );                           //throws IOException
    }

    /**
     * ݂̃Gg buffer index lengthoCg
     * f[^ǂݍށB
     * 
     * @param buffer f[^ǂݍރobt@
     * @param index  buffer̃f[^ǂݍ݊Jnʒu
     * @param length ǂݍރf[^
     * 
     * @return ǂ݂܂ꂽf[^̗ʁB<br>
     *         ɃGg̏I[ɒBꍇ -1B
     * 
     * @exception IOException ݓǂݍݒ̃Gg
     *                        o̓G[ꍇ
     */
    public int read( byte[] buffer, int index, int length ) throws IOException {
        if( this.in != null ){
            int ret = this.in.read( buffer, index, length );                    //throws IOException
            if( ret < 0 ){
                this.reachedEndOfEntry = true;
            }
            return ret;
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ݂̃Gg̃f[^ length oCgǂ݂Ƃ΂B
     * 
     * @param length ǂ݂Ƃ΂f[^
     * 
     * @return ۂɓǂ݂Ƃ΂f[^
     * 
     * @exception IOException ݓǂݍݒ̃Gg
     *                        o̓G[ꍇ
     */
    public long skip( long length ) throws IOException {
        if( this.in != null ){
            if( 0 < length ){
                long len = this.in.skip( length - 1 );                          //throws IOException
                int ret  = this.in.read();                                      //throws IOException
                if( ret < 0 ){
                    this.reachedEndOfEntry = true;
                    return len;
                }else{
                    return len + 1;
                }
            }else{
                return 0;
            }
        }else{
            throw new IOException( "no entry" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark()
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ݓǂݎ蒆̃Gǧ݈ʒuɃ}[Nݒ肵A
     * reset() Ń}[Nǂݍ݈ʒuɖ߂悤ɂB<br>
     *
     * @param readLimit }[Nʒuɖ߂EǂݍݗʁB
     *                  ̃oCg𒴂ăf[^ǂݍ񂾏ꍇ 
     *                  reset() łۏ؂͂ȂB
     * 
     * @exception IllegalStateException
     *                  ݓǂݍݒ̃Ggꍇ
     */
    public void mark( int readLimit ){
        if( this.in != null ){
            this.in.mark( readLimit );
            this.markReachedEndOfEntry = this.reachedEndOfEntry;
        }else{
            throw new IllegalStateException();
        }
    }

    /**
     * ݓǂݎ蒆̃Gg̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B
     * 
     * @exception IOException ݓǂݍݒ̃Gg
     *                        o̓G[ꍇ
     */
    public void reset() throws IOException {
        if( this.in != null ){
            this.in.reset();                                                    //throws IOException
            this.reachedEndOfEntry = this.markReachedEndOfEntry;
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ڑꂽ̓Xg[ mark()
     * reset()T|[g邩𓾂B<br>
     * wb_ǂݍݎ mark/reset K{̂
     * RXgN^œnꂽ in  markSupported()  
     * false ԂꍇÃNX in  mark/reset T|[g
     * BufferedInputStream ŃbvB
     * ̂߁Ã\bh͏ true ԂB
     * 
     * @return  true
     */
    public boolean markSupported(){
        return this.source.markSupported();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ݓǂݎ蒆̃Gg̏I[ɒB𓾂B<br>
     * ubNȂœǂݍ߂f[^ʂԂȂɒӂ邱ƁB
     * 
     * @return ݓǂݎ蒆̃Gg̏I[ɒBꍇ 0 BĂȂꍇ 1
     * 
     * @exception IOException ݓǂݍݒ̃Gg
     *                        o̓G[ꍇ
     * 
     * @see java.util.zip.ZipInputStream#available()
     */
    public int available() throws IOException {
        if( this.in != null ){
            return ( this.reachedEndOfEntry ? 0 : 1 );
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ̓̓Xg[AgpĂ
     * SẴ\[XJB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        if( this.in != null ){
            this.in.close();
            this.limit = null;
            this.in    = null;
        }

        this.source.close();
        this.source    = null;
    }


    //------------------------------------------------------------------
    //  original method  ( on the model of java.util.zip.ZipInputStream )
    //------------------------------------------------------------------
    //  manipulate entry
    //------------------------------------------------------------------
    //  public LhaHeader getNextEntry()
    //  public LhaHeader getNextEntryWithoutExtract()
    //  public void closeEntry()
    //------------------------------------------------------------------
    /**
     * ̃Gg𓀂Ȃǂ݂ނ悤ɃXg[ݒ肷B<br>
     * 
     * @return Gg̏ LhaHeader
     * 
     * @exception IOException o̓G[ꍇ
     */
    public LhaHeader getNextEntry() throws IOException {
        if( !this.reachedEndOfArchive ){
            if( this.in != null ){
                this.closeEntry();                                                  //throws IOException
            }

            byte[] HeaderData;
            if( this.alreadyOpenedFirstEnrty ){
                HeaderData = LhaHeader.getNextHeaderData( this.source );
            }else{
                HeaderData = LhaHeader.getFirstHeaderData( this.source );
                this.alreadyOpenedFirstEnrty = true;
            }
            if( null != HeaderData ){
                LhaHeader header = LhaHeader.createInstance( HeaderData, this.property );
                this.in    = new DisconnectableInputStream( this.source );
                this.limit = new LimitedInputStream( this.in, header.getCompressedSize() );
                this.in    = CompressMethod.connectDecoder( this.limit, 
                                                            header.getCompressMethod(), 
                                                            this.property,
                                                            header.getOriginalSize() );

                this.reachedEndOfEntry     = false;
                this.markReachedEndOfEntry = false;
                return header;
            }else{
                this.reachedEndOfArchive = true;
                return null;
            }
        }else{
            return null;
        }
    }

    /**
     * ̃Gg𓀂Ȃœǂ݂ނ悤ɃXg[ݒ肷B<br>
     * 
     * @return Gg̏ LhaHeader
     * 
     * @exception IOException o̓G[ꍇ
     */
    public LhaHeader getNextEntryWithoutExtract() throws IOException {

        if( !this.reachedEndOfArchive ){

            if( this.in != null ){
                this.closeEntry();                                                  //throws IOException
            }

            byte[] HeaderData;
            if( this.alreadyOpenedFirstEnrty ){
                HeaderData = LhaHeader.getNextHeaderData( this.source );
            }else{
                HeaderData = LhaHeader.getFirstHeaderData( this.source );
                this.alreadyOpenedFirstEnrty = true;
            }
            if( HeaderData != null ){

                LhaHeader header = LhaHeader.createInstance( HeaderData, this.property );
                this.in    = new DisconnectableInputStream( this.source );
                this.limit = new LimitedInputStream( this.in, header.getCompressedSize() );
                this.in    = this.limit;

                this.reachedEndOfEntry     = false;
                this.markReachedEndOfEntry = false;
                return header;
            }else{
                this.reachedEndOfArchive = true;
                return null;
            }
        }else{
            return null;
        }
    }

    /**
     * ݓǂݎ蒆̃GgA
     * ̃Ggǂ݂߂悤ɃXg[ݒ肷B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        if( this.in != null ){
            while( 0 <= this.limit.read() ){
                this.limit.skip( Long.MAX_VALUE );
            }

            this.in.close();
            this.in    = null;
            this.limit = null;
        }
    }

}
//end of LhaInputStream.java
