# 不再推荐使用的功能

本文中列出的功能不再推荐使用。它们在 Commander 未来的主要版本（major version）中可能被移除。为保证后向兼容，这些功能目前还可以使用，但它们不应被用在新代码中。

- [不再推荐使用的功能](#%E4%B8%8D%E5%86%8D%E6%8E%A8%E8%8D%90%E4%BD%BF%E7%94%A8%E7%9A%84%E5%8A%9F%E8%83%BD)
  - [.option() 方法的正则表达式参数](#option-%E6%96%B9%E6%B3%95%E7%9A%84%E6%AD%A3%E5%88%99%E8%A1%A8%E8%BE%BE%E5%BC%8F%E5%8F%82%E6%95%B0)
  - [noHelp](#nohelp)
  - [默认导入的全局 Command 对象](#%E9%BB%98%E8%AE%A4%E5%AF%BC%E5%85%A5%E7%9A%84%E5%85%A8%E5%B1%80-command-%E5%AF%B9%E8%B1%A1)
  - [.help() 与 .outputHelp() 的回调函数参数](#help-%E4%B8%8E-outputhelp-%E7%9A%84%E5%9B%9E%E8%B0%83%E5%87%BD%E6%95%B0%E5%8F%82%E6%95%B0)
  - [.on('--help')](#on--help)
  - [.on('command:*')](#oncommand)
  - [.command('*')](#command)
  - [cmd.description(cmdDescription, argDescriptions)](#cmddescriptioncmddescription-argdescriptions)
  - [InvalidOptionArgumentError](#invalidoptionargumenterror)
  - [短选项标志长于单个字符](#%E7%9F%AD%E9%80%89%E9%A1%B9%E6%A0%87%E5%BF%97%E9%95%BF%E4%BA%8E%E5%8D%95%E4%B8%AA%E5%AD%97%E7%AC%A6)


## .option() 方法的正则表达式参数

`.option()`方法可以接受一个正则表达式作为第三个参数，以规定可以接受的选项参数值。

```js
program.option('-c,--coffee <type>', 'coffee', /short-white|long-black/);
```

该功能从 Commander v3 的文档中被移除。自 Commander v7 起，该功能不再推荐使用。

新的写法是使用`Option`对象的`.choices()`方法，或者使用自定义选项处理函数。

## noHelp

此选项曾被用作传入`.command()`方法，以在内建的帮助信息中隐藏该命令：

```js
program.command('example', 'example command', { noHelp: true });
```

在 Commander v5.1 中，该选项被更名为`hidden`。自 Commander v7 起`noHelp`不再推荐使用。

## 默认导入的全局 Command 对象

Commander 的默认导入曾是一个全局的`Command`对象。

```js
const program = require('commander');
```

自 Commander v5 后，全局`Command`对象作为 `program`被导出。或者也可以导入`Command`对象。

```js
const { program } = require('commander');
// 或者
const { Command } = require('commander');
const program = new Command()
```

- 此功能在 Commander v5 的文档中被移除。
- 自 Commander v7 起不再推荐使用。
- 在 Commander v8 的 TypeScript 定义文件中被移除。

## .help() 与 .outputHelp() 的回调函数参数

这两个方法曾允许传入一个回调函数，以在展示前处理帮助信息。

```js
program.outputHelp((text) => {
  return colors.red(text);
});
```

新的写法是直接通过调用`.helpInformation()`来获取帮助文本。

```js
console.error(colors.red(program.helpInformation()));
```

自 Commander v7 起不再推荐使用。

## .on('--help')

此功能曾被用作在内建的帮助信息后输出自定义的帮助信息。自 Commander v3.0.0 起，如果有自定义的帮助选项，则此方法使用该自定义的帮助选项。

```js
program.on('--help', function() {
  console.log('')
  console.log('Examples:');
  console.log('  $ custom-help --help');
  console.log('  $ custom-help -h');
});
```

替代的方法是使用`.addHelpText()`：

```js
program.addHelpText('after', `
Examples:
  $ custom-help --help
  $ custom-help -h`
);
```

自 Commander v7 起不再推荐使用。

## .on('command:*')

当命令参数与已知子命令不匹配时发出此消息（作为 `.command('')` 实现的一部分）。

一种用途是为未知子命令添加错误。错误现在是默认的内置行为。

第二个相关用途是为未知子命令提出建议。替换内置支持是 `.showSuggestionAfterError()`，或者对于自定义行为捕获 `commander.unknownCommand` 错误。

自 Commander v8.3 起不再推荐使用。

## .command('*')

这用于向程序添加默认命令。

```js
program
  .command('*')
  .action(() => console.log('List files by default...'));
```

你现在可以在添加命令时传递 `isDefault: true` 的配置选项，无论是使用带有动作处理程序的子命令还是独立的可执行子命令。

```js
program
  .command('list', { isDefault: true })
  .action(() => console.log('List files by default...'));
```

从 Commander v5 的 README 中删除。自 Commander v8.3 起不再推荐使用。

## cmd.description(cmdDescription, argDescriptions)

此功能曾用来为命令参数添加描述信息。

```js
program
  .command('price <book>')
  .description('show price of book', {
    book: 'ISBN number for book'
  });
```

新的写法是使用`.argument()`方法。

```js
program
  .command('price')
  .description('show price of book')
  .argument('<book>', 'ISBN number for book');
```

自 Commander v8 起不再推荐使用。

## InvalidOptionArgumentError

此类曾被用来在自定义选项处理中抛出错误，以显示错误信息。

```js
function myParseInt(value, dummyPrevious) {
  // parseInt 参数为字符串和进制数
  const parsedValue = parseInt(value, 10);
  if (isNaN(parsedValue)) {
    throw new commander.InvalidOptionArgumentError('Not a number.');
  }
  return parsedValue;
}
```

替代的类是`InvalidArgumentError`，它也可用于自定义命令参数处理。

```js
function myParseInt(value, dummyPrevious) {
  // parseInt 参数为字符串和进制数
  const parsedValue = parseInt(value, 10);
  if (isNaN(parsedValue)) {
    throw new commander.InvalidArgumentError('Not a number.');
  }
  return parsedValue;
}
```

自 Commander v8 起不再推荐使用。

## 短选项标志长于单个字符

短选项从未支持像 `-ws` 的标识，但旧的 README 并没有明确说明这一点。README 现在声明短选项是单个字符。

README 在 Commander v3 更新。自 Commander v9 起不再推荐使用。
