/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* This script compiles modules for evaluating polynomial functions. If any polynomial coefficients change, this script should be rerun to update the compiled files.
*/
'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var writeFileSync = require( '@stdlib/fs/write-file' ).sync;
var licenseHeader = require( '@stdlib/_tools/licenses/header' );
var compile = require( './../../../../base/tools/evalrational-compile' );


// VARIABLES //

// Polynomial coefficients ordered in ascending degree...
var P1 = [
	-4.1298668500990866786e+11,
	2.7282507878605942706e+10,
	-6.2140700423540120665e+08,
	6.6302997904833794242e+06,
	-3.6629814655107086448e+04,
	1.0344222815443188943e+02,
	-1.2117036164593528341e-01
];

var Q1 = [
	2.3883787996332290397e+12,
	2.6328198300859648632e+10,
	1.3985097372263433271e+08,
	4.5612696224219938200e+05,
	9.3614022392337710626e+02,
	1.0,
	0.0
];

var P2 = [
	-1.8319397969392084011e+03,
	-1.2254078161378989535e+04,
	-7.2879702464464618998e+03,
	1.0341910641583726701e+04,
	1.1725046279757103576e+04,
	4.4176707025325087628e+03,
	7.4321196680624245801e+02,
	4.8591703355916499363e+01
];

var Q2 = [
	-3.5783478026152301072e+05,
	2.4599102262586308984e+05,
	-8.4055062591169562211e+04,
	1.8680990008359188352e+04,
	-2.9458766545509337327e+03,
	3.3307310774649071172e+02,
	-2.5258076240801555057e+01,
	1.0
];

var PC = [
	2.2779090197304684302e+04,
	4.1345386639580765797e+04,
	2.1170523380864944322e+04,
	3.4806486443249270347e+03,
	1.5376201909008354296e+02,
	8.8961548424210455236e-01
];

var QC = [
	2.2779090197304684318e+04,
	4.1370412495510416640e+04,
	2.1215350561880115730e+04,
	3.5028735138235608207e+03,
	1.5711159858080893649e+02,
	1.0
];

var PS = [
	-8.9226600200800094098e+01,
	-1.8591953644342993800e+02,
	-1.1183429920482737611e+02,
	-2.2300261666214198472e+01,
	-1.2441026745835638459e+00,
	-8.8033303048680751817e-03
];

var QS = [
	5.7105024128512061905e+03,
	1.1951131543434613647e+04,
	7.2642780169211018836e+03,
	1.4887231232283756582e+03,
	9.0593769594993125859e+01,
	1.0
];

// Header to add to output files:
var header = licenseHeader( 'Apache-2.0', 'js', {
	'year': ( new Date() ).getFullYear(),
	'copyright': 'The Stdlib Authors'
});
header += '\n/* This is a generated file. Do not edit directly. */\n';


// MAIN //

/**
* Main execution sequence.
*
* @private
*/
function main() {
	var fpath;
	var opts;
	var str;

	opts = {
		'encoding': 'utf8'
	};

	fpath = resolve( __dirname, '..', 'lib', 'rational_p1q1.js' );
	str = header + compile( P1, Q1 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_p2q2.js' );
	str = header + compile( P2, Q2 );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_pcqc.js' );
	str = header + compile( PC, QC );
	writeFileSync( fpath, str, opts );

	fpath = resolve( __dirname, '..', 'lib', 'rational_psqs.js' );
	str = header + compile( PS, QS );
	writeFileSync( fpath, str, opts );
}

main();
