# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

import msrest.serialization

from ._resource_mover_service_api_enums import *


class AffectedMoveResource(msrest.serialization.Model):
    """The RP custom operation error info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The affected move resource id.
    :vartype id: str
    :ivar source_id: The affected move resource source id.
    :vartype source_id: str
    :ivar move_resources: The affected move resources.
    :vartype move_resources: list[~resource_mover_service_api.models.AffectedMoveResource]
    """

    _validation = {
        'id': {'readonly': True},
        'source_id': {'readonly': True},
        'move_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'move_resources': {'key': 'moveResources', 'type': '[AffectedMoveResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AffectedMoveResource, self).__init__(**kwargs)
        self.id = None
        self.source_id = None
        self.move_resources = None


class AutomaticResolutionProperties(msrest.serialization.Model):
    """Defines the properties for automatic resolution.

    :param move_resource_id: Gets the MoveResource ARM ID of
     the dependent resource if the resolution type is Automatic.
    :type move_resource_id: str
    """

    _attribute_map = {
        'move_resource_id': {'key': 'moveResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        move_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(AutomaticResolutionProperties, self).__init__(**kwargs)
        self.move_resource_id = move_resource_id


class ResourceSettings(msrest.serialization.Model):
    """Gets or sets the resource settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvailabilitySetResourceSettings, VirtualMachineResourceSettings, LoadBalancerResourceSettings, NetworkInterfaceResourceSettings, NetworkSecurityGroupResourceSettings, PublicIPAddressResourceSettings, VirtualNetworkResourceSettings, SqlServerResourceSettings, SqlDatabaseResourceSettings, SqlElasticPoolResourceSettings, MoveResourcePropertiesSourceResourceSettings, ResourceGroupResourceSettings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Microsoft.Compute/availabilitySets': 'AvailabilitySetResourceSettings', 'Microsoft.Compute/virtualMachines': 'VirtualMachineResourceSettings', 'Microsoft.Network/loadBalancers': 'LoadBalancerResourceSettings', 'Microsoft.Network/networkInterfaces': 'NetworkInterfaceResourceSettings', 'Microsoft.Network/networkSecurityGroups': 'NetworkSecurityGroupResourceSettings', 'Microsoft.Network/publicIPAddresses': 'PublicIPAddressResourceSettings', 'Microsoft.Network/virtualNetworks': 'VirtualNetworkResourceSettings', 'Microsoft.Sql/servers': 'SqlServerResourceSettings', 'Microsoft.Sql/servers/databases': 'SqlDatabaseResourceSettings', 'Microsoft.Sql/servers/elasticPools': 'SqlElasticPoolResourceSettings', 'MoveResourceProperties-sourceResourceSettings': 'MoveResourcePropertiesSourceResourceSettings', 'resourceGroups': 'ResourceGroupResourceSettings'}
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        **kwargs
    ):
        super(ResourceSettings, self).__init__(**kwargs)
        self.resource_type: Optional[str] = None
        self.target_resource_name = target_resource_name


class AvailabilitySetResourceSettings(ResourceSettings):
    """Gets or sets the availability set resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param fault_domain: Gets or sets the target fault domain.
    :type fault_domain: int
    :param update_domain: Gets or sets the target update domain.
    :type update_domain: int
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
        'fault_domain': {'minimum': 1},
        'update_domain': {'maximum': 20, 'minimum': 1},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'fault_domain': {'key': 'faultDomain', 'type': 'int'},
        'update_domain': {'key': 'updateDomain', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        fault_domain: Optional[int] = None,
        update_domain: Optional[int] = None,
        **kwargs
    ):
        super(AvailabilitySetResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Compute/availabilitySets'
        self.fault_domain = fault_domain
        self.update_domain = update_domain


class AzureResourceReference(msrest.serialization.Model):
    """Defines reference to an Azure resource.

    All required parameters must be populated in order to send to Azure.

    :param source_arm_resource_id: Required. Gets the ARM resource ID of the tracked resource being
     referenced.
    :type source_arm_resource_id: str
    """

    _validation = {
        'source_arm_resource_id': {'required': True},
    }

    _attribute_map = {
        'source_arm_resource_id': {'key': 'sourceArmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_arm_resource_id: str,
        **kwargs
    ):
        super(AzureResourceReference, self).__init__(**kwargs)
        self.source_arm_resource_id = source_arm_resource_id


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~resource_mover_service_api.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CommitRequest(msrest.serialization.Model):
    """Defines the request body for commit operation.

    All required parameters must be populated in order to send to Azure.

    :param validate_only: Gets or sets a value indicating whether the operation needs to only run
     pre-requisite.
    :type validate_only: bool
    :param move_resources: Required. Gets or sets the list of resource Id's, by default it accepts
     move resource id's unless the input type is switched via moveResourceInputType property.
    :type move_resources: list[str]
    :param move_resource_input_type: Defines the move resource input type. Possible values include:
     "MoveResourceId", "MoveResourceSourceId".
    :type move_resource_input_type: str or ~resource_mover_service_api.models.MoveResourceInputType
    """

    _validation = {
        'move_resources': {'required': True},
    }

    _attribute_map = {
        'validate_only': {'key': 'validateOnly', 'type': 'bool'},
        'move_resources': {'key': 'moveResources', 'type': '[str]'},
        'move_resource_input_type': {'key': 'moveResourceInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        move_resources: List[str],
        validate_only: Optional[bool] = None,
        move_resource_input_type: Optional[Union[str, "MoveResourceInputType"]] = None,
        **kwargs
    ):
        super(CommitRequest, self).__init__(**kwargs)
        self.validate_only = validate_only
        self.move_resources = move_resources
        self.move_resource_input_type = move_resource_input_type


class DiscardRequest(msrest.serialization.Model):
    """Defines the request body for discard operation.

    All required parameters must be populated in order to send to Azure.

    :param validate_only: Gets or sets a value indicating whether the operation needs to only run
     pre-requisite.
    :type validate_only: bool
    :param move_resources: Required. Gets or sets the list of resource Id's, by default it accepts
     move resource id's unless the input type is switched via moveResourceInputType property.
    :type move_resources: list[str]
    :param move_resource_input_type: Defines the move resource input type. Possible values include:
     "MoveResourceId", "MoveResourceSourceId".
    :type move_resource_input_type: str or ~resource_mover_service_api.models.MoveResourceInputType
    """

    _validation = {
        'move_resources': {'required': True},
    }

    _attribute_map = {
        'validate_only': {'key': 'validateOnly', 'type': 'bool'},
        'move_resources': {'key': 'moveResources', 'type': '[str]'},
        'move_resource_input_type': {'key': 'moveResourceInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        move_resources: List[str],
        validate_only: Optional[bool] = None,
        move_resource_input_type: Optional[Union[str, "MoveResourceInputType"]] = None,
        **kwargs
    ):
        super(DiscardRequest, self).__init__(**kwargs)
        self.validate_only = validate_only
        self.move_resources = move_resources
        self.move_resource_input_type = move_resource_input_type


class Display(msrest.serialization.Model):
    """Contains the localized display information for this particular operation / action. These
value will be used by several clients for
(1) custom role definitions for RBAC;
(2) complex query filters for the event service; and
(3) audit history / records for management operations.

    :param provider: Gets or sets the provider.
     The localized friendly form of the resource provider name – it is expected to also
     include the publisher/company responsible.
     It should use Title Casing and begin with "Microsoft" for 1st party services.
     e.g. "Microsoft Monitoring Insights" or "Microsoft Compute.".
    :type provider: str
    :param resource: Gets or sets the resource.
     The localized friendly form of the resource related to this action/operation – it
     should match the public documentation for the resource provider.
     It should use Title Casing.
     This value should be unique for a particular URL type (e.g. nested types should *not*
     reuse their parent’s display.resource field)
     e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM Sizes"
     or "Scheduler Jobs".
    :type resource: str
    :param operation: Gets or sets the operation.
     The localized friendly name for the operation, as it should be shown to the user.
     It should be concise (to fit in drop downs) but clear (i.e. self-documenting).
     It should use Title Casing.
     Prescriptive guidance: Read Create or Update Delete 'ActionName'.
    :type operation: str
    :param description: Gets or sets the description.
     The localized friendly description for the operation, as it should be shown to the
     user.
     It should be thorough, yet concise – it will be used in tool tips and detailed views.
     Prescriptive guidance for namespace:
     Read any 'display.provider'  resource
     Create or Update any  'display.provider'  resource
     Delete any  'display.provider'  resource
     Perform any other action on any  'display.provider'  resource
     Prescriptive guidance for namespace:
     Read any 'display.resource' Create or Update any  'display.resource' Delete any
      'display.resource' 'ActionName' any 'display.resources'.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Display, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Identity(msrest.serialization.Model):
    """Defines the MSI properties of the Move Collection.

    :param type: The type of identity used for the resource mover service. Possible values include:
     "None", "SystemAssigned", "UserAssigned".
    :type type: str or ~resource_mover_service_api.models.ResourceIdentityType
    :param principal_id: Gets or sets the principal id.
    :type principal_id: str
    :param tenant_id: Gets or sets the tenant id.
    :type tenant_id: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id


class JobStatus(msrest.serialization.Model):
    """Defines the job status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: Defines the job name. Default value: "InitialSync".
    :vartype job_name: str
    :ivar job_progress: Gets or sets the monitoring job percentage.
    :vartype job_progress: str
    """

    _validation = {
        'job_name': {'readonly': True, 'constant': True},
        'job_progress': {'readonly': True},
    }

    _attribute_map = {
        'job_name': {'key': 'jobName', 'type': 'str'},
        'job_progress': {'key': 'jobProgress', 'type': 'str'},
    }

    job_name = "InitialSync"

    def __init__(
        self,
        **kwargs
    ):
        super(JobStatus, self).__init__(**kwargs)
        self.job_name = None
        self.job_progress = None


class LBBackendAddressPoolResourceSettings(msrest.serialization.Model):
    """Defines load balancer backend address pool properties.

    :param name: Gets or sets the backend address pool name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(LBBackendAddressPoolResourceSettings, self).__init__(**kwargs)
        self.name = name


class LBFrontendIPConfigurationResourceSettings(msrest.serialization.Model):
    """Defines load balancer frontend IP configuration properties.

    :param name: Gets or sets the frontend IP configuration name.
    :type name: str
    :param private_ip_address: Gets or sets the IP address of the Load Balancer.This is only
     specified if a specific
     private IP address shall be allocated from the subnet specified in subnetRef.
    :type private_ip_address: str
    :param private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic).
    :type private_ip_allocation_method: str
    :param subnet: Defines reference to a proxy resource.
    :type subnet: ~resource_mover_service_api.models.ProxyResourceReference
    :param zones: Gets or sets the csv list of zones.
    :type zones: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'privateIpAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'ProxyResourceReference'},
        'zones': {'key': 'zones', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[str] = None,
        subnet: Optional["ProxyResourceReference"] = None,
        zones: Optional[str] = None,
        **kwargs
    ):
        super(LBFrontendIPConfigurationResourceSettings, self).__init__(**kwargs)
        self.name = name
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.zones = zones


class ProxyResourceReference(AzureResourceReference):
    """Defines reference to a proxy resource.

    All required parameters must be populated in order to send to Azure.

    :param source_arm_resource_id: Required. Gets the ARM resource ID of the tracked resource being
     referenced.
    :type source_arm_resource_id: str
    :param name: Gets the name of the proxy resource on the target side.
    :type name: str
    """

    _validation = {
        'source_arm_resource_id': {'required': True},
    }

    _attribute_map = {
        'source_arm_resource_id': {'key': 'sourceArmResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_arm_resource_id: str,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ProxyResourceReference, self).__init__(source_arm_resource_id=source_arm_resource_id, **kwargs)
        self.name = name


class LoadBalancerBackendAddressPoolReference(ProxyResourceReference):
    """Defines reference to load balancer backend address pools.

    All required parameters must be populated in order to send to Azure.

    :param source_arm_resource_id: Required. Gets the ARM resource ID of the tracked resource being
     referenced.
    :type source_arm_resource_id: str
    :param name: Gets the name of the proxy resource on the target side.
    :type name: str
    """

    _validation = {
        'source_arm_resource_id': {'required': True},
    }

    _attribute_map = {
        'source_arm_resource_id': {'key': 'sourceArmResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_arm_resource_id: str,
        name: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancerBackendAddressPoolReference, self).__init__(source_arm_resource_id=source_arm_resource_id, name=name, **kwargs)


class LoadBalancerNatRuleReference(ProxyResourceReference):
    """Defines reference to load balancer NAT rules.

    All required parameters must be populated in order to send to Azure.

    :param source_arm_resource_id: Required. Gets the ARM resource ID of the tracked resource being
     referenced.
    :type source_arm_resource_id: str
    :param name: Gets the name of the proxy resource on the target side.
    :type name: str
    """

    _validation = {
        'source_arm_resource_id': {'required': True},
    }

    _attribute_map = {
        'source_arm_resource_id': {'key': 'sourceArmResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_arm_resource_id: str,
        name: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancerNatRuleReference, self).__init__(source_arm_resource_id=source_arm_resource_id, name=name, **kwargs)


class LoadBalancerResourceSettings(ResourceSettings):
    """Defines the load balancer resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param sku: Gets or sets load balancer sku (Basic/Standard).
    :type sku: str
    :param frontend_ip_configurations: Gets or sets the frontend IP configurations of the load
     balancer.
    :type frontend_ip_configurations:
     list[~resource_mover_service_api.models.LBFrontendIPConfigurationResourceSettings]
    :param backend_address_pools: Gets or sets the backend address pools of the load balancer.
    :type backend_address_pools:
     list[~resource_mover_service_api.models.LBBackendAddressPoolResourceSettings]
    :param zones: Gets or sets the csv list of zones common for all frontend IP configurations.
     Note this is given
      precedence only if frontend IP configurations settings are not present.
    :type zones: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'frontend_ip_configurations': {'key': 'frontendIPConfigurations', 'type': '[LBFrontendIPConfigurationResourceSettings]'},
        'backend_address_pools': {'key': 'backendAddressPools', 'type': '[LBBackendAddressPoolResourceSettings]'},
        'zones': {'key': 'zones', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        sku: Optional[str] = None,
        frontend_ip_configurations: Optional[List["LBFrontendIPConfigurationResourceSettings"]] = None,
        backend_address_pools: Optional[List["LBBackendAddressPoolResourceSettings"]] = None,
        zones: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancerResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Network/loadBalancers'
        self.sku = sku
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.zones = zones


class ManualResolutionProperties(msrest.serialization.Model):
    """Defines the properties for manual resolution.

    :param target_id: Gets or sets the target resource ARM ID of the dependent resource if the
     resource type is Manual.
    :type target_id: str
    """

    _attribute_map = {
        'target_id': {'key': 'targetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_id: Optional[str] = None,
        **kwargs
    ):
        super(ManualResolutionProperties, self).__init__(**kwargs)
        self.target_id = target_id


class MoveCollection(msrest.serialization.Model):
    """Define the move collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives.
    :type location: str
    :param identity: Defines the MSI properties of the Move Collection.
    :type identity: ~resource_mover_service_api.models.Identity
    :param properties: Defines the move collection properties.
    :type properties: ~resource_mover_service_api.models.MoveCollectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'properties': {'key': 'properties', 'type': 'MoveCollectionProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["Identity"] = None,
        properties: Optional["MoveCollectionProperties"] = None,
        **kwargs
    ):
        super(MoveCollection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.location = location
        self.identity = identity
        self.properties = properties


class MoveCollectionProperties(msrest.serialization.Model):
    """Defines the move collection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param source_region: Required. Gets or sets the source region.
    :type source_region: str
    :param target_region: Required. Gets or sets the target region.
    :type target_region: str
    :ivar provisioning_state: Defines the provisioning states. Possible values include:
     "Succeeded", "Updating", "Creating", "Failed".
    :vartype provisioning_state: str or ~resource_mover_service_api.models.ProvisioningState
    """

    _validation = {
        'source_region': {'required': True},
        'target_region': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'source_region': {'key': 'sourceRegion', 'type': 'str'},
        'target_region': {'key': 'targetRegion', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_region: str,
        target_region: str,
        **kwargs
    ):
        super(MoveCollectionProperties, self).__init__(**kwargs)
        self.source_region = source_region
        self.target_region = target_region
        self.provisioning_state = None


class MoveCollectionResultList(msrest.serialization.Model):
    """Defines the collection of move collections.

    :param value: Gets the list of move collections.
    :type value: list[~resource_mover_service_api.models.MoveCollection]
    :param next_link: Gets the value of  next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MoveCollection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MoveCollection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MoveCollectionResultList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MoveErrorInfo(msrest.serialization.Model):
    """The move custom error info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar move_resources: The affected move resources.
    :vartype move_resources: list[~resource_mover_service_api.models.AffectedMoveResource]
    """

    _validation = {
        'move_resources': {'readonly': True},
    }

    _attribute_map = {
        'move_resources': {'key': 'moveResources', 'type': '[AffectedMoveResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MoveErrorInfo, self).__init__(**kwargs)
        self.move_resources = None


class MoveResource(msrest.serialization.Model):
    """Defines the move resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Defines the move resource properties.
    :type properties: ~resource_mover_service_api.models.MoveResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MoveResourceProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["MoveResourceProperties"] = None,
        **kwargs
    ):
        super(MoveResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class MoveResourceCollection(msrest.serialization.Model):
    """Defines the collection of move resources.

    :param value: Gets the list of move resources.
    :type value: list[~resource_mover_service_api.models.MoveResource]
    :param next_link: Gets the value of  next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MoveResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MoveResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MoveResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MoveResourceDependency(msrest.serialization.Model):
    """Defines the dependency of the move resource.

    :param id: Gets the source ARM ID of the dependent resource.
    :type id: str
    :param resolution_status: Gets the dependency resolution status.
    :type resolution_status: str
    :param resolution_type: Defines the resolution type. Possible values include: "Manual",
     "Automatic".
    :type resolution_type: str or ~resource_mover_service_api.models.ResolutionType
    :param dependency_type: Defines the dependency type. Possible values include:
     "RequiredForPrepare", "RequiredForMove".
    :type dependency_type: str or ~resource_mover_service_api.models.DependencyType
    :param manual_resolution: Defines the properties for manual resolution.
    :type manual_resolution: ~resource_mover_service_api.models.ManualResolutionProperties
    :param automatic_resolution: Defines the properties for automatic resolution.
    :type automatic_resolution: ~resource_mover_service_api.models.AutomaticResolutionProperties
    :param is_optional: Gets or sets a value indicating whether the dependency is optional.
    :type is_optional: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resolution_status': {'key': 'resolutionStatus', 'type': 'str'},
        'resolution_type': {'key': 'resolutionType', 'type': 'str'},
        'dependency_type': {'key': 'dependencyType', 'type': 'str'},
        'manual_resolution': {'key': 'manualResolution', 'type': 'ManualResolutionProperties'},
        'automatic_resolution': {'key': 'automaticResolution', 'type': 'AutomaticResolutionProperties'},
        'is_optional': {'key': 'isOptional', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        resolution_status: Optional[str] = None,
        resolution_type: Optional[Union[str, "ResolutionType"]] = None,
        dependency_type: Optional[Union[str, "DependencyType"]] = None,
        manual_resolution: Optional["ManualResolutionProperties"] = None,
        automatic_resolution: Optional["AutomaticResolutionProperties"] = None,
        is_optional: Optional[str] = None,
        **kwargs
    ):
        super(MoveResourceDependency, self).__init__(**kwargs)
        self.id = id
        self.resolution_status = resolution_status
        self.resolution_type = resolution_type
        self.dependency_type = dependency_type
        self.manual_resolution = manual_resolution
        self.automatic_resolution = automatic_resolution
        self.is_optional = is_optional


class MoveResourceDependencyOverride(msrest.serialization.Model):
    """Defines the dependency override of the move resource.

    :param id: Gets or sets the ARM ID of the dependent resource.
    :type id: str
    :param target_id: Gets or sets the resource ARM id of either the MoveResource or the resource
     ARM ID of
     the dependent resource.
    :type target_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target_id: Optional[str] = None,
        **kwargs
    ):
        super(MoveResourceDependencyOverride, self).__init__(**kwargs)
        self.id = id
        self.target_id = target_id


class MoveResourceError(msrest.serialization.Model):
    """An error response from the azure resource mover service.

    :param properties: The move resource error body.
    :type properties: ~resource_mover_service_api.models.MoveResourceErrorBody
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'MoveResourceErrorBody'},
    }

    def __init__(
        self,
        *,
        properties: Optional["MoveResourceErrorBody"] = None,
        **kwargs
    ):
        super(MoveResourceError, self).__init__(**kwargs)
        self.properties = properties


class MoveResourceErrorBody(msrest.serialization.Model):
    """An error response from the Azure Migrate service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~resource_mover_service_api.models.MoveResourceErrorBody]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[MoveResourceErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MoveResourceErrorBody, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None


class MoveResourceFilter(msrest.serialization.Model):
    """Move resource filter.

    :param properties:
    :type properties: ~resource_mover_service_api.models.MoveResourceFilterProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'MoveResourceFilterProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["MoveResourceFilterProperties"] = None,
        **kwargs
    ):
        super(MoveResourceFilter, self).__init__(**kwargs)
        self.properties = properties


class MoveResourceFilterProperties(msrest.serialization.Model):
    """MoveResourceFilterProperties.

    :param provisioning_state: The provisioning state.
    :type provisioning_state: str
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(MoveResourceFilterProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state


class MoveResourceProperties(msrest.serialization.Model):
    """Defines the move resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Defines the provisioning states. Possible values include:
     "Succeeded", "Updating", "Creating", "Failed".
    :vartype provisioning_state: str or ~resource_mover_service_api.models.ProvisioningState
    :param source_id: Required. Gets or sets the Source ARM Id of the resource.
    :type source_id: str
    :ivar target_id: Gets or sets the Target ARM Id of the resource.
    :vartype target_id: str
    :param existing_target_id: Gets or sets the existing target ARM Id of the resource.
    :type existing_target_id: str
    :param resource_settings: Gets or sets the resource settings.
    :type resource_settings: ~resource_mover_service_api.models.ResourceSettings
    :ivar source_resource_settings: Gets or sets the source resource settings.
    :vartype source_resource_settings: ~resource_mover_service_api.models.ResourceSettings
    :ivar move_status: Defines the move resource status.
    :vartype move_status: ~resource_mover_service_api.models.MoveResourceStatus
    :ivar depends_on: Gets or sets the move resource dependencies.
    :vartype depends_on: list[~resource_mover_service_api.models.MoveResourceDependency]
    :param depends_on_overrides: Gets or sets the move resource dependencies overrides.
    :type depends_on_overrides:
     list[~resource_mover_service_api.models.MoveResourceDependencyOverride]
    :ivar errors: Defines the move resource errors.
    :vartype errors: ~resource_mover_service_api.models.MoveResourceError
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'source_id': {'required': True},
        'target_id': {'readonly': True},
        'source_resource_settings': {'readonly': True},
        'move_status': {'readonly': True},
        'depends_on': {'readonly': True},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'existing_target_id': {'key': 'existingTargetId', 'type': 'str'},
        'resource_settings': {'key': 'resourceSettings', 'type': 'ResourceSettings'},
        'source_resource_settings': {'key': 'sourceResourceSettings', 'type': 'ResourceSettings'},
        'move_status': {'key': 'moveStatus', 'type': 'MoveResourceStatus'},
        'depends_on': {'key': 'dependsOn', 'type': '[MoveResourceDependency]'},
        'depends_on_overrides': {'key': 'dependsOnOverrides', 'type': '[MoveResourceDependencyOverride]'},
        'errors': {'key': 'errors', 'type': 'MoveResourceError'},
    }

    def __init__(
        self,
        *,
        source_id: str,
        existing_target_id: Optional[str] = None,
        resource_settings: Optional["ResourceSettings"] = None,
        depends_on_overrides: Optional[List["MoveResourceDependencyOverride"]] = None,
        **kwargs
    ):
        super(MoveResourceProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.source_id = source_id
        self.target_id = None
        self.existing_target_id = existing_target_id
        self.resource_settings = resource_settings
        self.source_resource_settings = None
        self.move_status = None
        self.depends_on = None
        self.depends_on_overrides = depends_on_overrides
        self.errors = None


class MoveResourcePropertiesErrors(MoveResourceError):
    """Defines the move resource errors.

    :param properties: The move resource error body.
    :type properties: ~resource_mover_service_api.models.MoveResourceErrorBody
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'MoveResourceErrorBody'},
    }

    def __init__(
        self,
        *,
        properties: Optional["MoveResourceErrorBody"] = None,
        **kwargs
    ):
        super(MoveResourcePropertiesErrors, self).__init__(properties=properties, **kwargs)


class MoveResourceStatus(msrest.serialization.Model):
    """Defines the move resource status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar move_state: Defines the MoveResource states. Possible values include:
     "AssignmentPending", "PreparePending", "PrepareInProgress", "PrepareFailed", "MovePending",
     "MoveInProgress", "MoveFailed", "DiscardInProgress", "DiscardFailed", "CommitPending",
     "CommitInProgress", "CommitFailed", "Committed".
    :vartype move_state: str or ~resource_mover_service_api.models.MoveState
    :param job_status: Defines the job status.
    :type job_status: ~resource_mover_service_api.models.JobStatus
    :param errors: An error response from the azure resource mover service.
    :type errors: ~resource_mover_service_api.models.MoveResourceError
    :ivar target_id: Gets the Target ARM Id of the resource.
    :vartype target_id: str
    """

    _validation = {
        'move_state': {'readonly': True},
        'target_id': {'readonly': True},
    }

    _attribute_map = {
        'move_state': {'key': 'moveState', 'type': 'str'},
        'job_status': {'key': 'jobStatus', 'type': 'JobStatus'},
        'errors': {'key': 'errors', 'type': 'MoveResourceError'},
        'target_id': {'key': 'targetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_status: Optional["JobStatus"] = None,
        errors: Optional["MoveResourceError"] = None,
        **kwargs
    ):
        super(MoveResourceStatus, self).__init__(**kwargs)
        self.move_state = None
        self.job_status = job_status
        self.errors = errors
        self.target_id = None


class MoveResourcePropertiesMoveStatus(MoveResourceStatus):
    """Defines the move resource status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar move_state: Defines the MoveResource states. Possible values include:
     "AssignmentPending", "PreparePending", "PrepareInProgress", "PrepareFailed", "MovePending",
     "MoveInProgress", "MoveFailed", "DiscardInProgress", "DiscardFailed", "CommitPending",
     "CommitInProgress", "CommitFailed", "Committed".
    :vartype move_state: str or ~resource_mover_service_api.models.MoveState
    :param job_status: Defines the job status.
    :type job_status: ~resource_mover_service_api.models.JobStatus
    :param errors: An error response from the azure resource mover service.
    :type errors: ~resource_mover_service_api.models.MoveResourceError
    :ivar target_id: Gets the Target ARM Id of the resource.
    :vartype target_id: str
    """

    _validation = {
        'move_state': {'readonly': True},
        'target_id': {'readonly': True},
    }

    _attribute_map = {
        'move_state': {'key': 'moveState', 'type': 'str'},
        'job_status': {'key': 'jobStatus', 'type': 'JobStatus'},
        'errors': {'key': 'errors', 'type': 'MoveResourceError'},
        'target_id': {'key': 'targetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_status: Optional["JobStatus"] = None,
        errors: Optional["MoveResourceError"] = None,
        **kwargs
    ):
        super(MoveResourcePropertiesMoveStatus, self).__init__(job_status=job_status, errors=errors, **kwargs)


class MoveResourcePropertiesSourceResourceSettings(ResourceSettings):
    """Gets or sets the source resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        **kwargs
    ):
        super(MoveResourcePropertiesSourceResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'MoveResourceProperties-sourceResourceSettings'


class NetworkInterfaceResourceSettings(ResourceSettings):
    """Defines the network interface resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param ip_configurations: Gets or sets the IP configurations of the NIC.
    :type ip_configurations:
     list[~resource_mover_service_api.models.NicIpConfigurationResourceSettings]
    :param enable_accelerated_networking: Gets or sets a value indicating whether accelerated
     networking is enabled.
    :type enable_accelerated_networking: bool
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'ip_configurations': {'key': 'ipConfigurations', 'type': '[NicIpConfigurationResourceSettings]'},
        'enable_accelerated_networking': {'key': 'enableAcceleratedNetworking', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        ip_configurations: Optional[List["NicIpConfigurationResourceSettings"]] = None,
        enable_accelerated_networking: Optional[bool] = None,
        **kwargs
    ):
        super(NetworkInterfaceResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Network/networkInterfaces'
        self.ip_configurations = ip_configurations
        self.enable_accelerated_networking = enable_accelerated_networking


class NetworkSecurityGroupResourceSettings(ResourceSettings):
    """Defines the NSG resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param security_rules: Gets or sets Security rules of network security group.
    :type security_rules: list[~resource_mover_service_api.models.NsgSecurityRule]
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[NsgSecurityRule]'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        security_rules: Optional[List["NsgSecurityRule"]] = None,
        **kwargs
    ):
        super(NetworkSecurityGroupResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Network/networkSecurityGroups'
        self.security_rules = security_rules


class NicIpConfigurationResourceSettings(msrest.serialization.Model):
    """Defines NIC IP configuration properties.

    :param name: Gets or sets the IP configuration name.
    :type name: str
    :param private_ip_address: Gets or sets the private IP address of the network interface IP
     Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: Gets or sets the private IP address allocation method.
    :type private_ip_allocation_method: str
    :param subnet: Defines reference to a proxy resource.
    :type subnet: ~resource_mover_service_api.models.ProxyResourceReference
    :param primary: Gets or sets a value indicating whether this IP configuration is the primary.
    :type primary: bool
    :param load_balancer_backend_address_pools: Gets or sets the references of the load balancer
     backend address pools.
    :type load_balancer_backend_address_pools:
     list[~resource_mover_service_api.models.ProxyResourceReference]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'privateIpAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'ProxyResourceReference'},
        'primary': {'key': 'primary', 'type': 'bool'},
        'load_balancer_backend_address_pools': {'key': 'loadBalancerBackendAddressPools', 'type': '[ProxyResourceReference]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[str] = None,
        subnet: Optional["ProxyResourceReference"] = None,
        primary: Optional[bool] = None,
        load_balancer_backend_address_pools: Optional[List["ProxyResourceReference"]] = None,
        **kwargs
    ):
        super(NicIpConfigurationResourceSettings, self).__init__(**kwargs)
        self.name = name
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.primary = primary
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools


class NsgSecurityRule(msrest.serialization.Model):
    """Security Rule data model for Network Security Groups.

    :param name: Gets or sets the Security rule name.
    :type name: str
    :param access: Gets or sets whether network traffic is allowed or denied.
     Possible values are “Allow” and “Deny”.
    :type access: str
    :param description: Gets or sets a description for this rule. Restricted to 140 chars.
    :type description: str
    :param destination_address_prefix: Gets or sets destination address prefix. CIDR or source IP
     range.
      A “*” can also be used to match all source IPs. Default tags such
     as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
    :type destination_address_prefix: str
    :param destination_port_range: Gets or sets Destination Port or Range. Integer or range between
     0 and 65535. A “*” can also be used to match all ports.
    :type destination_port_range: str
    :param direction: Gets or sets the direction of the rule.InBound or Outbound. The
     direction specifies if rule will be evaluated on incoming or outgoing traffic.
    :type direction: str
    :param priority: Gets or sets the priority of the rule. The value can be between
     100 and 4096. The priority number must be unique for each rule in the collection.
     The lower the priority number, the higher the priority of the rule.
    :type priority: int
    :param protocol: Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
    :type protocol: str
    :param source_address_prefix: Gets or sets source address prefix. CIDR or source IP range. A
     “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
     ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
     rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param source_port_range: Gets or sets Source Port or Range. Integer or range between 0 and
    
    
     #. A “*” can also be used to match all ports.
    :type source_port_range: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'access': {'key': 'access', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'destination_address_prefix': {'key': 'destinationAddressPrefix', 'type': 'str'},
        'destination_port_range': {'key': 'destinationPortRange', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'source_port_range': {'key': 'sourcePortRange', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access: Optional[str] = None,
        description: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        direction: Optional[str] = None,
        priority: Optional[int] = None,
        protocol: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        source_port_range: Optional[str] = None,
        **kwargs
    ):
        super(NsgSecurityRule, self).__init__(**kwargs)
        self.name = name
        self.access = access
        self.description = description
        self.destination_address_prefix = destination_address_prefix
        self.destination_port_range = destination_port_range
        self.direction = direction
        self.priority = priority
        self.protocol = protocol
        self.source_address_prefix = source_address_prefix
        self.source_port_range = source_port_range


class OperationErrorAdditionalInfo(msrest.serialization.Model):
    """The operation error info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The error type.
    :vartype type: str
    :ivar info: The operation error info.
    :vartype info: ~resource_mover_service_api.models.MoveErrorInfo
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'MoveErrorInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class OperationsDiscovery(msrest.serialization.Model):
    """Operations discovery class.

    :param name: Gets or sets Name of the API.
     The name of the operation being performed on this particular object. It should
     match the action name that appears in RBAC / the event service.
     Examples of operations include:
    
    
     * Microsoft.Compute/virtualMachine/capture/action
     * Microsoft.Compute/virtualMachine/restart/action
     * Microsoft.Compute/virtualMachine/write
     * Microsoft.Compute/virtualMachine/read
     * Microsoft.Compute/virtualMachine/delete
       Each action should include, in order:
       (1) Resource Provider Namespace
       (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL
       Azure database)
       (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH
       on a collection or named value, Write should be used.
       If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it
       is a POST, Action should be used.
       As a note: all resource providers would need to include the "{Resource Provider
       Namespace}/register/action" operation in their response.
       This API is used to register for their service, and should include details about the
       operation (e.g. a localized name for the resource provider + any special
       considerations like PII release).
    :type name: str
    :param display: Contains the localized display information for this particular operation /
     action. These
     value will be used by several clients for
     (1) custom role definitions for RBAC;
     (2) complex query filters for the event service; and
     (3) audit history / records for management operations.
    :type display: ~resource_mover_service_api.models.Display
    :param origin: Gets or sets Origin.
     The intended executor of the operation; governs the display of the operation in the
     RBAC UX and the audit logs UX.
     Default value is "user,system".
    :type origin: str
    :param properties: Any object.
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'Display'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["Display"] = None,
        origin: Optional[str] = None,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(OperationsDiscovery, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationsDiscoveryCollection(msrest.serialization.Model):
    """Collection of ClientDiscovery details.

    :param value: Gets or sets the ClientDiscovery details.
    :type value: list[~resource_mover_service_api.models.OperationsDiscovery]
    :param next_link: Gets or sets the value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationsDiscovery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationsDiscovery"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsDiscoveryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationStatus(msrest.serialization.Model):
    """Operation status REST resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: Status of the operation. ARM expects the terminal status to be one of Succeeded/
     Failed/ Canceled. All other values imply that the operation is still running.
    :vartype status: str
    :ivar start_time: Start time.
    :vartype start_time: str
    :ivar end_time: End time.
    :vartype end_time: str
    :ivar error: Error stating all error details for the operation.
    :vartype error: ~resource_mover_service_api.models.OperationStatusError
    :ivar properties: Custom data.
    :vartype properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'error': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'error': {'key': 'error', 'type': 'OperationStatusError'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatus, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None
        self.properties = None


class OperationStatusError(msrest.serialization.Model):
    """Class for operation status errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: list[~resource_mover_service_api.models.OperationStatusError]
    :ivar additional_info: The additional info.
    :vartype additional_info: list[~resource_mover_service_api.models.OperationErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[OperationStatusError]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[OperationErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatusError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None
        self.additional_info = None


class PrepareRequest(msrest.serialization.Model):
    """Defines the request body for initiate prepare operation.

    All required parameters must be populated in order to send to Azure.

    :param validate_only: Gets or sets a value indicating whether the operation needs to only run
     pre-requisite.
    :type validate_only: bool
    :param move_resources: Required. Gets or sets the list of resource Id's, by default it accepts
     move resource id's unless the input type is switched via moveResourceInputType property.
    :type move_resources: list[str]
    :param move_resource_input_type: Defines the move resource input type. Possible values include:
     "MoveResourceId", "MoveResourceSourceId".
    :type move_resource_input_type: str or ~resource_mover_service_api.models.MoveResourceInputType
    """

    _validation = {
        'move_resources': {'required': True},
    }

    _attribute_map = {
        'validate_only': {'key': 'validateOnly', 'type': 'bool'},
        'move_resources': {'key': 'moveResources', 'type': '[str]'},
        'move_resource_input_type': {'key': 'moveResourceInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        move_resources: List[str],
        validate_only: Optional[bool] = None,
        move_resource_input_type: Optional[Union[str, "MoveResourceInputType"]] = None,
        **kwargs
    ):
        super(PrepareRequest, self).__init__(**kwargs)
        self.validate_only = validate_only
        self.move_resources = move_resources
        self.move_resource_input_type = move_resource_input_type


class PublicIPAddressResourceSettings(ResourceSettings):
    """Defines the public IP address resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param domain_name_label: Gets or sets the domain name label.
    :type domain_name_label: str
    :param f_qdn: Gets or sets the fully qualified domain name.
    :type f_qdn: str
    :param public_ip_allocation_method: Gets or sets public IP allocation method.
    :type public_ip_allocation_method: str
    :param sku: Gets or sets public IP sku.
    :type sku: str
    :param zones: Gets or sets public IP zones.
    :type zones: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'f_qdn': {'key': 'fQDN', 'type': 'str'},
        'public_ip_allocation_method': {'key': 'publicIpAllocationMethod', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'zones': {'key': 'zones', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        domain_name_label: Optional[str] = None,
        f_qdn: Optional[str] = None,
        public_ip_allocation_method: Optional[str] = None,
        sku: Optional[str] = None,
        zones: Optional[str] = None,
        **kwargs
    ):
        super(PublicIPAddressResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Network/publicIPAddresses'
        self.domain_name_label = domain_name_label
        self.f_qdn = f_qdn
        self.public_ip_allocation_method = public_ip_allocation_method
        self.sku = sku
        self.zones = zones


class ResourceGroupResourceSettings(ResourceSettings):
    """Defines the resource group resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        **kwargs
    ):
        super(ResourceGroupResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'resourceGroups'


class ResourceMoveRequest(msrest.serialization.Model):
    """Defines the request body for resource move operation.

    All required parameters must be populated in order to send to Azure.

    :param validate_only: Gets or sets a value indicating whether the operation needs to only run
     pre-requisite.
    :type validate_only: bool
    :param move_resources: Required. Gets or sets the list of resource Id's, by default it accepts
     move resource id's unless the input type is switched via moveResourceInputType property.
    :type move_resources: list[str]
    :param move_resource_input_type: Defines the move resource input type. Possible values include:
     "MoveResourceId", "MoveResourceSourceId".
    :type move_resource_input_type: str or ~resource_mover_service_api.models.MoveResourceInputType
    """

    _validation = {
        'move_resources': {'required': True},
    }

    _attribute_map = {
        'validate_only': {'key': 'validateOnly', 'type': 'bool'},
        'move_resources': {'key': 'moveResources', 'type': '[str]'},
        'move_resource_input_type': {'key': 'moveResourceInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        move_resources: List[str],
        validate_only: Optional[bool] = None,
        move_resource_input_type: Optional[Union[str, "MoveResourceInputType"]] = None,
        **kwargs
    ):
        super(ResourceMoveRequest, self).__init__(**kwargs)
        self.validate_only = validate_only
        self.move_resources = move_resources
        self.move_resource_input_type = move_resource_input_type


class SqlDatabaseResourceSettings(ResourceSettings):
    """Defines the Sql Database resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param zone_redundant: Defines the zone redundant resource setting. Possible values include:
     "Enable", "Disable".
    :type zone_redundant: str or ~resource_mover_service_api.models.ZoneRedundant
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        zone_redundant: Optional[Union[str, "ZoneRedundant"]] = None,
        **kwargs
    ):
        super(SqlDatabaseResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Sql/servers/databases'
        self.zone_redundant = zone_redundant


class SqlElasticPoolResourceSettings(ResourceSettings):
    """Defines the Sql ElasticPool resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param zone_redundant: Defines the zone redundant resource setting. Possible values include:
     "Enable", "Disable".
    :type zone_redundant: str or ~resource_mover_service_api.models.ZoneRedundant
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        zone_redundant: Optional[Union[str, "ZoneRedundant"]] = None,
        **kwargs
    ):
        super(SqlElasticPoolResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Sql/servers/elasticPools'
        self.zone_redundant = zone_redundant


class SqlServerResourceSettings(ResourceSettings):
    """Defines the SQL Server resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        **kwargs
    ):
        super(SqlServerResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Sql/servers'


class SubnetReference(ProxyResourceReference):
    """Defines reference to subnet.

    All required parameters must be populated in order to send to Azure.

    :param source_arm_resource_id: Required. Gets the ARM resource ID of the tracked resource being
     referenced.
    :type source_arm_resource_id: str
    :param name: Gets the name of the proxy resource on the target side.
    :type name: str
    """

    _validation = {
        'source_arm_resource_id': {'required': True},
    }

    _attribute_map = {
        'source_arm_resource_id': {'key': 'sourceArmResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_arm_resource_id: str,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SubnetReference, self).__init__(source_arm_resource_id=source_arm_resource_id, name=name, **kwargs)


class SubnetResourceSettings(msrest.serialization.Model):
    """Defines the virtual network subnets resource settings.

    :param name: Gets or sets the Subnet name.
    :type name: str
    :param address_prefix: Gets or sets address prefix for the subnet.
    :type address_prefix: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'address_prefix': {'key': 'addressPrefix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        address_prefix: Optional[str] = None,
        **kwargs
    ):
        super(SubnetResourceSettings, self).__init__(**kwargs)
        self.name = name
        self.address_prefix = address_prefix


class UnresolvedDependency(msrest.serialization.Model):
    """Unresolved dependency.

    :param count: Gets or sets the count.
    :type count: int
    :param id: Gets or sets the arm id of the dependency.
    :type id: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        super(UnresolvedDependency, self).__init__(**kwargs)
        self.count = count
        self.id = id


class UnresolvedDependencyCollection(msrest.serialization.Model):
    """Unresolved dependency collection.

    :param value: Gets or sets the list of unresolved dependencies.
    :type value: list[~resource_mover_service_api.models.UnresolvedDependency]
    :param next_link: Gets or sets the value of  next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UnresolvedDependency]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UnresolvedDependency"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UnresolvedDependencyCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateMoveCollectionRequest(msrest.serialization.Model):
    """Defines the request body for updating move collection.

    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :param identity: Defines the MSI properties of the Move Collection.
    :type identity: ~resource_mover_service_api.models.Identity
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        super(UpdateMoveCollectionRequest, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class VirtualMachineResourceSettings(ResourceSettings):
    """Gets or sets the virtual machine resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param target_availability_zone: Gets or sets the target availability zone. Possible values
     include: "1", "2", "3", "NA".
    :type target_availability_zone: str or
     ~resource_mover_service_api.models.TargetAvailabilityZone
    :param target_vm_size: Gets or sets the target virtual machine size.
    :type target_vm_size: str
    :param target_availability_set_id: Gets or sets the target availability set id for virtual
     machines not in an availability set at source.
    :type target_availability_set_id: str
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        target_availability_zone: Optional[Union[str, "TargetAvailabilityZone"]] = None,
        target_vm_size: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Compute/virtualMachines'
        self.target_availability_zone = target_availability_zone
        self.target_vm_size = target_vm_size
        self.target_availability_set_id = target_availability_set_id


class VirtualNetworkResourceSettings(ResourceSettings):
    """Defines the virtual network resource settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The resource type. For example, the value can be
     Microsoft.Compute/virtualMachines.Constant filled by server.
    :type resource_type: str
    :param target_resource_name: Required. Gets or sets the target Resource name.
    :type target_resource_name: str
    :param enable_ddos_protection: Gets or sets a value indicating whether gets or sets whether the
     DDOS protection should be switched on.
    :type enable_ddos_protection: bool
    :param address_space: Gets or sets the address prefixes for the virtual network.
    :type address_space: list[str]
    :param dns_servers: Gets or sets DHCPOptions that contains an array of DNS servers available to
     VMs
     deployed in the virtual network.
    :type dns_servers: list[str]
    :param subnets: Gets or sets List of subnets in a VirtualNetwork.
    :type subnets: list[~resource_mover_service_api.models.SubnetResourceSettings]
    """

    _validation = {
        'resource_type': {'required': True},
        'target_resource_name': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'enable_ddos_protection': {'key': 'enableDdosProtection', 'type': 'bool'},
        'address_space': {'key': 'addressSpace', 'type': '[str]'},
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'subnets': {'key': 'subnets', 'type': '[SubnetResourceSettings]'},
    }

    def __init__(
        self,
        *,
        target_resource_name: str,
        enable_ddos_protection: Optional[bool] = None,
        address_space: Optional[List[str]] = None,
        dns_servers: Optional[List[str]] = None,
        subnets: Optional[List["SubnetResourceSettings"]] = None,
        **kwargs
    ):
        super(VirtualNetworkResourceSettings, self).__init__(target_resource_name=target_resource_name, **kwargs)
        self.resource_type: str = 'Microsoft.Network/virtualNetworks'
        self.enable_ddos_protection = enable_ddos_protection
        self.address_space = address_space
        self.dns_servers = dns_servers
        self.subnets = subnets
