# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AnalysisResultListResult(_serialization.Model):
    """A list of Analysis Results. It will only contain one element as all the data will be nested in a singleton object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Analysis Results.
    :vartype value: list[~azure.mgmt.testbase.models.AnalysisResultSingletonResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AnalysisResultSingletonResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AnalysisResultSingletonResource"]] = None, **kwargs):
        """
        :keyword value: The list of Analysis Results.
        :paramtype value: list[~azure.mgmt.testbase.models.AnalysisResultSingletonResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(_serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for an ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class AnalysisResultSingletonResource(ProxyResource):
    """The Analysis Result Singleton Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Known values are: "ScriptExecution",
     "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression", "MemoryRegression", and
     "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "grade": {"key": "properties.grade", "type": "str"},
        "analysis_result_type": {"key": "properties.analysisResultType", "type": "str"},
    }

    def __init__(self, *, grade: Optional[Union[str, "_models.Grade"]] = None, **kwargs):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.grade = grade
        self.analysis_result_type = None  # type: Optional[str]


class AnalysisResultSingletonResourceProperties(_serialization.Model):
    """The properties of Analysis Result resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CPURegressionResultSingletonResourceProperties,
    CPUUtilizationResultSingletonResourceProperties,
    MemoryRegressionResultSingletonResourceProperties,
    MemoryUtilizationResultSingletonResourceProperties,
    ReliabilityResultSingletonResourceProperties, ScriptExecutionResultSingletonResourceProperties,
    TestAnalysisResultSingletonResourceProperties

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
    }

    _subtype_map = {
        "analysis_result_type": {
            "CPURegression": "CPURegressionResultSingletonResourceProperties",
            "CPUUtilization": "CPUUtilizationResultSingletonResourceProperties",
            "MemoryRegression": "MemoryRegressionResultSingletonResourceProperties",
            "MemoryUtilization": "MemoryUtilizationResultSingletonResourceProperties",
            "Reliability": "ReliabilityResultSingletonResourceProperties",
            "ScriptExecution": "ScriptExecutionResultSingletonResourceProperties",
            "TestAnalysis": "TestAnalysisResultSingletonResourceProperties",
        }
    }

    def __init__(self, *, grade: Optional[Union[str, "_models.Grade"]] = None, **kwargs):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        """
        super().__init__(**kwargs)
        self.grade = grade
        self.analysis_result_type = None  # type: Optional[str]


class AvailableOSListResult(_serialization.Model):
    """A list of available OSs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of available OSs.
    :vartype value: list[~azure.mgmt.testbase.models.AvailableOSResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableOSResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailableOSResource"]] = None, **kwargs):
        """
        :keyword value: The list of available OSs.
        :paramtype value: list[~azure.mgmt.testbase.models.AvailableOSResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AvailableOSResource(ProxyResource):
    """The Available OS resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar os_id: The Id of an Available OS of a Test Base Account.
    :vartype os_id: str
    :ivar os_name: The name of an Available OS of a Test Base Account.
    :vartype os_name: str
    :ivar os_version: The version of an Available OS of a Test Base Account.
    :vartype os_version: str
    :ivar insider_channel: The insider channel of an Available OS of a Test Base Account.
    :vartype insider_channel: str
    :ivar os_update_type: The OS update type of an Available OS of a Test Base Account.
    :vartype os_update_type: str
    :ivar os_platform: The Platform of an Available OS of a Test Base Account.
    :vartype os_platform: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "os_id": {"key": "properties.osId", "type": "str"},
        "os_name": {"key": "properties.osName", "type": "str"},
        "os_version": {"key": "properties.osVersion", "type": "str"},
        "insider_channel": {"key": "properties.insiderChannel", "type": "str"},
        "os_update_type": {"key": "properties.osUpdateType", "type": "str"},
        "os_platform": {"key": "properties.osPlatform", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_id: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        insider_channel: Optional[str] = None,
        os_update_type: Optional[str] = None,
        os_platform: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword os_id: The Id of an Available OS of a Test Base Account.
        :paramtype os_id: str
        :keyword os_name: The name of an Available OS of a Test Base Account.
        :paramtype os_name: str
        :keyword os_version: The version of an Available OS of a Test Base Account.
        :paramtype os_version: str
        :keyword insider_channel: The insider channel of an Available OS of a Test Base Account.
        :paramtype insider_channel: str
        :keyword os_update_type: The OS update type of an Available OS of a Test Base Account.
        :paramtype os_update_type: str
        :keyword os_platform: The Platform of an Available OS of a Test Base Account.
        :paramtype os_platform: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.os_id = os_id
        self.os_name = os_name
        self.os_version = os_version
        self.insider_channel = insider_channel
        self.os_update_type = os_update_type
        self.os_platform = os_platform


class BillingHubExecutionUsageDetail(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """BillingHubExecutionUsageDetail.

    :ivar application_name:
    :vartype application_name: str
    :ivar application_version:
    :vartype application_version: str
    :ivar execution_request_id:
    :vartype execution_request_id: str
    :ivar sku:
    :vartype sku: str
    :ivar meter_id:
    :vartype meter_id: str
    :ivar start_time_stamp:
    :vartype start_time_stamp: ~datetime.datetime
    :ivar end_time_stamp:
    :vartype end_time_stamp: ~datetime.datetime
    :ivar os_build:
    :vartype os_build: str
    :ivar release:
    :vartype release: str
    :ivar test_type:
    :vartype test_type: str
    :ivar update_type:
    :vartype update_type: str
    :ivar used_free_hours:
    :vartype used_free_hours: float
    :ivar used_billable_hours:
    :vartype used_billable_hours: float
    :ivar billed_charges:
    :vartype billed_charges: float
    """

    _attribute_map = {
        "application_name": {"key": "applicationName", "type": "str"},
        "application_version": {"key": "applicationVersion", "type": "str"},
        "execution_request_id": {"key": "executionRequestId", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "meter_id": {"key": "meterId", "type": "str"},
        "start_time_stamp": {"key": "startTimeStamp", "type": "iso-8601"},
        "end_time_stamp": {"key": "endTimeStamp", "type": "iso-8601"},
        "os_build": {"key": "osBuild", "type": "str"},
        "release": {"key": "release", "type": "str"},
        "test_type": {"key": "testType", "type": "str"},
        "update_type": {"key": "updateType", "type": "str"},
        "used_free_hours": {"key": "usedFreeHours", "type": "float"},
        "used_billable_hours": {"key": "usedBillableHours", "type": "float"},
        "billed_charges": {"key": "billedCharges", "type": "float"},
    }

    def __init__(
        self,
        *,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        execution_request_id: Optional[str] = None,
        sku: Optional[str] = None,
        meter_id: Optional[str] = None,
        start_time_stamp: Optional[datetime.datetime] = None,
        end_time_stamp: Optional[datetime.datetime] = None,
        os_build: Optional[str] = None,
        release: Optional[str] = None,
        test_type: Optional[str] = None,
        update_type: Optional[str] = None,
        used_free_hours: Optional[float] = None,
        used_billable_hours: Optional[float] = None,
        billed_charges: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword application_name:
        :paramtype application_name: str
        :keyword application_version:
        :paramtype application_version: str
        :keyword execution_request_id:
        :paramtype execution_request_id: str
        :keyword sku:
        :paramtype sku: str
        :keyword meter_id:
        :paramtype meter_id: str
        :keyword start_time_stamp:
        :paramtype start_time_stamp: ~datetime.datetime
        :keyword end_time_stamp:
        :paramtype end_time_stamp: ~datetime.datetime
        :keyword os_build:
        :paramtype os_build: str
        :keyword release:
        :paramtype release: str
        :keyword test_type:
        :paramtype test_type: str
        :keyword update_type:
        :paramtype update_type: str
        :keyword used_free_hours:
        :paramtype used_free_hours: float
        :keyword used_billable_hours:
        :paramtype used_billable_hours: float
        :keyword billed_charges:
        :paramtype billed_charges: float
        """
        super().__init__(**kwargs)
        self.application_name = application_name
        self.application_version = application_version
        self.execution_request_id = execution_request_id
        self.sku = sku
        self.meter_id = meter_id
        self.start_time_stamp = start_time_stamp
        self.end_time_stamp = end_time_stamp
        self.os_build = os_build
        self.release = release
        self.test_type = test_type
        self.update_type = update_type
        self.used_free_hours = used_free_hours
        self.used_billable_hours = used_billable_hours
        self.billed_charges = billed_charges


class BillingHubFreeHourIncrementEntry(_serialization.Model):
    """BillingHubFreeHourIncrementEntry.

    :ivar create_time_stamp:
    :vartype create_time_stamp: ~datetime.datetime
    :ivar expiration_time_stamp:
    :vartype expiration_time_stamp: ~datetime.datetime
    :ivar incremental_free_hours:
    :vartype incremental_free_hours: float
    :ivar remaining_free_hours:
    :vartype remaining_free_hours: float
    """

    _attribute_map = {
        "create_time_stamp": {"key": "createTimeStamp", "type": "iso-8601"},
        "expiration_time_stamp": {"key": "expirationTimeStamp", "type": "iso-8601"},
        "incremental_free_hours": {"key": "incrementalFreeHours", "type": "float"},
        "remaining_free_hours": {"key": "remainingFreeHours", "type": "float"},
    }

    def __init__(
        self,
        *,
        create_time_stamp: Optional[datetime.datetime] = None,
        expiration_time_stamp: Optional[datetime.datetime] = None,
        incremental_free_hours: Optional[float] = None,
        remaining_free_hours: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword create_time_stamp:
        :paramtype create_time_stamp: ~datetime.datetime
        :keyword expiration_time_stamp:
        :paramtype expiration_time_stamp: ~datetime.datetime
        :keyword incremental_free_hours:
        :paramtype incremental_free_hours: float
        :keyword remaining_free_hours:
        :paramtype remaining_free_hours: float
        """
        super().__init__(**kwargs)
        self.create_time_stamp = create_time_stamp
        self.expiration_time_stamp = expiration_time_stamp
        self.incremental_free_hours = incremental_free_hours
        self.remaining_free_hours = remaining_free_hours


class BillingHubGetFreeHourBalanceResponse(_serialization.Model):
    """BillingHubGetFreeHourBalanceResponse.

    :ivar total_remaining_free_hours:
    :vartype total_remaining_free_hours: float
    :ivar increment_entries:
    :vartype increment_entries: list[~azure.mgmt.testbase.models.BillingHubFreeHourIncrementEntry]
    """

    _attribute_map = {
        "total_remaining_free_hours": {"key": "totalRemainingFreeHours", "type": "float"},
        "increment_entries": {"key": "incrementEntries", "type": "[BillingHubFreeHourIncrementEntry]"},
    }

    def __init__(
        self,
        *,
        total_remaining_free_hours: Optional[float] = None,
        increment_entries: Optional[List["_models.BillingHubFreeHourIncrementEntry"]] = None,
        **kwargs
    ):
        """
        :keyword total_remaining_free_hours:
        :paramtype total_remaining_free_hours: float
        :keyword increment_entries:
        :paramtype increment_entries:
         list[~azure.mgmt.testbase.models.BillingHubFreeHourIncrementEntry]
        """
        super().__init__(**kwargs)
        self.total_remaining_free_hours = total_remaining_free_hours
        self.increment_entries = increment_entries


class BillingHubGetUsageRequest(_serialization.Model):
    """BillingHubGetUsageRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time_stamp: Required.
    :vartype start_time_stamp: ~datetime.datetime
    :ivar end_time_stamp: Required.
    :vartype end_time_stamp: ~datetime.datetime
    :ivar page_size:
    :vartype page_size: int
    :ivar page_index:
    :vartype page_index: int
    """

    _validation = {
        "start_time_stamp": {"required": True},
        "end_time_stamp": {"required": True},
    }

    _attribute_map = {
        "start_time_stamp": {"key": "startTimeStamp", "type": "iso-8601"},
        "end_time_stamp": {"key": "endTimeStamp", "type": "iso-8601"},
        "page_size": {"key": "pageSize", "type": "int"},
        "page_index": {"key": "pageIndex", "type": "int"},
    }

    def __init__(
        self,
        *,
        start_time_stamp: datetime.datetime,
        end_time_stamp: datetime.datetime,
        page_size: Optional[int] = None,
        page_index: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword start_time_stamp: Required.
        :paramtype start_time_stamp: ~datetime.datetime
        :keyword end_time_stamp: Required.
        :paramtype end_time_stamp: ~datetime.datetime
        :keyword page_size:
        :paramtype page_size: int
        :keyword page_index:
        :paramtype page_index: int
        """
        super().__init__(**kwargs)
        self.start_time_stamp = start_time_stamp
        self.end_time_stamp = end_time_stamp
        self.page_size = page_size
        self.page_index = page_index


class BillingHubGetUsageResponse(_serialization.Model):
    """BillingHubGetUsageResponse.

    :ivar total_used_free_hours:
    :vartype total_used_free_hours: float
    :ivar total_used_billable_hours:
    :vartype total_used_billable_hours: float
    :ivar total_charges:
    :vartype total_charges: float
    :ivar package_usage_entries:
    :vartype package_usage_entries: list[~azure.mgmt.testbase.models.BillingHubPackageUsage]
    :ivar next_request:
    :vartype next_request: ~azure.mgmt.testbase.models.BillingHubGetUsageRequest
    """

    _attribute_map = {
        "total_used_free_hours": {"key": "totalUsedFreeHours", "type": "float"},
        "total_used_billable_hours": {"key": "totalUsedBillableHours", "type": "float"},
        "total_charges": {"key": "totalCharges", "type": "float"},
        "package_usage_entries": {"key": "packageUsageEntries", "type": "[BillingHubPackageUsage]"},
        "next_request": {"key": "nextRequest", "type": "BillingHubGetUsageRequest"},
    }

    def __init__(
        self,
        *,
        total_used_free_hours: Optional[float] = None,
        total_used_billable_hours: Optional[float] = None,
        total_charges: Optional[float] = None,
        package_usage_entries: Optional[List["_models.BillingHubPackageUsage"]] = None,
        next_request: Optional["_models.BillingHubGetUsageRequest"] = None,
        **kwargs
    ):
        """
        :keyword total_used_free_hours:
        :paramtype total_used_free_hours: float
        :keyword total_used_billable_hours:
        :paramtype total_used_billable_hours: float
        :keyword total_charges:
        :paramtype total_charges: float
        :keyword package_usage_entries:
        :paramtype package_usage_entries: list[~azure.mgmt.testbase.models.BillingHubPackageUsage]
        :keyword next_request:
        :paramtype next_request: ~azure.mgmt.testbase.models.BillingHubGetUsageRequest
        """
        super().__init__(**kwargs)
        self.total_used_free_hours = total_used_free_hours
        self.total_used_billable_hours = total_used_billable_hours
        self.total_charges = total_charges
        self.package_usage_entries = package_usage_entries
        self.next_request = next_request


class BillingHubPackageUsage(_serialization.Model):
    """BillingHubPackageUsage.

    :ivar application_name:
    :vartype application_name: str
    :ivar application_version:
    :vartype application_version: str
    :ivar azure_resource_uri:
    :vartype azure_resource_uri: str
    :ivar total_used_free_hours:
    :vartype total_used_free_hours: float
    :ivar total_used_billable_hours:
    :vartype total_used_billable_hours: float
    :ivar total_charges:
    :vartype total_charges: float
    :ivar usage_entries_grouped_by_update_type:
    :vartype usage_entries_grouped_by_update_type:
     list[~azure.mgmt.testbase.models.BillingHubUsageGroupedByUpdateType]
    """

    _attribute_map = {
        "application_name": {"key": "applicationName", "type": "str"},
        "application_version": {"key": "applicationVersion", "type": "str"},
        "azure_resource_uri": {"key": "azureResourceUri", "type": "str"},
        "total_used_free_hours": {"key": "totalUsedFreeHours", "type": "float"},
        "total_used_billable_hours": {"key": "totalUsedBillableHours", "type": "float"},
        "total_charges": {"key": "totalCharges", "type": "float"},
        "usage_entries_grouped_by_update_type": {
            "key": "usageEntriesGroupedByUpdateType",
            "type": "[BillingHubUsageGroupedByUpdateType]",
        },
    }

    def __init__(
        self,
        *,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        azure_resource_uri: Optional[str] = None,
        total_used_free_hours: Optional[float] = None,
        total_used_billable_hours: Optional[float] = None,
        total_charges: Optional[float] = None,
        usage_entries_grouped_by_update_type: Optional[List["_models.BillingHubUsageGroupedByUpdateType"]] = None,
        **kwargs
    ):
        """
        :keyword application_name:
        :paramtype application_name: str
        :keyword application_version:
        :paramtype application_version: str
        :keyword azure_resource_uri:
        :paramtype azure_resource_uri: str
        :keyword total_used_free_hours:
        :paramtype total_used_free_hours: float
        :keyword total_used_billable_hours:
        :paramtype total_used_billable_hours: float
        :keyword total_charges:
        :paramtype total_charges: float
        :keyword usage_entries_grouped_by_update_type:
        :paramtype usage_entries_grouped_by_update_type:
         list[~azure.mgmt.testbase.models.BillingHubUsageGroupedByUpdateType]
        """
        super().__init__(**kwargs)
        self.application_name = application_name
        self.application_version = application_version
        self.azure_resource_uri = azure_resource_uri
        self.total_used_free_hours = total_used_free_hours
        self.total_used_billable_hours = total_used_billable_hours
        self.total_charges = total_charges
        self.usage_entries_grouped_by_update_type = usage_entries_grouped_by_update_type


class BillingHubUsage(_serialization.Model):
    """BillingHubUsage.

    :ivar application_name:
    :vartype application_name: str
    :ivar application_version:
    :vartype application_version: str
    :ivar azure_resource_uri:
    :vartype azure_resource_uri: str
    :ivar total_used_free_hours:
    :vartype total_used_free_hours: float
    :ivar total_used_billable_hours:
    :vartype total_used_billable_hours: float
    :ivar total_charges:
    :vartype total_charges: float
    :ivar usage_groups:
    :vartype usage_groups: list[~azure.mgmt.testbase.models.BillingHubUsageGroup]
    """

    _attribute_map = {
        "application_name": {"key": "applicationName", "type": "str"},
        "application_version": {"key": "applicationVersion", "type": "str"},
        "azure_resource_uri": {"key": "azureResourceUri", "type": "str"},
        "total_used_free_hours": {"key": "totalUsedFreeHours", "type": "float"},
        "total_used_billable_hours": {"key": "totalUsedBillableHours", "type": "float"},
        "total_charges": {"key": "totalCharges", "type": "float"},
        "usage_groups": {"key": "usageGroups", "type": "[BillingHubUsageGroup]"},
    }

    def __init__(
        self,
        *,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        azure_resource_uri: Optional[str] = None,
        total_used_free_hours: Optional[float] = None,
        total_used_billable_hours: Optional[float] = None,
        total_charges: Optional[float] = None,
        usage_groups: Optional[List["_models.BillingHubUsageGroup"]] = None,
        **kwargs
    ):
        """
        :keyword application_name:
        :paramtype application_name: str
        :keyword application_version:
        :paramtype application_version: str
        :keyword azure_resource_uri:
        :paramtype azure_resource_uri: str
        :keyword total_used_free_hours:
        :paramtype total_used_free_hours: float
        :keyword total_used_billable_hours:
        :paramtype total_used_billable_hours: float
        :keyword total_charges:
        :paramtype total_charges: float
        :keyword usage_groups:
        :paramtype usage_groups: list[~azure.mgmt.testbase.models.BillingHubUsageGroup]
        """
        super().__init__(**kwargs)
        self.application_name = application_name
        self.application_version = application_version
        self.azure_resource_uri = azure_resource_uri
        self.total_used_free_hours = total_used_free_hours
        self.total_used_billable_hours = total_used_billable_hours
        self.total_charges = total_charges
        self.usage_groups = usage_groups


class BillingHubUsageGroup(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """BillingHubUsageGroup.

    :ivar total_used_free_hours:
    :vartype total_used_free_hours: float
    :ivar total_used_billable_hours:
    :vartype total_used_billable_hours: float
    :ivar total_charges:
    :vartype total_charges: float
    :ivar release_build_revision:
    :vartype release_build_revision: int
    :ivar release_build_number:
    :vartype release_build_number: int
    :ivar release_build_date:
    :vartype release_build_date: ~datetime.datetime
    :ivar os_build:
    :vartype os_build: str
    :ivar release:
    :vartype release: str
    :ivar test_type:
    :vartype test_type: str
    :ivar product_family:
    :vartype product_family: str
    :ivar execution_usage_details:
    :vartype execution_usage_details:
     list[~azure.mgmt.testbase.models.BillingHubExecutionUsageDetail]
    """

    _attribute_map = {
        "total_used_free_hours": {"key": "totalUsedFreeHours", "type": "float"},
        "total_used_billable_hours": {"key": "totalUsedBillableHours", "type": "float"},
        "total_charges": {"key": "totalCharges", "type": "float"},
        "release_build_revision": {"key": "releaseBuildRevision", "type": "int"},
        "release_build_number": {"key": "releaseBuildNumber", "type": "int"},
        "release_build_date": {"key": "releaseBuildDate", "type": "iso-8601"},
        "os_build": {"key": "osBuild", "type": "str"},
        "release": {"key": "release", "type": "str"},
        "test_type": {"key": "testType", "type": "str"},
        "product_family": {"key": "productFamily", "type": "str"},
        "execution_usage_details": {"key": "executionUsageDetails", "type": "[BillingHubExecutionUsageDetail]"},
    }

    def __init__(
        self,
        *,
        total_used_free_hours: Optional[float] = None,
        total_used_billable_hours: Optional[float] = None,
        total_charges: Optional[float] = None,
        release_build_revision: Optional[int] = None,
        release_build_number: Optional[int] = None,
        release_build_date: Optional[datetime.datetime] = None,
        os_build: Optional[str] = None,
        release: Optional[str] = None,
        test_type: Optional[str] = None,
        product_family: Optional[str] = None,
        execution_usage_details: Optional[List["_models.BillingHubExecutionUsageDetail"]] = None,
        **kwargs
    ):
        """
        :keyword total_used_free_hours:
        :paramtype total_used_free_hours: float
        :keyword total_used_billable_hours:
        :paramtype total_used_billable_hours: float
        :keyword total_charges:
        :paramtype total_charges: float
        :keyword release_build_revision:
        :paramtype release_build_revision: int
        :keyword release_build_number:
        :paramtype release_build_number: int
        :keyword release_build_date:
        :paramtype release_build_date: ~datetime.datetime
        :keyword os_build:
        :paramtype os_build: str
        :keyword release:
        :paramtype release: str
        :keyword test_type:
        :paramtype test_type: str
        :keyword product_family:
        :paramtype product_family: str
        :keyword execution_usage_details:
        :paramtype execution_usage_details:
         list[~azure.mgmt.testbase.models.BillingHubExecutionUsageDetail]
        """
        super().__init__(**kwargs)
        self.total_used_free_hours = total_used_free_hours
        self.total_used_billable_hours = total_used_billable_hours
        self.total_charges = total_charges
        self.release_build_revision = release_build_revision
        self.release_build_number = release_build_number
        self.release_build_date = release_build_date
        self.os_build = os_build
        self.release = release
        self.test_type = test_type
        self.product_family = product_family
        self.execution_usage_details = execution_usage_details


class BillingHubUsageGroupedByUpdateType(_serialization.Model):
    """BillingHubUsageGroupedByUpdateType.

    :ivar update_type:
    :vartype update_type: str
    :ivar total_used_free_hours:
    :vartype total_used_free_hours: float
    :ivar total_used_billable_hours:
    :vartype total_used_billable_hours: float
    :ivar total_charges:
    :vartype total_charges: float
    :ivar usage_groups:
    :vartype usage_groups: list[~azure.mgmt.testbase.models.BillingHubUsageGroup]
    """

    _attribute_map = {
        "update_type": {"key": "updateType", "type": "str"},
        "total_used_free_hours": {"key": "totalUsedFreeHours", "type": "float"},
        "total_used_billable_hours": {"key": "totalUsedBillableHours", "type": "float"},
        "total_charges": {"key": "totalCharges", "type": "float"},
        "usage_groups": {"key": "usageGroups", "type": "[BillingHubUsageGroup]"},
    }

    def __init__(
        self,
        *,
        update_type: Optional[str] = None,
        total_used_free_hours: Optional[float] = None,
        total_used_billable_hours: Optional[float] = None,
        total_charges: Optional[float] = None,
        usage_groups: Optional[List["_models.BillingHubUsageGroup"]] = None,
        **kwargs
    ):
        """
        :keyword update_type:
        :paramtype update_type: str
        :keyword total_used_free_hours:
        :paramtype total_used_free_hours: float
        :keyword total_used_billable_hours:
        :paramtype total_used_billable_hours: float
        :keyword total_charges:
        :paramtype total_charges: float
        :keyword usage_groups:
        :paramtype usage_groups: list[~azure.mgmt.testbase.models.BillingHubUsageGroup]
        """
        super().__init__(**kwargs)
        self.update_type = update_type
        self.total_used_free_hours = total_used_free_hours
        self.total_used_billable_hours = total_used_billable_hours
        self.total_charges = total_charges
        self.usage_groups = usage_groups


class CheckNameAvailabilityResult(_serialization.Model):
    """Description of a Check Name availability response properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Value indicating the availability of the name: true if the name is
     available; otherwise, false.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability of a name. Required if nameAvailable == false.
     Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.testbase.models.Reason
    :ivar message: The detailed info regarding the reason associated with the name. Required if
     nameAvailable == false.
    :vartype message: str
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, name_available: Optional[bool] = None, reason: Optional[Union[str, "_models.Reason"]] = None, **kwargs
    ):
        """
        :keyword name_available: Value indicating the availability of the name: true if the name is
         available; otherwise, false.
        :paramtype name_available: bool
        :keyword reason: The reason for unavailability of a name. Required if nameAvailable == false.
         Known values are: "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.testbase.models.Reason
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = None


class Command(_serialization.Model):
    """The command used in the test.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the command. Required.
    :vartype name: str
    :ivar action: The action of the command. Required. Known values are: "Install", "Launch",
     "Close", "Uninstall", and "Custom".
    :vartype action: str or ~azure.mgmt.testbase.models.Action
    :ivar content_type: The type of command content. Required. Known values are: "Inline", "File",
     and "Path".
    :vartype content_type: str or ~azure.mgmt.testbase.models.ContentType
    :ivar content: The content of the command. The content depends on source type. Required.
    :vartype content: str
    :ivar run_elevated: Specifies whether to run the command as administrator.
    :vartype run_elevated: bool
    :ivar restart_after: Specifies whether to restart the VM after the command executed.
    :vartype restart_after: bool
    :ivar max_run_time: Specifies the max run time of the command.
    :vartype max_run_time: int
    :ivar run_as_interactive: Specifies whether to run the command in interactive mode.
    :vartype run_as_interactive: bool
    :ivar always_run: Specifies whether to run the command even if a previous command is failed.
    :vartype always_run: bool
    :ivar apply_update_before: Specifies whether to apply update before the command.
    :vartype apply_update_before: bool
    """

    _validation = {
        "name": {"required": True},
        "action": {"required": True},
        "content_type": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "run_elevated": {"key": "runElevated", "type": "bool"},
        "restart_after": {"key": "restartAfter", "type": "bool"},
        "max_run_time": {"key": "maxRunTime", "type": "int"},
        "run_as_interactive": {"key": "runAsInteractive", "type": "bool"},
        "always_run": {"key": "alwaysRun", "type": "bool"},
        "apply_update_before": {"key": "applyUpdateBefore", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        action: Union[str, "_models.Action"],
        content_type: Union[str, "_models.ContentType"],
        content: str,
        run_elevated: Optional[bool] = None,
        restart_after: Optional[bool] = None,
        max_run_time: Optional[int] = None,
        run_as_interactive: Optional[bool] = None,
        always_run: Optional[bool] = None,
        apply_update_before: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the command. Required.
        :paramtype name: str
        :keyword action: The action of the command. Required. Known values are: "Install", "Launch",
         "Close", "Uninstall", and "Custom".
        :paramtype action: str or ~azure.mgmt.testbase.models.Action
        :keyword content_type: The type of command content. Required. Known values are: "Inline",
         "File", and "Path".
        :paramtype content_type: str or ~azure.mgmt.testbase.models.ContentType
        :keyword content: The content of the command. The content depends on source type. Required.
        :paramtype content: str
        :keyword run_elevated: Specifies whether to run the command as administrator.
        :paramtype run_elevated: bool
        :keyword restart_after: Specifies whether to restart the VM after the command executed.
        :paramtype restart_after: bool
        :keyword max_run_time: Specifies the max run time of the command.
        :paramtype max_run_time: int
        :keyword run_as_interactive: Specifies whether to run the command in interactive mode.
        :paramtype run_as_interactive: bool
        :keyword always_run: Specifies whether to run the command even if a previous command is failed.
        :paramtype always_run: bool
        :keyword apply_update_before: Specifies whether to apply update before the command.
        :paramtype apply_update_before: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.action = action
        self.content_type = content_type
        self.content = content
        self.run_elevated = run_elevated
        self.restart_after = restart_after
        self.max_run_time = max_run_time
        self.run_as_interactive = run_as_interactive
        self.always_run = always_run
        self.apply_update_before = apply_update_before


class CPURegressionResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of CPU Regression Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar cpu_regression_results: The result array data.
    :vartype cpu_regression_results: list[~azure.mgmt.testbase.models.RegressionResult]
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "cpu_regression_results": {"key": "cpuRegressionResults", "type": "[RegressionResult]"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        cpu_regression_results: Optional[List["_models.RegressionResult"]] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword cpu_regression_results: The result array data.
        :paramtype cpu_regression_results: list[~azure.mgmt.testbase.models.RegressionResult]
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "CPURegression"  # type: str
        self.cpu_regression_results = cpu_regression_results


class CPUUtilizationResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of CPU Utilization Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar cpu_utilization_results: The result array data.
    :vartype cpu_utilization_results: list[~azure.mgmt.testbase.models.UtilizationResult]
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "cpu_utilization_results": {"key": "cpuUtilizationResults", "type": "[UtilizationResult]"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        cpu_utilization_results: Optional[List["_models.UtilizationResult"]] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword cpu_utilization_results: The result array data.
        :paramtype cpu_utilization_results: list[~azure.mgmt.testbase.models.UtilizationResult]
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "CPUUtilization"  # type: str
        self.cpu_utilization_results = cpu_utilization_results


class CustomerEventListResult(_serialization.Model):
    """A list of Test Base Customer Events.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Base Customer Events.
    :vartype value: list[~azure.mgmt.testbase.models.CustomerEventResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomerEventResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.CustomerEventResource"]] = None, **kwargs):
        """
        :keyword value: The list of Test Base Customer Events.
        :paramtype value: list[~azure.mgmt.testbase.models.CustomerEventResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomerEventResource(ProxyResource):
    """The Customer Notification Event resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar event_name: The name of the event subscribed to.
    :vartype event_name: str
    :ivar receivers: The notification event receivers.
    :vartype receivers: list[~azure.mgmt.testbase.models.NotificationEventReceiver]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "event_name": {"key": "properties.eventName", "type": "str"},
        "receivers": {"key": "properties.receivers", "type": "[NotificationEventReceiver]"},
    }

    def __init__(
        self,
        *,
        event_name: Optional[str] = None,
        receivers: Optional[List["_models.NotificationEventReceiver"]] = None,
        **kwargs
    ):
        """
        :keyword event_name: The name of the event subscribed to.
        :paramtype event_name: str
        :keyword receivers: The notification event receivers.
        :paramtype receivers: list[~azure.mgmt.testbase.models.NotificationEventReceiver]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.event_name = event_name
        self.receivers = receivers


class DistributionGroupListReceiverValue(_serialization.Model):
    """The user object receiver value.

    :ivar distribution_groups: The list of distribution groups.
    :vartype distribution_groups: list[str]
    """

    _attribute_map = {
        "distribution_groups": {"key": "distributionGroups", "type": "[str]"},
    }

    def __init__(self, *, distribution_groups: Optional[List[str]] = None, **kwargs):
        """
        :keyword distribution_groups: The list of distribution groups.
        :paramtype distribution_groups: list[str]
        """
        super().__init__(**kwargs)
        self.distribution_groups = distribution_groups


class DownloadURLResponse(_serialization.Model):
    """The response of getting a download URL.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar download_url: The download URL.
    :vartype download_url: str
    :ivar expiration_time: Expiry date of the download URL.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        "download_url": {"readonly": True},
        "expiration_time": {"readonly": True},
    }

    _attribute_map = {
        "download_url": {"key": "downloadUrl", "type": "str"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.download_url = None
        self.expiration_time = None


class EmailEventListResult(_serialization.Model):
    """A list of email events.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of email events.
    :vartype value: list[~azure.mgmt.testbase.models.EmailEventResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EmailEventResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EmailEventResource"]] = None, **kwargs):
        """
        :keyword value: The list of email events.
        :paramtype value: list[~azure.mgmt.testbase.models.EmailEventResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EmailEventResource(ProxyResource):
    """The email event resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar event_id: The identifier of the email event.
    :vartype event_id: str
    :ivar event_name: The name of the email event.
    :vartype event_name: str
    :ivar display_name: The display name of the email event.
    :vartype display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "event_id": {"key": "properties.eventId", "type": "str"},
        "event_name": {"key": "properties.eventName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        event_name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword event_id: The identifier of the email event.
        :paramtype event_id: str
        :keyword event_name: The name of the email event.
        :paramtype event_name: str
        :keyword display_name: The display name of the email event.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.event_id = event_id
        self.event_name = event_name
        self.display_name = display_name


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.testbase.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None


class ErrorResponse(_serialization.Model):
    """The error response send when an operation fails.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.testbase.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs):
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.testbase.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class FavoriteProcessListResult(_serialization.Model):
    """A list of favorite processes for a package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of favorite processes for a package.
    :vartype value: list[~azure.mgmt.testbase.models.FavoriteProcessResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FavoriteProcessResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FavoriteProcessResource"]] = None, **kwargs):
        """
        :keyword value: The list of favorite processes for a package.
        :paramtype value: list[~azure.mgmt.testbase.models.FavoriteProcessResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FavoriteProcessResource(ProxyResource):
    """A favorite process identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar actual_process_name: The actual name of the favorite process. It will be equal to
     resource name except for the scenario that the process name contains characters that are not
     allowed in the resource name.
    :vartype actual_process_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "actual_process_name": {"key": "properties.actualProcessName", "type": "str"},
    }

    def __init__(self, *, actual_process_name: Optional[str] = None, **kwargs):
        """
        :keyword actual_process_name: The actual name of the favorite process. It will be equal to
         resource name except for the scenario that the process name contains characters that are not
         allowed in the resource name.
        :paramtype actual_process_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.actual_process_name = actual_process_name


class FileUploadURLResponse(_serialization.Model):
    """The URL response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar upload_url: The URL used for uploading the package.
    :vartype upload_url: str
    :ivar blob_path: The blob path of the uploaded package. It will be used as the 'blobPath'
     property of PackageResource.
    :vartype blob_path: str
    """

    _validation = {
        "upload_url": {"readonly": True},
        "blob_path": {"readonly": True},
    }

    _attribute_map = {
        "upload_url": {"key": "uploadUrl", "type": "str"},
        "blob_path": {"key": "blobPath", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.upload_url = None
        self.blob_path = None


class FlightingRingListResult(_serialization.Model):
    """A list of flighting rings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of flighting rings.
    :vartype value: list[~azure.mgmt.testbase.models.FlightingRingResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FlightingRingResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FlightingRingResource"]] = None, **kwargs):
        """
        :keyword value: The list of flighting rings.
        :paramtype value: list[~azure.mgmt.testbase.models.FlightingRingResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FlightingRingResource(ProxyResource):
    """The flighting ring resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar actual_flighting_ring_name: The actual name of a flighting ring of a Test Base Account.
    :vartype actual_flighting_ring_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "actual_flighting_ring_name": {"key": "properties.actualFlightingRingName", "type": "str"},
    }

    def __init__(self, *, actual_flighting_ring_name: Optional[str] = None, **kwargs):
        """
        :keyword actual_flighting_ring_name: The actual name of a flighting ring of a Test Base
         Account.
        :paramtype actual_flighting_ring_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.actual_flighting_ring_name = actual_flighting_ring_name


class GetFileUploadURLParameters(_serialization.Model):
    """The parameters supplied to the Test Base Account GetFileUploadURL action.

    :ivar blob_name: The custom file name of the uploaded blob.
    :vartype blob_name: str
    """

    _attribute_map = {
        "blob_name": {"key": "blobName", "type": "str"},
    }

    def __init__(self, *, blob_name: Optional[str] = None, **kwargs):
        """
        :keyword blob_name: The custom file name of the uploaded blob.
        :paramtype blob_name: str
        """
        super().__init__(**kwargs)
        self.blob_name = blob_name


class IdentifiedFailure(_serialization.Model):
    """The failure identified.

    :ivar failure_id: The Failure Id.
    :vartype failure_id: str
    :ivar category: The category of the failure. Known values are: "None", "Unidentified",
     "Package", "OSUpdate", and "Infrastructure".
    :vartype category: str or ~azure.mgmt.testbase.models.Category
    :ivar error_message: Message that shows information about the failure.
    :vartype error_message: str
    :ivar guidance: Guidance that shows what the customer needs to do for this failure.
    :vartype guidance: str
    """

    _attribute_map = {
        "failure_id": {"key": "failureId", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "guidance": {"key": "guidance", "type": "str"},
    }

    def __init__(
        self,
        *,
        failure_id: Optional[str] = None,
        category: Optional[Union[str, "_models.Category"]] = None,
        error_message: Optional[str] = None,
        guidance: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword failure_id: The Failure Id.
        :paramtype failure_id: str
        :keyword category: The category of the failure. Known values are: "None", "Unidentified",
         "Package", "OSUpdate", and "Infrastructure".
        :paramtype category: str or ~azure.mgmt.testbase.models.Category
        :keyword error_message: Message that shows information about the failure.
        :paramtype error_message: str
        :keyword guidance: Guidance that shows what the customer needs to do for this failure.
        :paramtype guidance: str
        """
        super().__init__(**kwargs)
        self.failure_id = failure_id
        self.category = category
        self.error_message = error_message
        self.guidance = guidance


class MemoryRegressionResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Memory Regression Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar memory_regression_results: The result array data.
    :vartype memory_regression_results: list[~azure.mgmt.testbase.models.RegressionResult]
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "memory_regression_results": {"key": "memoryRegressionResults", "type": "[RegressionResult]"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        memory_regression_results: Optional[List["_models.RegressionResult"]] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword memory_regression_results: The result array data.
        :paramtype memory_regression_results: list[~azure.mgmt.testbase.models.RegressionResult]
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "MemoryRegression"  # type: str
        self.memory_regression_results = memory_regression_results


class MemoryUtilizationResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Memory Utilization Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar memory_utilization_results: The result array data.
    :vartype memory_utilization_results: list[~azure.mgmt.testbase.models.UtilizationResult]
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "memory_utilization_results": {"key": "memoryUtilizationResults", "type": "[UtilizationResult]"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        memory_utilization_results: Optional[List["_models.UtilizationResult"]] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword memory_utilization_results: The result array data.
        :paramtype memory_utilization_results: list[~azure.mgmt.testbase.models.UtilizationResult]
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "MemoryUtilization"  # type: str
        self.memory_utilization_results = memory_utilization_results


class NotificationEventReceiver(_serialization.Model):
    """A notification event receivers.

    :ivar receiver_type: The type of the notification event receiver.
    :vartype receiver_type: str
    :ivar receiver_value: The notification event receiver value.
    :vartype receiver_value: ~azure.mgmt.testbase.models.NotificationReceiverValue
    """

    _attribute_map = {
        "receiver_type": {"key": "receiverType", "type": "str"},
        "receiver_value": {"key": "receiverValue", "type": "NotificationReceiverValue"},
    }

    def __init__(
        self,
        *,
        receiver_type: Optional[str] = None,
        receiver_value: Optional["_models.NotificationReceiverValue"] = None,
        **kwargs
    ):
        """
        :keyword receiver_type: The type of the notification event receiver.
        :paramtype receiver_type: str
        :keyword receiver_value: The notification event receiver value.
        :paramtype receiver_value: ~azure.mgmt.testbase.models.NotificationReceiverValue
        """
        super().__init__(**kwargs)
        self.receiver_type = receiver_type
        self.receiver_value = receiver_value


class NotificationReceiverValue(_serialization.Model):
    """A notification event receiver value.

    :ivar user_object_receiver_value: The user object receiver value.
    :vartype user_object_receiver_value: ~azure.mgmt.testbase.models.UserObjectReceiverValue
    :ivar subscription_receiver_value: The user object receiver value.
    :vartype subscription_receiver_value: ~azure.mgmt.testbase.models.SubscriptionReceiverValue
    :ivar distribution_group_list_receiver_value: The user object receiver value.
    :vartype distribution_group_list_receiver_value:
     ~azure.mgmt.testbase.models.DistributionGroupListReceiverValue
    """

    _attribute_map = {
        "user_object_receiver_value": {"key": "userObjectReceiverValue", "type": "UserObjectReceiverValue"},
        "subscription_receiver_value": {"key": "subscriptionReceiverValue", "type": "SubscriptionReceiverValue"},
        "distribution_group_list_receiver_value": {
            "key": "distributionGroupListReceiverValue",
            "type": "DistributionGroupListReceiverValue",
        },
    }

    def __init__(
        self,
        *,
        user_object_receiver_value: Optional["_models.UserObjectReceiverValue"] = None,
        subscription_receiver_value: Optional["_models.SubscriptionReceiverValue"] = None,
        distribution_group_list_receiver_value: Optional["_models.DistributionGroupListReceiverValue"] = None,
        **kwargs
    ):
        """
        :keyword user_object_receiver_value: The user object receiver value.
        :paramtype user_object_receiver_value: ~azure.mgmt.testbase.models.UserObjectReceiverValue
        :keyword subscription_receiver_value: The user object receiver value.
        :paramtype subscription_receiver_value: ~azure.mgmt.testbase.models.SubscriptionReceiverValue
        :keyword distribution_group_list_receiver_value: The user object receiver value.
        :paramtype distribution_group_list_receiver_value:
         ~azure.mgmt.testbase.models.DistributionGroupListReceiverValue
        """
        super().__init__(**kwargs)
        self.user_object_receiver_value = user_object_receiver_value
        self.subscription_receiver_value = subscription_receiver_value
        self.distribution_group_list_receiver_value = distribution_group_list_receiver_value


class Operation(_serialization.Model):
    """REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar display: The object that describes the operation.
    :vartype display: ~azure.mgmt.testbase.models.OperationDisplay
    :ivar properties: Extra properties of the operation.
    :vartype properties: JSON
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "origin": {"key": "origin", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self, *, display: Optional["_models.OperationDisplay"] = None, properties: Optional[JSON] = None, **kwargs
    ):
        """
        :keyword display: The object that describes the operation.
        :paramtype display: ~azure.mgmt.testbase.models.OperationDisplay
        :keyword properties: Extra properties of the operation.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.origin = None
        self.display = display
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """The object that describes the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider name: Microsoft.TestBase.
    :vartype provider: str
    :ivar operation: Operation type: read, write, delete, listPackages, etc.
    :vartype operation: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar description: Friendly name of the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.operation = None
        self.resource = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of operations supported by the resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the Test Base resource provider.
    :vartype value: list[~azure.mgmt.testbase.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: List of operations supported by the Test Base resource provider.
        :paramtype value: list[~azure.mgmt.testbase.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class OSUpdateListResult(_serialization.Model):
    """A list of OS Updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of OS Updates.
    :vartype value: list[~azure.mgmt.testbase.models.OSUpdateResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OSUpdateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.OSUpdateResource"]] = None, **kwargs):
        """
        :keyword value: The list of OS Updates.
        :paramtype value: list[~azure.mgmt.testbase.models.OSUpdateResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class OSUpdateResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An OS Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar os_name: The name of the OS.
    :vartype os_name: str
    :ivar release: The name of tested release.
    :vartype release: str
    :ivar flighting_ring: The flighting ring, only for release of feature updates.
    :vartype flighting_ring: str
    :ivar build_version: The build version of the tested release (OS update).
    :vartype build_version: str
    :ivar build_revision: The build revision of the tested release (OS update).
    :vartype build_revision: str
    :ivar type_properties_type: The type of this release (OS update). Known values are:
     "SecurityUpdate" and "FeatureUpdate".
    :vartype type_properties_type: str or ~azure.mgmt.testbase.models.Type
    :ivar release_version_date: The release version date the tested release (OS update).
    :vartype release_version_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "os_name": {"key": "properties.osName", "type": "str"},
        "release": {"key": "properties.release", "type": "str"},
        "flighting_ring": {"key": "properties.flightingRing", "type": "str"},
        "build_version": {"key": "properties.buildVersion", "type": "str"},
        "build_revision": {"key": "properties.buildRevision", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "release_version_date": {"key": "properties.releaseVersionDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        os_name: Optional[str] = None,
        release: Optional[str] = None,
        flighting_ring: Optional[str] = None,
        build_version: Optional[str] = None,
        build_revision: Optional[str] = None,
        type_properties_type: Optional[Union[str, "_models.Type"]] = None,
        release_version_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword os_name: The name of the OS.
        :paramtype os_name: str
        :keyword release: The name of tested release.
        :paramtype release: str
        :keyword flighting_ring: The flighting ring, only for release of feature updates.
        :paramtype flighting_ring: str
        :keyword build_version: The build version of the tested release (OS update).
        :paramtype build_version: str
        :keyword build_revision: The build revision of the tested release (OS update).
        :paramtype build_revision: str
        :keyword type_properties_type: The type of this release (OS update). Known values are:
         "SecurityUpdate" and "FeatureUpdate".
        :paramtype type_properties_type: str or ~azure.mgmt.testbase.models.Type
        :keyword release_version_date: The release version date the tested release (OS update).
        :paramtype release_version_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.os_name = os_name
        self.release = release
        self.flighting_ring = flighting_ring
        self.build_version = build_version
        self.build_revision = build_revision
        self.type_properties_type = type_properties_type
        self.release_version_date = release_version_date


class OSUpdatesTestSummary(_serialization.Model):
    """The summary of some tests.

    :ivar execution_status: The status of the last test. Known values are: "None", "InProgress",
     "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and "Succeeded".
    :vartype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
    :ivar test_status: The status of last test. Known values are: "None",
     "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
     "TestAndUpdateFailure", "InfrastructureFailure", and "Completed".
    :vartype test_status: str or ~azure.mgmt.testbase.models.TestStatus
    :ivar grade: The grade of last test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar test_run_time: The run time of the last test.
    :vartype test_run_time: str
    :ivar os_update_test_summaries: Detailed summary for each OS update.
    :vartype os_update_test_summaries: list[~azure.mgmt.testbase.models.OSUpdateTestSummary]
    """

    _attribute_map = {
        "execution_status": {"key": "executionStatus", "type": "str"},
        "test_status": {"key": "testStatus", "type": "str"},
        "grade": {"key": "grade", "type": "str"},
        "test_run_time": {"key": "testRunTime", "type": "str"},
        "os_update_test_summaries": {"key": "osUpdateTestSummaries", "type": "[OSUpdateTestSummary]"},
    }

    def __init__(
        self,
        *,
        execution_status: Optional[Union[str, "_models.ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "_models.TestStatus"]] = None,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        test_run_time: Optional[str] = None,
        os_update_test_summaries: Optional[List["_models.OSUpdateTestSummary"]] = None,
        **kwargs
    ):
        """
        :keyword execution_status: The status of the last test. Known values are: "None", "InProgress",
         "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and "Succeeded".
        :paramtype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
        :keyword test_status: The status of last test. Known values are: "None",
         "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
         "TestAndUpdateFailure", "InfrastructureFailure", and "Completed".
        :paramtype test_status: str or ~azure.mgmt.testbase.models.TestStatus
        :keyword grade: The grade of last test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword test_run_time: The run time of the last test.
        :paramtype test_run_time: str
        :keyword os_update_test_summaries: Detailed summary for each OS update.
        :paramtype os_update_test_summaries: list[~azure.mgmt.testbase.models.OSUpdateTestSummary]
        """
        super().__init__(**kwargs)
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.test_run_time = test_run_time
        self.os_update_test_summaries = os_update_test_summaries


class OSUpdateTestSummary(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The summary of a test.

    :ivar os_name: The operating system name. e.g. Windows 10 1809.
    :vartype os_name: str
    :ivar release_name: The name of the tested release (OS update).
    :vartype release_name: str
    :ivar build_version: The build version of the tested release (OS update).
    :vartype build_version: str
    :ivar build_revision: The build revision of the tested release (OS update).
    :vartype build_revision: str
    :ivar release_version_date: The release version date.
    :vartype release_version_date: ~datetime.datetime
    :ivar flighting_ring: The flighting ring, only for release of feature updates.
    :vartype flighting_ring: str
    :ivar execution_status: The execution status of the test. Known values are: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and
     "Succeeded".
    :vartype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
    :ivar test_status: The status of the test. Known values are: "None", "TestExecutionInProgress",
     "DataProcessing", "TestFailure", "UpdateFailure", "TestAndUpdateFailure",
     "InfrastructureFailure", and "Completed".
    :vartype test_status: str or ~azure.mgmt.testbase.models.TestStatus
    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar test_run_time: The run time of the test.
    :vartype test_run_time: str
    :ivar test_type: The test type of the package.
    :vartype test_type: str
    """

    _attribute_map = {
        "os_name": {"key": "osName", "type": "str"},
        "release_name": {"key": "releaseName", "type": "str"},
        "build_version": {"key": "buildVersion", "type": "str"},
        "build_revision": {"key": "buildRevision", "type": "str"},
        "release_version_date": {"key": "releaseVersionDate", "type": "iso-8601"},
        "flighting_ring": {"key": "flightingRing", "type": "str"},
        "execution_status": {"key": "executionStatus", "type": "str"},
        "test_status": {"key": "testStatus", "type": "str"},
        "grade": {"key": "grade", "type": "str"},
        "test_run_time": {"key": "testRunTime", "type": "str"},
        "test_type": {"key": "testType", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_name: Optional[str] = None,
        release_name: Optional[str] = None,
        build_version: Optional[str] = None,
        build_revision: Optional[str] = None,
        release_version_date: Optional[datetime.datetime] = None,
        flighting_ring: Optional[str] = None,
        execution_status: Optional[Union[str, "_models.ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "_models.TestStatus"]] = None,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        test_run_time: Optional[str] = None,
        test_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword os_name: The operating system name. e.g. Windows 10 1809.
        :paramtype os_name: str
        :keyword release_name: The name of the tested release (OS update).
        :paramtype release_name: str
        :keyword build_version: The build version of the tested release (OS update).
        :paramtype build_version: str
        :keyword build_revision: The build revision of the tested release (OS update).
        :paramtype build_revision: str
        :keyword release_version_date: The release version date.
        :paramtype release_version_date: ~datetime.datetime
        :keyword flighting_ring: The flighting ring, only for release of feature updates.
        :paramtype flighting_ring: str
        :keyword execution_status: The execution status of the test. Known values are: "None",
         "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and
         "Succeeded".
        :paramtype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
        :keyword test_status: The status of the test. Known values are: "None",
         "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
         "TestAndUpdateFailure", "InfrastructureFailure", and "Completed".
        :paramtype test_status: str or ~azure.mgmt.testbase.models.TestStatus
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword test_run_time: The run time of the test.
        :paramtype test_run_time: str
        :keyword test_type: The test type of the package.
        :paramtype test_type: str
        """
        super().__init__(**kwargs)
        self.os_name = os_name
        self.release_name = release_name
        self.build_version = build_version
        self.build_revision = build_revision
        self.release_version_date = release_version_date
        self.flighting_ring = flighting_ring
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.test_run_time = test_run_time
        self.test_type = test_type


class PackageCheckNameAvailabilityParameters(_serialization.Model):
    """Parameters body to pass for Test Base Package name availability check.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar application_name: Application name to verify. Required.
    :vartype application_name: str
    :ivar version: Version name to verify. Required.
    :vartype version: str
    :ivar type: fully qualified resource type which includes provider namespace.
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "application_name": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "application_name": {"key": "applicationName", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, application_name: str, version: str, type: Optional[str] = None, **kwargs):
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword application_name: Application name to verify. Required.
        :paramtype application_name: str
        :keyword version: Version name to verify. Required.
        :paramtype version: str
        :keyword type: fully qualified resource type which includes provider namespace.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.application_name = application_name
        self.version = version
        self.type = type


class PackageListResult(_serialization.Model):
    """A list of Test Base Packages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Base Packages.
    :vartype value: list[~azure.mgmt.testbase.models.PackageResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PackageResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PackageResource"]] = None, **kwargs):
        """
        :keyword value: The list of Test Base Packages.
        :paramtype value: list[~azure.mgmt.testbase.models.PackageResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TrackedResource(Resource):
    """The resource model definition for an ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.etag = None


class PackageResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Test Base Package resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Cancelled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.testbase.models.ProvisioningState
    :ivar application_name: Application name.
    :vartype application_name: str
    :ivar version: Application version.
    :vartype version: str
    :ivar test_types: OOB, functional or both. Mapped to the data in 'tests' property.
    :vartype test_types: list[str or ~azure.mgmt.testbase.models.TestType]
    :ivar target_os_list: Specifies the target OSs of specific OS Update types.
    :vartype target_os_list: list[~azure.mgmt.testbase.models.TargetOSInfo]
    :ivar package_status: The status of the package. Known values are: "Unknown", "Registered",
     "Ready", "Error", "ValidatingPackage", "PreValidationCheckPass", "Deleted",
     "ValidationLongerThanUsual", and "VerifyingPackage".
    :vartype package_status: str or ~azure.mgmt.testbase.models.PackageStatus
    :ivar last_modified_time: The UTC timestamp when the package was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar flighting_ring: The flighting ring for feature update.
    :vartype flighting_ring: str
    :ivar is_enabled: Flag showing that whether the package is enabled. It doesn't schedule test
     for package which is not enabled.
    :vartype is_enabled: bool
    :ivar blob_path: The file path of the package.
    :vartype blob_path: str
    :ivar validation_results: The validation results. There's validation on package when it's
     created or updated.
    :vartype validation_results: list[~azure.mgmt.testbase.models.PackageValidationResult]
    :ivar tests: The detailed test information.
    :vartype tests: list[~azure.mgmt.testbase.models.Test]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "test_types": {"readonly": True},
        "package_status": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "is_enabled": {"readonly": True},
        "validation_results": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "application_name": {"key": "properties.applicationName", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "test_types": {"key": "properties.testTypes", "type": "[str]"},
        "target_os_list": {"key": "properties.targetOSList", "type": "[TargetOSInfo]"},
        "package_status": {"key": "properties.packageStatus", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "flighting_ring": {"key": "properties.flightingRing", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "blob_path": {"key": "properties.blobPath", "type": "str"},
        "validation_results": {"key": "properties.validationResults", "type": "[PackageValidationResult]"},
        "tests": {"key": "properties.tests", "type": "[Test]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        application_name: Optional[str] = None,
        version: Optional[str] = None,
        target_os_list: Optional[List["_models.TargetOSInfo"]] = None,
        flighting_ring: Optional[str] = None,
        blob_path: Optional[str] = None,
        tests: Optional[List["_models.Test"]] = None,
        **kwargs
    ):
        """
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword application_name: Application name.
        :paramtype application_name: str
        :keyword version: Application version.
        :paramtype version: str
        :keyword target_os_list: Specifies the target OSs of specific OS Update types.
        :paramtype target_os_list: list[~azure.mgmt.testbase.models.TargetOSInfo]
        :keyword flighting_ring: The flighting ring for feature update.
        :paramtype flighting_ring: str
        :keyword blob_path: The file path of the package.
        :paramtype blob_path: str
        :keyword tests: The detailed test information.
        :paramtype tests: list[~azure.mgmt.testbase.models.Test]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.application_name = application_name
        self.version = version
        self.test_types = None
        self.target_os_list = target_os_list
        self.package_status = None
        self.last_modified_time = None
        self.flighting_ring = flighting_ring
        self.is_enabled = None
        self.blob_path = blob_path
        self.validation_results = None
        self.tests = tests


class PackageRunTestParameters(_serialization.Model):
    """The parameters supplied to the Test Base Package to start a Test Run.

    All required parameters must be populated in order to send to Azure.

    :ivar test_type: The type of the test. Required. Known values are: "OutOfBoxTest" and
     "FunctionalTest".
    :vartype test_type: str or ~azure.mgmt.testbase.models.TestType
    :ivar os_update_type: Specifies the OS update type to test against. Known values are:
     "SecurityUpdate" and "FeatureUpdate".
    :vartype os_update_type: str or ~azure.mgmt.testbase.models.OsUpdateType
    :ivar os_name: The operating system name. e.g. Windows 10 1809. Required.
    :vartype os_name: str
    :ivar release_name: The name of the tested release (OS update).
    :vartype release_name: str
    :ivar flighting_ring: The flighting ring, only for release of feature updates.
    :vartype flighting_ring: str
    """

    _validation = {
        "test_type": {"required": True},
        "os_name": {"required": True},
    }

    _attribute_map = {
        "test_type": {"key": "testType", "type": "str"},
        "os_update_type": {"key": "osUpdateType", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "release_name": {"key": "releaseName", "type": "str"},
        "flighting_ring": {"key": "flightingRing", "type": "str"},
    }

    def __init__(
        self,
        *,
        test_type: Union[str, "_models.TestType"],
        os_name: str,
        os_update_type: Optional[Union[str, "_models.OsUpdateType"]] = None,
        release_name: Optional[str] = None,
        flighting_ring: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword test_type: The type of the test. Required. Known values are: "OutOfBoxTest" and
         "FunctionalTest".
        :paramtype test_type: str or ~azure.mgmt.testbase.models.TestType
        :keyword os_update_type: Specifies the OS update type to test against. Known values are:
         "SecurityUpdate" and "FeatureUpdate".
        :paramtype os_update_type: str or ~azure.mgmt.testbase.models.OsUpdateType
        :keyword os_name: The operating system name. e.g. Windows 10 1809. Required.
        :paramtype os_name: str
        :keyword release_name: The name of the tested release (OS update).
        :paramtype release_name: str
        :keyword flighting_ring: The flighting ring, only for release of feature updates.
        :paramtype flighting_ring: str
        """
        super().__init__(**kwargs)
        self.test_type = test_type
        self.os_update_type = os_update_type
        self.os_name = os_name
        self.release_name = release_name
        self.flighting_ring = flighting_ring


class PackageUpdateParameters(_serialization.Model):
    """Parameters supplied to update a Test Base Package.

    :ivar tags: The tags of the Package.
    :vartype tags: dict[str, str]
    :ivar target_os_list: Specifies the target OSs of specific OS Update types.
    :vartype target_os_list: list[~azure.mgmt.testbase.models.TargetOSInfo]
    :ivar flighting_ring: The flighting ring for feature update.
    :vartype flighting_ring: str
    :ivar is_enabled: Specifies whether the package is enabled. It doesn't schedule test for
     package which is not enabled.
    :vartype is_enabled: bool
    :ivar blob_path: The file name of the package.
    :vartype blob_path: str
    :ivar tests: The detailed test information.
    :vartype tests: list[~azure.mgmt.testbase.models.Test]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "target_os_list": {"key": "properties.targetOSList", "type": "[TargetOSInfo]"},
        "flighting_ring": {"key": "properties.flightingRing", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "blob_path": {"key": "properties.blobPath", "type": "str"},
        "tests": {"key": "properties.tests", "type": "[Test]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        target_os_list: Optional[List["_models.TargetOSInfo"]] = None,
        flighting_ring: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        blob_path: Optional[str] = None,
        tests: Optional[List["_models.Test"]] = None,
        **kwargs
    ):
        """
        :keyword tags: The tags of the Package.
        :paramtype tags: dict[str, str]
        :keyword target_os_list: Specifies the target OSs of specific OS Update types.
        :paramtype target_os_list: list[~azure.mgmt.testbase.models.TargetOSInfo]
        :keyword flighting_ring: The flighting ring for feature update.
        :paramtype flighting_ring: str
        :keyword is_enabled: Specifies whether the package is enabled. It doesn't schedule test for
         package which is not enabled.
        :paramtype is_enabled: bool
        :keyword blob_path: The file name of the package.
        :paramtype blob_path: str
        :keyword tests: The detailed test information.
        :paramtype tests: list[~azure.mgmt.testbase.models.Test]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.target_os_list = target_os_list
        self.flighting_ring = flighting_ring
        self.is_enabled = is_enabled
        self.blob_path = blob_path
        self.tests = tests


class PackageValidationResult(_serialization.Model):
    """The validation results. There's validation on package when it's created or updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_name: Validation name.
    :vartype validation_name: str
    :ivar is_valid: Indicates whether the package passed the validation.
    :vartype is_valid: bool
    :ivar errors: Error information.
    :vartype errors: list[str]
    """

    _validation = {
        "validation_name": {"readonly": True},
        "is_valid": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "validation_name": {"key": "validationName", "type": "str"},
        "is_valid": {"key": "isValid", "type": "bool"},
        "errors": {"key": "errors", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.validation_name = None
        self.is_valid = None
        self.errors = None


class RegressionResult(_serialization.Model):
    """The regression result.

    :ivar file_name: FileName of the binary being analyzed.
    :vartype file_name: str
    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar details: Message that facilitates debugging a particular regression, if any was inferred.
    :vartype details: str
    :ivar diff: Difference between the two datasets being analyzed.
    :vartype diff: float
    :ivar is_regressed: Indicates if a regression was inferred.
    :vartype is_regressed: bool
    """

    _attribute_map = {
        "file_name": {"key": "fileName", "type": "str"},
        "grade": {"key": "grade", "type": "str"},
        "details": {"key": "details", "type": "str"},
        "diff": {"key": "diff", "type": "float"},
        "is_regressed": {"key": "isRegressed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        details: Optional[str] = None,
        diff: Optional[float] = None,
        is_regressed: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword file_name: FileName of the binary being analyzed.
        :paramtype file_name: str
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword details: Message that facilitates debugging a particular regression, if any was
         inferred.
        :paramtype details: str
        :keyword diff: Difference between the two datasets being analyzed.
        :paramtype diff: float
        :keyword is_regressed: Indicates if a regression was inferred.
        :paramtype is_regressed: bool
        """
        super().__init__(**kwargs)
        self.file_name = file_name
        self.grade = grade
        self.details = details
        self.diff = diff
        self.is_regressed = is_regressed


class RegressionTestDetails(_serialization.Model):
    """The details of a regression test.

    :ivar diff: Difference between the two datasets being analyzed.
    :vartype diff: float
    :ivar is_regressed: Indicates if a regression was inferred.
    :vartype is_regressed: bool
    """

    _attribute_map = {
        "diff": {"key": "diff", "type": "float"},
        "is_regressed": {"key": "isRegressed", "type": "bool"},
    }

    def __init__(self, *, diff: Optional[float] = None, is_regressed: Optional[bool] = None, **kwargs):
        """
        :keyword diff: Difference between the two datasets being analyzed.
        :paramtype diff: float
        :keyword is_regressed: Indicates if a regression was inferred.
        :paramtype is_regressed: bool
        """
        super().__init__(**kwargs)
        self.diff = diff
        self.is_regressed = is_regressed


class ReliabilityResult(_serialization.Model):
    """The Reliability Result.

    :ivar file_name: File name.
    :vartype file_name: str
    :ivar launch_count: Count of number of launches.
    :vartype launch_count: int
    :ivar crash_count: Count of number of crashes.
    :vartype crash_count: int
    :ivar hang_count: Count of number of hangs.
    :vartype hang_count: int
    :ivar regression_grade: The regression grade. Known values are: "None", "NotAvailable", "Pass",
     and "Fail".
    :vartype regression_grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar crash_regression_grade: The statistic regression grade for crash signal. Known values
     are: "None", "NotAvailable", "Pass", and "Fail".
    :vartype crash_regression_grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar crash_regression_test_details: Details related to the crash regression analysis.
    :vartype crash_regression_test_details: ~azure.mgmt.testbase.models.RegressionTestDetails
    :ivar hang_regression_grade: The statistic regression grade for hang signal. Known values are:
     "None", "NotAvailable", "Pass", and "Fail".
    :vartype hang_regression_grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar hang_regression_test_details: Details related to the hang regression analysis.
    :vartype hang_regression_test_details: ~azure.mgmt.testbase.models.RegressionTestDetails
    """

    _attribute_map = {
        "file_name": {"key": "fileName", "type": "str"},
        "launch_count": {"key": "launchCount", "type": "int"},
        "crash_count": {"key": "crashCount", "type": "int"},
        "hang_count": {"key": "hangCount", "type": "int"},
        "regression_grade": {"key": "regressionGrade", "type": "str"},
        "crash_regression_grade": {"key": "crashRegressionGrade", "type": "str"},
        "crash_regression_test_details": {"key": "crashRegressionTestDetails", "type": "RegressionTestDetails"},
        "hang_regression_grade": {"key": "hangRegressionGrade", "type": "str"},
        "hang_regression_test_details": {"key": "hangRegressionTestDetails", "type": "RegressionTestDetails"},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        launch_count: Optional[int] = None,
        crash_count: Optional[int] = None,
        hang_count: Optional[int] = None,
        regression_grade: Optional[Union[str, "_models.Grade"]] = None,
        crash_regression_grade: Optional[Union[str, "_models.Grade"]] = None,
        crash_regression_test_details: Optional["_models.RegressionTestDetails"] = None,
        hang_regression_grade: Optional[Union[str, "_models.Grade"]] = None,
        hang_regression_test_details: Optional["_models.RegressionTestDetails"] = None,
        **kwargs
    ):
        """
        :keyword file_name: File name.
        :paramtype file_name: str
        :keyword launch_count: Count of number of launches.
        :paramtype launch_count: int
        :keyword crash_count: Count of number of crashes.
        :paramtype crash_count: int
        :keyword hang_count: Count of number of hangs.
        :paramtype hang_count: int
        :keyword regression_grade: The regression grade. Known values are: "None", "NotAvailable",
         "Pass", and "Fail".
        :paramtype regression_grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword crash_regression_grade: The statistic regression grade for crash signal. Known values
         are: "None", "NotAvailable", "Pass", and "Fail".
        :paramtype crash_regression_grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword crash_regression_test_details: Details related to the crash regression analysis.
        :paramtype crash_regression_test_details: ~azure.mgmt.testbase.models.RegressionTestDetails
        :keyword hang_regression_grade: The statistic regression grade for hang signal. Known values
         are: "None", "NotAvailable", "Pass", and "Fail".
        :paramtype hang_regression_grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword hang_regression_test_details: Details related to the hang regression analysis.
        :paramtype hang_regression_test_details: ~azure.mgmt.testbase.models.RegressionTestDetails
        """
        super().__init__(**kwargs)
        self.file_name = file_name
        self.launch_count = launch_count
        self.crash_count = crash_count
        self.hang_count = hang_count
        self.regression_grade = regression_grade
        self.crash_regression_grade = crash_regression_grade
        self.crash_regression_test_details = crash_regression_test_details
        self.hang_regression_grade = hang_regression_grade
        self.hang_regression_test_details = hang_regression_test_details


class ReliabilityResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Reliability Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar reliability_results: The result array data.
    :vartype reliability_results: list[~azure.mgmt.testbase.models.ReliabilityResult]
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "reliability_results": {"key": "reliabilityResults", "type": "[ReliabilityResult]"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        reliability_results: Optional[List["_models.ReliabilityResult"]] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword reliability_results: The result array data.
        :paramtype reliability_results: list[~azure.mgmt.testbase.models.ReliabilityResult]
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "Reliability"  # type: str
        self.reliability_results = reliability_results


class ScriptExecutionResult(_serialization.Model):
    """The Script Execution Result.

    :ivar script_name: Name of script.
    :vartype script_name: str
    :ivar start_time: Start time of script execution.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of script execution.
    :vartype end_time: ~datetime.datetime
    :ivar exit_code: Exit code.
    :vartype exit_code: int
    :ivar timed_out: Whether the script execution is timed out.
    :vartype timed_out: bool
    :ivar stdout_log_file_name: The stdout log file name.
    :vartype stdout_log_file_name: str
    :ivar stderr_log_file_name: The stderr log file name.
    :vartype stderr_log_file_name: str
    """

    _attribute_map = {
        "script_name": {"key": "scriptName", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "exit_code": {"key": "exitCode", "type": "int"},
        "timed_out": {"key": "timedOut", "type": "bool"},
        "stdout_log_file_name": {"key": "stdoutLogFileName", "type": "str"},
        "stderr_log_file_name": {"key": "stderrLogFileName", "type": "str"},
    }

    def __init__(
        self,
        *,
        script_name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        exit_code: Optional[int] = None,
        timed_out: Optional[bool] = None,
        stdout_log_file_name: Optional[str] = None,
        stderr_log_file_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword script_name: Name of script.
        :paramtype script_name: str
        :keyword start_time: Start time of script execution.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of script execution.
        :paramtype end_time: ~datetime.datetime
        :keyword exit_code: Exit code.
        :paramtype exit_code: int
        :keyword timed_out: Whether the script execution is timed out.
        :paramtype timed_out: bool
        :keyword stdout_log_file_name: The stdout log file name.
        :paramtype stdout_log_file_name: str
        :keyword stderr_log_file_name: The stderr log file name.
        :paramtype stderr_log_file_name: str
        """
        super().__init__(**kwargs)
        self.script_name = script_name
        self.start_time = start_time
        self.end_time = end_time
        self.exit_code = exit_code
        self.timed_out = timed_out
        self.stdout_log_file_name = stdout_log_file_name
        self.stderr_log_file_name = stderr_log_file_name


class ScriptExecutionResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Script Execution Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar script_execution_results: The result array data.
    :vartype script_execution_results: list[~azure.mgmt.testbase.models.ScriptExecutionResult]
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "script_execution_results": {"key": "scriptExecutionResults", "type": "[ScriptExecutionResult]"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        script_execution_results: Optional[List["_models.ScriptExecutionResult"]] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword script_execution_results: The result array data.
        :paramtype script_execution_results: list[~azure.mgmt.testbase.models.ScriptExecutionResult]
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "ScriptExecution"  # type: str
        self.script_execution_results = script_execution_results


class SubscriptionReceiverValue(_serialization.Model):
    """The subscription role receiver value.

    :ivar subscription_id: The subscription id of the notification receiver.
    :vartype subscription_id: str
    :ivar subscription_name: The subscription name of the notification receiver.
    :vartype subscription_name: str
    :ivar role: The role of the notification receiver.
    :vartype role: str
    """

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "subscription_name": {"key": "subscriptionName", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        subscription_name: Optional[str] = None,
        role: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subscription_id: The subscription id of the notification receiver.
        :paramtype subscription_id: str
        :keyword subscription_name: The subscription name of the notification receiver.
        :paramtype subscription_name: str
        :keyword role: The role of the notification receiver.
        :paramtype role: str
        """
        super().__init__(**kwargs)
        self.subscription_id = subscription_id
        self.subscription_name = subscription_name
        self.role = role


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.testbase.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.testbase.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.testbase.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.testbase.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetOSInfo(_serialization.Model):
    """The information of the target OS to be tested.

    All required parameters must be populated in order to send to Azure.

    :ivar os_update_type: Specifies the OS update type to test against, e.g., 'Security updates' or
     'Feature updates'. Required.
    :vartype os_update_type: str
    :ivar target_o_ss: Specifies the target OSs to be tested. Required.
    :vartype target_o_ss: list[str]
    :ivar baseline_o_ss: Specifies the baseline OSs to be tested.
    :vartype baseline_o_ss: list[str]
    """

    _validation = {
        "os_update_type": {"required": True},
        "target_o_ss": {"required": True},
    }

    _attribute_map = {
        "os_update_type": {"key": "osUpdateType", "type": "str"},
        "target_o_ss": {"key": "targetOSs", "type": "[str]"},
        "baseline_o_ss": {"key": "baselineOSs", "type": "[str]"},
    }

    def __init__(
        self, *, os_update_type: str, target_o_ss: List[str], baseline_o_ss: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword os_update_type: Specifies the OS update type to test against, e.g., 'Security updates'
         or 'Feature updates'. Required.
        :paramtype os_update_type: str
        :keyword target_o_ss: Specifies the target OSs to be tested. Required.
        :paramtype target_o_ss: list[str]
        :keyword baseline_o_ss: Specifies the baseline OSs to be tested.
        :paramtype baseline_o_ss: list[str]
        """
        super().__init__(**kwargs)
        self.os_update_type = os_update_type
        self.target_o_ss = target_o_ss
        self.baseline_o_ss = baseline_o_ss


class Test(_serialization.Model):
    """The definition of a Test.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar test_type: The type of the test. Required. Known values are: "OutOfBoxTest" and
     "FunctionalTest".
    :vartype test_type: str or ~azure.mgmt.testbase.models.TestType
    :ivar validation_run_status: The status of the validation run of the package. Known values are:
     "Unknown", "Pending", "Passed", and "Failed".
    :vartype validation_run_status: str or ~azure.mgmt.testbase.models.ValidationRunStatus
    :ivar validation_result_id: Resource identifier of the validation test result.
    :vartype validation_result_id: str
    :ivar is_active: Indicates if this test is active.It doesn't schedule test for not active Test.
    :vartype is_active: bool
    :ivar commands: The commands used in the test. Required.
    :vartype commands: list[~azure.mgmt.testbase.models.Command]
    """

    _validation = {
        "test_type": {"required": True},
        "validation_run_status": {"readonly": True},
        "validation_result_id": {"readonly": True},
        "commands": {"required": True},
    }

    _attribute_map = {
        "test_type": {"key": "testType", "type": "str"},
        "validation_run_status": {"key": "validationRunStatus", "type": "str"},
        "validation_result_id": {"key": "validationResultId", "type": "str"},
        "is_active": {"key": "isActive", "type": "bool"},
        "commands": {"key": "commands", "type": "[Command]"},
    }

    def __init__(
        self,
        *,
        test_type: Union[str, "_models.TestType"],
        commands: List["_models.Command"],
        is_active: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword test_type: The type of the test. Required. Known values are: "OutOfBoxTest" and
         "FunctionalTest".
        :paramtype test_type: str or ~azure.mgmt.testbase.models.TestType
        :keyword is_active: Indicates if this test is active.It doesn't schedule test for not active
         Test.
        :paramtype is_active: bool
        :keyword commands: The commands used in the test. Required.
        :paramtype commands: list[~azure.mgmt.testbase.models.Command]
        """
        super().__init__(**kwargs)
        self.test_type = test_type
        self.validation_run_status = None
        self.validation_result_id = None
        self.is_active = is_active
        self.commands = commands


class TestAnalysisResult(_serialization.Model):
    """The test analysis result.

    :ivar blob_data: The data to provide more failure analysis information.
    :vartype blob_data: str
    :ivar test_analysis_status: The status of the analysis. Known values are: "None", "Analyzing",
     "Completed", and "Failed".
    :vartype test_analysis_status: str or ~azure.mgmt.testbase.models.TestAnalysisStatus
    :ivar identified_failures: The array of identified failures.
    :vartype identified_failures: list[~azure.mgmt.testbase.models.IdentifiedFailure]
    """

    _attribute_map = {
        "blob_data": {"key": "blobData", "type": "str"},
        "test_analysis_status": {"key": "testAnalysisStatus", "type": "str"},
        "identified_failures": {"key": "identifiedFailures", "type": "[IdentifiedFailure]"},
    }

    def __init__(
        self,
        *,
        blob_data: Optional[str] = None,
        test_analysis_status: Optional[Union[str, "_models.TestAnalysisStatus"]] = None,
        identified_failures: Optional[List["_models.IdentifiedFailure"]] = None,
        **kwargs
    ):
        """
        :keyword blob_data: The data to provide more failure analysis information.
        :paramtype blob_data: str
        :keyword test_analysis_status: The status of the analysis. Known values are: "None",
         "Analyzing", "Completed", and "Failed".
        :paramtype test_analysis_status: str or ~azure.mgmt.testbase.models.TestAnalysisStatus
        :keyword identified_failures: The array of identified failures.
        :paramtype identified_failures: list[~azure.mgmt.testbase.models.IdentifiedFailure]
        """
        super().__init__(**kwargs)
        self.blob_data = blob_data
        self.test_analysis_status = test_analysis_status
        self.identified_failures = identified_failures


class TestAnalysisResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Test Analysis Result.

    All required parameters must be populated in order to send to Azure.

    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar analysis_result_type: Type of the Analysis Result. Required. Known values are:
     "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization", "CPURegression",
     "MemoryRegression", and "TestAnalysis".
    :vartype analysis_result_type: str or ~azure.mgmt.testbase.models.AnalysisResultType
    :ivar test_analysis_result: The result of test analysis.
    :vartype test_analysis_result: ~azure.mgmt.testbase.models.TestAnalysisResult
    """

    _validation = {
        "analysis_result_type": {"required": True},
    }

    _attribute_map = {
        "grade": {"key": "grade", "type": "str"},
        "analysis_result_type": {"key": "analysisResultType", "type": "str"},
        "test_analysis_result": {"key": "testAnalysisResult", "type": "TestAnalysisResult"},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        test_analysis_result: Optional["_models.TestAnalysisResult"] = None,
        **kwargs
    ):
        """
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword test_analysis_result: The result of test analysis.
        :paramtype test_analysis_result: ~azure.mgmt.testbase.models.TestAnalysisResult
        """
        super().__init__(grade=grade, **kwargs)
        self.analysis_result_type = "TestAnalysis"  # type: str
        self.test_analysis_result = test_analysis_result


class TestBaseAccountListResult(_serialization.Model):
    """A list of Test Base Accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Base Accounts.
    :vartype value: list[~azure.mgmt.testbase.models.TestBaseAccountResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestBaseAccountResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TestBaseAccountResource"]] = None, **kwargs):
        """
        :keyword value: The list of Test Base Accounts.
        :paramtype value: list[~azure.mgmt.testbase.models.TestBaseAccountResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestBaseAccountResource(TrackedResource):
    """The Test Base Account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Cancelled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.testbase.models.ProvisioningState
    :ivar sku: The SKU of the Test Base Account.
    :vartype sku: ~azure.mgmt.testbase.models.TestBaseAccountSKU
    :ivar access_level: The access level of the Test Base Account.
    :vartype access_level: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "access_level": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sku": {"key": "properties.sku", "type": "TestBaseAccountSKU"},
        "access_level": {"key": "properties.accessLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.TestBaseAccountSKU"] = None,
        **kwargs
    ):
        """
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The SKU of the Test Base Account.
        :paramtype sku: ~azure.mgmt.testbase.models.TestBaseAccountSKU
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.sku = sku
        self.access_level = None


class TestBaseAccountSKU(_serialization.Model):
    """Describes a Test Base Account SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of the SKU. This is typically a letter + number code, such as B0 or S0.
     Required.
    :vartype name: str
    :ivar tier: The tier of this particular SKU. Required. "Standard"
    :vartype tier: str or ~azure.mgmt.testbase.models.Tier
    :ivar capabilities: The capabilities of a SKU.
    :vartype capabilities: list[~azure.mgmt.testbase.models.TestBaseAccountSKUCapability]
    :ivar locations: The locations that the SKU is available.
    :vartype locations: list[str]
    """

    _validation = {
        "name": {"required": True},
        "tier": {"required": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "[TestBaseAccountSKUCapability]"},
        "locations": {"key": "locations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Union[str, "_models.Tier"],
        resource_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword resource_type: The type of resource the SKU applies to.
        :paramtype resource_type: str
        :keyword name: The name of the SKU. This is typically a letter + number code, such as B0 or S0.
         Required.
        :paramtype name: str
        :keyword tier: The tier of this particular SKU. Required. "Standard"
        :paramtype tier: str or ~azure.mgmt.testbase.models.Tier
        :keyword locations: The locations that the SKU is available.
        :paramtype locations: list[str]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.name = name
        self.tier = tier
        self.capabilities = None
        self.locations = locations


class TestBaseAccountSKUCapability(_serialization.Model):
    """Properties of the Test Base Account SKU Capability.

    All required parameters must be populated in order to send to Azure.

    :ivar name: An invariant to describe the feature, such as 'SLA'. Required.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity, such as 99.9%. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs):
        """
        :keyword name: An invariant to describe the feature, such as 'SLA'. Required.
        :paramtype name: str
        :keyword value: An invariant if the feature is measured by quantity, such as 99.9%. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class TestBaseAccountSKUListResult(_serialization.Model):
    """A list of Test Base Account SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Base Account SKUs.
    :vartype value: list[~azure.mgmt.testbase.models.TestBaseAccountSKU]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestBaseAccountSKU]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TestBaseAccountSKU"]] = None, **kwargs):
        """
        :keyword value: The list of Test Base Account SKUs.
        :paramtype value: list[~azure.mgmt.testbase.models.TestBaseAccountSKU]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestBaseAccountUpdateParameters(_serialization.Model):
    """Parameters supplied to update a Test Base Account.

    :ivar tags: The tags of the Test Base Account.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU of the Test Base Account.
    :vartype sku: ~azure.mgmt.testbase.models.TestBaseAccountSKU
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "properties.sku", "type": "TestBaseAccountSKU"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, sku: Optional["_models.TestBaseAccountSKU"] = None, **kwargs
    ):
        """
        :keyword tags: The tags of the Test Base Account.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the Test Base Account.
        :paramtype sku: ~azure.mgmt.testbase.models.TestBaseAccountSKU
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku


class TestBaseAccountUsageData(_serialization.Model):
    """The usage data of a Test Base Account.

    :ivar id: Fully qualified ARM resource id.
    :vartype id: str
    :ivar name: Localizable String object containing the name and a localized value.
    :vartype name: ~azure.mgmt.testbase.models.TestBaseAccountUsageName
    :ivar unit: Representing the units of the usage quota. Possible values are: Count, Bytes,
     Seconds, Percent, CountPerSecond, BytesPerSecond.
    :vartype unit: str
    :ivar limit: The maximum permitted value for the usage quota. If there is no limit, this value
     will be -1.
    :vartype limit: int
    :ivar current_value: Current value for the usage quota.
    :vartype current_value: int
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "TestBaseAccountUsageName"},
        "unit": {"key": "unit", "type": "str"},
        "limit": {"key": "limit", "type": "int"},
        "current_value": {"key": "currentValue", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional["_models.TestBaseAccountUsageName"] = None,
        unit: Optional[str] = None,
        limit: Optional[int] = None,
        current_value: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified ARM resource id.
        :paramtype id: str
        :keyword name: Localizable String object containing the name and a localized value.
        :paramtype name: ~azure.mgmt.testbase.models.TestBaseAccountUsageName
        :keyword unit: Representing the units of the usage quota. Possible values are: Count, Bytes,
         Seconds, Percent, CountPerSecond, BytesPerSecond.
        :paramtype unit: str
        :keyword limit: The maximum permitted value for the usage quota. If there is no limit, this
         value will be -1.
        :paramtype limit: int
        :keyword current_value: Current value for the usage quota.
        :paramtype current_value: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.unit = unit
        self.limit = limit
        self.current_value = current_value


class TestBaseAccountUsageDataList(_serialization.Model):
    """A list of Test Base Account usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Base Account usage data.
    :vartype value: list[~azure.mgmt.testbase.models.TestBaseAccountUsageData]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestBaseAccountUsageData]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TestBaseAccountUsageData"]] = None, **kwargs):
        """
        :keyword value: The list of Test Base Account usage data.
        :paramtype value: list[~azure.mgmt.testbase.models.TestBaseAccountUsageData]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestBaseAccountUsageName(_serialization.Model):
    """Localizable String object containing the name and a localized value.

    :ivar value: The identifier of the usage.
    :vartype value: str
    :ivar localized_value: Localized name of the usage.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs):
        """
        :keyword value: The identifier of the usage.
        :paramtype value: str
        :keyword localized_value: Localized name of the usage.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class TestResultAnalysisSummary(_serialization.Model):
    """The summary of a Test Analysis Result.

    :ivar name: Metric name.
    :vartype name: str
    :ivar analysis_status: The analysis status. Known values are: "None", "Completed",
     "InProgress", "Failed", "Succeeded", "Available", and "NotAvailable".
    :vartype analysis_status: str or ~azure.mgmt.testbase.models.AnalysisStatus
    :ivar grade: The grade of the test result. Known values are: "None", "NotAvailable", "Pass",
     and "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "analysis_status": {"key": "analysisStatus", "type": "str"},
        "grade": {"key": "grade", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        analysis_status: Optional[Union[str, "_models.AnalysisStatus"]] = None,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        **kwargs
    ):
        """
        :keyword name: Metric name.
        :paramtype name: str
        :keyword analysis_status: The analysis status. Known values are: "None", "Completed",
         "InProgress", "Failed", "Succeeded", "Available", and "NotAvailable".
        :paramtype analysis_status: str or ~azure.mgmt.testbase.models.AnalysisStatus
        :keyword grade: The grade of the test result. Known values are: "None", "NotAvailable", "Pass",
         and "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        """
        super().__init__(**kwargs)
        self.name = name
        self.analysis_status = analysis_status
        self.grade = grade


class TestResultConsoleLogDownloadURLParameters(_serialization.Model):
    """Parameters body to pass for getting the download URL of the test execution console log file.

    All required parameters must be populated in order to send to Azure.

    :ivar log_file_name: The log file name corresponding to the download URL. Required.
    :vartype log_file_name: str
    """

    _validation = {
        "log_file_name": {"required": True},
    }

    _attribute_map = {
        "log_file_name": {"key": "logFileName", "type": "str"},
    }

    def __init__(self, *, log_file_name: str, **kwargs):
        """
        :keyword log_file_name: The log file name corresponding to the download URL. Required.
        :paramtype log_file_name: str
        """
        super().__init__(**kwargs)
        self.log_file_name = log_file_name


class TestResultListResult(_serialization.Model):
    """A list of Test Results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Results.
    :vartype value: list[~azure.mgmt.testbase.models.TestResultResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestResultResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TestResultResource"]] = None, **kwargs):
        """
        :keyword value: The list of Test Results.
        :paramtype value: list[~azure.mgmt.testbase.models.TestResultResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestResultResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Test Result Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar baseline_test_result_id: Azure Id of the baseline test result.
    :vartype baseline_test_result_id: str
    :ivar package_id: Resource Id of the package.
    :vartype package_id: str
    :ivar application_name: Application name.
    :vartype application_name: str
    :ivar application_version: Application version.
    :vartype application_version: str
    :ivar os_name: The operating system name, e.g. Windows 10 1809.
    :vartype os_name: str
    :ivar release_name: The name of the tested release (OS update).
    :vartype release_name: str
    :ivar release_version_date: The release version date of the tested release.
    :vartype release_version_date: ~datetime.datetime
    :ivar flighting_ring: The flighting ring, only for release of feature updates.
    :vartype flighting_ring: str
    :ivar build_version: The build version of the tested release (OS update).
    :vartype build_version: str
    :ivar build_revision: The build revision of the tested release (OS update).
    :vartype build_revision: str
    :ivar test_type: Test type. E.g. 'Out of box test' or 'Functional test'.
    :vartype test_type: str
    :ivar test_run_time: The run time of the test.
    :vartype test_run_time: str
    :ivar is_download_data_available: Whether download data is available.
    :vartype is_download_data_available: bool
    :ivar is_video_available: Whether video data is available.
    :vartype is_video_available: bool
    :ivar execution_status: The execution status of the test. Known values are: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and
     "Succeeded".
    :vartype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
    :ivar test_status: The status of the test. Known values are: "None", "TestExecutionInProgress",
     "DataProcessing", "TestFailure", "UpdateFailure", "TestAndUpdateFailure",
     "InfrastructureFailure", and "Completed".
    :vartype test_status: str or ~azure.mgmt.testbase.models.TestStatus
    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar kb_number: KB number.
    :vartype kb_number: str
    :ivar interop_media_type: Interop media type.
    :vartype interop_media_type: str
    :ivar interop_media_version: Interop media version.
    :vartype interop_media_version: str
    :ivar package_version: The version of the Windows update package.
    :vartype package_version: str
    :ivar analysis_summaries: List of analysis summaries.
    :vartype analysis_summaries: list[~azure.mgmt.testbase.models.TestResultAnalysisSummary]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "baseline_test_result_id": {"key": "properties.baselineTestResultId", "type": "str"},
        "package_id": {"key": "properties.packageId", "type": "str"},
        "application_name": {"key": "properties.applicationName", "type": "str"},
        "application_version": {"key": "properties.applicationVersion", "type": "str"},
        "os_name": {"key": "properties.osName", "type": "str"},
        "release_name": {"key": "properties.releaseName", "type": "str"},
        "release_version_date": {"key": "properties.releaseVersionDate", "type": "iso-8601"},
        "flighting_ring": {"key": "properties.flightingRing", "type": "str"},
        "build_version": {"key": "properties.buildVersion", "type": "str"},
        "build_revision": {"key": "properties.buildRevision", "type": "str"},
        "test_type": {"key": "properties.testType", "type": "str"},
        "test_run_time": {"key": "properties.testRunTime", "type": "str"},
        "is_download_data_available": {"key": "properties.isDownloadDataAvailable", "type": "bool"},
        "is_video_available": {"key": "properties.isVideoAvailable", "type": "bool"},
        "execution_status": {"key": "properties.executionStatus", "type": "str"},
        "test_status": {"key": "properties.testStatus", "type": "str"},
        "grade": {"key": "properties.grade", "type": "str"},
        "kb_number": {"key": "properties.kbNumber", "type": "str"},
        "interop_media_type": {"key": "properties.interopMediaType", "type": "str"},
        "interop_media_version": {"key": "properties.interopMediaVersion", "type": "str"},
        "package_version": {"key": "properties.packageVersion", "type": "str"},
        "analysis_summaries": {"key": "properties.analysisSummaries", "type": "[TestResultAnalysisSummary]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        baseline_test_result_id: Optional[str] = None,
        package_id: Optional[str] = None,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        os_name: Optional[str] = None,
        release_name: Optional[str] = None,
        release_version_date: Optional[datetime.datetime] = None,
        flighting_ring: Optional[str] = None,
        build_version: Optional[str] = None,
        build_revision: Optional[str] = None,
        test_type: Optional[str] = None,
        test_run_time: Optional[str] = None,
        is_download_data_available: Optional[bool] = None,
        is_video_available: Optional[bool] = None,
        execution_status: Optional[Union[str, "_models.ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "_models.TestStatus"]] = None,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        kb_number: Optional[str] = None,
        interop_media_type: Optional[str] = None,
        interop_media_version: Optional[str] = None,
        package_version: Optional[str] = None,
        analysis_summaries: Optional[List["_models.TestResultAnalysisSummary"]] = None,
        **kwargs
    ):
        """
        :keyword baseline_test_result_id: Azure Id of the baseline test result.
        :paramtype baseline_test_result_id: str
        :keyword package_id: Resource Id of the package.
        :paramtype package_id: str
        :keyword application_name: Application name.
        :paramtype application_name: str
        :keyword application_version: Application version.
        :paramtype application_version: str
        :keyword os_name: The operating system name, e.g. Windows 10 1809.
        :paramtype os_name: str
        :keyword release_name: The name of the tested release (OS update).
        :paramtype release_name: str
        :keyword release_version_date: The release version date of the tested release.
        :paramtype release_version_date: ~datetime.datetime
        :keyword flighting_ring: The flighting ring, only for release of feature updates.
        :paramtype flighting_ring: str
        :keyword build_version: The build version of the tested release (OS update).
        :paramtype build_version: str
        :keyword build_revision: The build revision of the tested release (OS update).
        :paramtype build_revision: str
        :keyword test_type: Test type. E.g. 'Out of box test' or 'Functional test'.
        :paramtype test_type: str
        :keyword test_run_time: The run time of the test.
        :paramtype test_run_time: str
        :keyword is_download_data_available: Whether download data is available.
        :paramtype is_download_data_available: bool
        :keyword is_video_available: Whether video data is available.
        :paramtype is_video_available: bool
        :keyword execution_status: The execution status of the test. Known values are: "None",
         "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and
         "Succeeded".
        :paramtype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
        :keyword test_status: The status of the test. Known values are: "None",
         "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
         "TestAndUpdateFailure", "InfrastructureFailure", and "Completed".
        :paramtype test_status: str or ~azure.mgmt.testbase.models.TestStatus
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword kb_number: KB number.
        :paramtype kb_number: str
        :keyword interop_media_type: Interop media type.
        :paramtype interop_media_type: str
        :keyword interop_media_version: Interop media version.
        :paramtype interop_media_version: str
        :keyword package_version: The version of the Windows update package.
        :paramtype package_version: str
        :keyword analysis_summaries: List of analysis summaries.
        :paramtype analysis_summaries: list[~azure.mgmt.testbase.models.TestResultAnalysisSummary]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.baseline_test_result_id = baseline_test_result_id
        self.package_id = package_id
        self.application_name = application_name
        self.application_version = application_version
        self.os_name = os_name
        self.release_name = release_name
        self.release_version_date = release_version_date
        self.flighting_ring = flighting_ring
        self.build_version = build_version
        self.build_revision = build_revision
        self.test_type = test_type
        self.test_run_time = test_run_time
        self.is_download_data_available = is_download_data_available
        self.is_video_available = is_video_available
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.kb_number = kb_number
        self.interop_media_type = interop_media_type
        self.interop_media_version = interop_media_version
        self.package_version = package_version
        self.analysis_summaries = analysis_summaries


class TestSummaryListResult(_serialization.Model):
    """A list of Test Summaries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Test Summaries.
    :vartype value: list[~azure.mgmt.testbase.models.TestSummaryResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestSummaryResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TestSummaryResource"]] = None, **kwargs):
        """
        :keyword value: The list of Test Summaries.
        :paramtype value: list[~azure.mgmt.testbase.models.TestSummaryResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestSummaryResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Summary of a Test.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar test_summary_id: The Id of the current Test Summary.
    :vartype test_summary_id: str
    :ivar package_id: The Azure resource Id of package.
    :vartype package_id: str
    :ivar application_name: Application name.
    :vartype application_name: str
    :ivar application_version: Application version.
    :vartype application_version: str
    :ivar execution_status: The execution status of last test. Known values are: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and
     "Succeeded".
    :vartype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
    :ivar test_status: The status of last test. Known values are: "None",
     "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
     "TestAndUpdateFailure", "InfrastructureFailure", and "Completed".
    :vartype test_status: str or ~azure.mgmt.testbase.models.TestStatus
    :ivar grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
     "Fail".
    :vartype grade: str or ~azure.mgmt.testbase.models.Grade
    :ivar test_run_time: The run time of the last test.
    :vartype test_run_time: str
    :ivar feature_updates_test_summary: The result summary of tests triggered by feature updates.
    :vartype feature_updates_test_summary: ~azure.mgmt.testbase.models.OSUpdatesTestSummary
    :ivar security_updates_test_summary: The result summary of tests triggered by security updates.
    :vartype security_updates_test_summary: ~azure.mgmt.testbase.models.OSUpdatesTestSummary
    :ivar package_tags: The tags of Package resource that are associated with the testSummary.
    :vartype package_tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "test_summary_id": {"key": "properties.testSummaryId", "type": "str"},
        "package_id": {"key": "properties.packageId", "type": "str"},
        "application_name": {"key": "properties.applicationName", "type": "str"},
        "application_version": {"key": "properties.applicationVersion", "type": "str"},
        "execution_status": {"key": "properties.executionStatus", "type": "str"},
        "test_status": {"key": "properties.testStatus", "type": "str"},
        "grade": {"key": "properties.grade", "type": "str"},
        "test_run_time": {"key": "properties.testRunTime", "type": "str"},
        "feature_updates_test_summary": {"key": "properties.featureUpdatesTestSummary", "type": "OSUpdatesTestSummary"},
        "security_updates_test_summary": {
            "key": "properties.securityUpdatesTestSummary",
            "type": "OSUpdatesTestSummary",
        },
        "package_tags": {"key": "properties.packageTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        test_summary_id: Optional[str] = None,
        package_id: Optional[str] = None,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        execution_status: Optional[Union[str, "_models.ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "_models.TestStatus"]] = None,
        grade: Optional[Union[str, "_models.Grade"]] = None,
        test_run_time: Optional[str] = None,
        feature_updates_test_summary: Optional["_models.OSUpdatesTestSummary"] = None,
        security_updates_test_summary: Optional["_models.OSUpdatesTestSummary"] = None,
        package_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword test_summary_id: The Id of the current Test Summary.
        :paramtype test_summary_id: str
        :keyword package_id: The Azure resource Id of package.
        :paramtype package_id: str
        :keyword application_name: Application name.
        :paramtype application_name: str
        :keyword application_version: Application version.
        :paramtype application_version: str
        :keyword execution_status: The execution status of last test. Known values are: "None",
         "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", and
         "Succeeded".
        :paramtype execution_status: str or ~azure.mgmt.testbase.models.ExecutionStatus
        :keyword test_status: The status of last test. Known values are: "None",
         "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
         "TestAndUpdateFailure", "InfrastructureFailure", and "Completed".
        :paramtype test_status: str or ~azure.mgmt.testbase.models.TestStatus
        :keyword grade: The grade of the test. Known values are: "None", "NotAvailable", "Pass", and
         "Fail".
        :paramtype grade: str or ~azure.mgmt.testbase.models.Grade
        :keyword test_run_time: The run time of the last test.
        :paramtype test_run_time: str
        :keyword feature_updates_test_summary: The result summary of tests triggered by feature
         updates.
        :paramtype feature_updates_test_summary: ~azure.mgmt.testbase.models.OSUpdatesTestSummary
        :keyword security_updates_test_summary: The result summary of tests triggered by security
         updates.
        :paramtype security_updates_test_summary: ~azure.mgmt.testbase.models.OSUpdatesTestSummary
        :keyword package_tags: The tags of Package resource that are associated with the testSummary.
        :paramtype package_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.test_summary_id = test_summary_id
        self.package_id = package_id
        self.application_name = application_name
        self.application_version = application_version
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.test_run_time = test_run_time
        self.feature_updates_test_summary = feature_updates_test_summary
        self.security_updates_test_summary = security_updates_test_summary
        self.package_tags = package_tags


class TestTypeListResult(_serialization.Model):
    """A list of test types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of test types.
    :vartype value: list[~azure.mgmt.testbase.models.TestTypeResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestTypeResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TestTypeResource"]] = None, **kwargs):
        """
        :keyword value: The list of test types.
        :paramtype value: list[~azure.mgmt.testbase.models.TestTypeResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestTypeResource(ProxyResource):
    """The test type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.testbase.models.SystemData
    :ivar actual_test_type_name: The actual name of a test type of a Test Base Account.
    :vartype actual_test_type_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "actual_test_type_name": {"key": "properties.actualTestTypeName", "type": "str"},
    }

    def __init__(self, *, actual_test_type_name: Optional[str] = None, **kwargs):
        """
        :keyword actual_test_type_name: The actual name of a test type of a Test Base Account.
        :paramtype actual_test_type_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.actual_test_type_name = actual_test_type_name


class UserObjectReceiverValue(_serialization.Model):
    """The user object receiver value.

    :ivar user_object_ids: user object ids.
    :vartype user_object_ids: list[str]
    """

    _attribute_map = {
        "user_object_ids": {"key": "userObjectIds", "type": "[str]"},
    }

    def __init__(self, *, user_object_ids: Optional[List[str]] = None, **kwargs):
        """
        :keyword user_object_ids: user object ids.
        :paramtype user_object_ids: list[str]
        """
        super().__init__(**kwargs)
        self.user_object_ids = user_object_ids


class UtilizationBound(_serialization.Model):
    """The bound of a utilization result.

    :ivar percentile: The percentile of the bound.
    :vartype percentile: float
    :ivar value: The value of the bound.
    :vartype value: float
    """

    _attribute_map = {
        "percentile": {"key": "percentile", "type": "float"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, percentile: Optional[float] = None, value: Optional[float] = None, **kwargs):
        """
        :keyword percentile: The percentile of the bound.
        :paramtype percentile: float
        :keyword value: The value of the bound.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.percentile = percentile
        self.value = value


class UtilizationEntry(_serialization.Model):
    """The utilization entry.

    :ivar timestamp: The timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar value: The value.
    :vartype value: float
    """

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, timestamp: Optional[datetime.datetime] = None, value: Optional[float] = None, **kwargs):
        """
        :keyword timestamp: The timestamp.
        :paramtype timestamp: ~datetime.datetime
        :keyword value: The value.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp
        self.value = value


class UtilizationResult(_serialization.Model):
    """The Utilization Result.

    :ivar process: Process name, or '_total' for all processes.
    :vartype process: str
    :ivar upper_bound: Upper bound.
    :vartype upper_bound: ~azure.mgmt.testbase.models.UtilizationBound
    :ivar lower_bound: Lower bound.
    :vartype lower_bound: ~azure.mgmt.testbase.models.UtilizationBound
    :ivar utilization: Utilization data.
    :vartype utilization: list[~azure.mgmt.testbase.models.UtilizationEntry]
    """

    _attribute_map = {
        "process": {"key": "process", "type": "str"},
        "upper_bound": {"key": "upperBound", "type": "UtilizationBound"},
        "lower_bound": {"key": "lowerBound", "type": "UtilizationBound"},
        "utilization": {"key": "utilization", "type": "[UtilizationEntry]"},
    }

    def __init__(
        self,
        *,
        process: Optional[str] = None,
        upper_bound: Optional["_models.UtilizationBound"] = None,
        lower_bound: Optional["_models.UtilizationBound"] = None,
        utilization: Optional[List["_models.UtilizationEntry"]] = None,
        **kwargs
    ):
        """
        :keyword process: Process name, or '_total' for all processes.
        :paramtype process: str
        :keyword upper_bound: Upper bound.
        :paramtype upper_bound: ~azure.mgmt.testbase.models.UtilizationBound
        :keyword lower_bound: Lower bound.
        :paramtype lower_bound: ~azure.mgmt.testbase.models.UtilizationBound
        :keyword utilization: Utilization data.
        :paramtype utilization: list[~azure.mgmt.testbase.models.UtilizationEntry]
        """
        super().__init__(**kwargs)
        self.process = process
        self.upper_bound = upper_bound
        self.lower_bound = lower_bound
        self.utilization = utilization
