/* $PostgresPy: if/src/module.c,v 1.20 2004/07/27 16:11:47 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    The PostGres Interface Module [implementation]
 */
#include <setjmp.h>
#include <pputils.h>

#include <postgres.h>
#include <funcapi.h>
#include <miscadmin.h>
#include <access/htup.h>
#include <access/hio.h>
#include <access/xact.h>
#include <catalog/catname.h>
#include <catalog/catversion.h>
#include <commands/trigger.h>
#include <libpq/libpq.h>
#include <libpq/pqformat.h>
#include <tcop/tcopprot.h>
#include <utils/array.h>
#include <utils/elog.h>
#include <utils/syscache.h>
#include <utils/memutils.h>
#include <pg.h>
#include <PGExcept.h>

#include <Python.h>
#include <structmember.h>
#include <py.h>

#include "void.h"
#include "pstream.h"

#include "datum.h"
#include "tupd.h"
#include "tup.h"
#include "type.h"
#include "obj.h"
#include "rel.h"
#include "query.h"
#include "portal.h"
#include "utils.h"
#include "module.h"

/*
 * pypg_elog - Python interface to elog
 */
static PyObj
pypg_elog(PyObj self, PyObj args)
{
	EXC_DECLARE();
	unsigned int level = WARNING;
	char *msg = NULL;

	if (!PyArg_ParseTuple(args, "Is", &level, &msg))
		return(NULL);

	EXCEPT
	(
		PyErr_Format(PyExc_PgErr, "elog");
		return(Py_None);
	);

	elog(level, "%s", msg);

	INCREF(Py_None);
	RETURN(Py_None);
}
char pypg_elog_doc[] =
"elog takes two arguments: the log level, and the message";

/*
 * pypg_ereport - Python interface to ereport
 */
static PyObj
pypg_ereport(PyObj self, PyObj args, PyObj kw)
{
	unsigned int level = WARNING;
	int code = 0;
	char *msg = NULL;
	char *hint = NULL;
	char *detail = NULL;
	char *context = NULL;

	static char *kwlist[] = {
		"level", "msg",
		"hint", "detail",
		"context", "code",
	NULL };

	if (!PyArg_ParseTupleAndKeywords(args, kw, "is|sssi", kwlist,
			&level, &msg, &hint, &detail, &context, &code ))
		return(NULL);

	/* XXX: specify location relative to caller */
	errstart(level, __FILE__, __LINE__, __func__);
	errmsg("%s", msg);
	errcode(code);
	if (hint) errhint("%s", hint);
	if (detail) errdetail("%s", detail);
	if (context) errcontext("%s", context);
	PgErr_TRAP( errfinish(0); );

	if (PyErr_Occurred())
		return(NULL);
	else
		RETURN_NONE;
}
char pypg_ereport_doc[] =
"ereport(level, message, code=int(error code), hint=\"resolution hint\", detail=\"error detail\", context=\"error context\")";

PyObj
pypg_WARNING(PyObj self, PyObj args, PyObj kw)
{
	int code = 0;
	char *msg = NULL;
	char *hint = NULL;
	char *detail = NULL;
	char *context = NULL;

	static char *kwlist[] = {
		"msg", "hint", "detail",
		"context", "code", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kw, "s|sssi", kwlist,
			&msg, &hint, &detail, &context, &code))
		return(NULL);

	/* XXX: specify location relative to caller */
	errstart(WARNING, __FILE__, __LINE__, __func__);
	errmsg("%s", msg);
	errcode(code);
	if (hint) errhint("%s", hint);
	if (detail) errdetail("%s", detail);
	if (context) errcontext("%s", context);
	errfinish(0);

	RETURN_NONE;
}
char pypg_WARNING_doc[] =
"Warning level ereport";

PyObj
pypg_NOTICE(PyObj self, PyObj args, PyObj kw)
{
	int code = 0;
	char *msg = NULL;
	char *hint = NULL;
	char *detail = NULL;
	char *context = NULL;

	static char *kwlist[] = {
		"msg", "hint", "detail",
		"context", "code", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kw, "s|sssi", kwlist,
			&msg, &hint, &detail, &context, &code))
		return(NULL);

	/* XXX: specify location relative to caller */
	errstart(NOTICE, __FILE__, __LINE__, __func__);
	errmsg("%s", msg);
	errcode(code);
	if (hint) errhint("%s", hint);
	if (detail) errdetail("%s", detail);
	if (context) errcontext("%s", context);
	errfinish(0);

	RETURN_NONE;
}
char pypg_NOTICE_doc[] =
"NOTICE level ereport";

PyObj
pypg_INFO(PyObj self, PyObj args, PyObj kw)
{
	int code = 0;
	char *msg = NULL;
	char *hint = NULL;
	char *detail = NULL;
	char *context = NULL;

	static char *kwlist[] = {
		"msg", "hint", "detail",
		"context", "code", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kw, "s|sssi", kwlist,
			&msg, &hint, &detail, &context, &code))
		return(NULL);

	/* XXX: specify location relative to caller */
	errstart(INFO, __FILE__, __LINE__, __func__);
	errmsg("%s", msg);
	errcode(code);
	if (hint) errhint("%s", hint);
	if (detail) errdetail("%s", detail);
	if (context) errcontext("%s", context);
	errfinish(0);

	RETURN_NONE;
}
char pypg_INFO_doc[] =
"INFO level ereport";

PyObj
pypg_LOG(PyObj self, PyObj args, PyObj kw)
{
	int code = 0;
	char *msg = NULL;
	char *hint = NULL;
	char *detail = NULL;
	char *context = NULL;

	static char *kwlist[] = {
		"msg", "hint", "detail",
		"context", "code", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kw, "s|sssi", kwlist,
			&msg, &hint, &detail, &context, &code))
		return(NULL);

	/* XXX: specify location relative to caller */
	errstart(LOG, __FILE__, __LINE__, __func__);
	errmsg("%s", msg);
	errcode(code);
	if (hint) errhint("%s", hint);
	if (detail) errdetail("%s", detail);
	if (context) errcontext("%s", context);
	errfinish(0);

	RETURN_NONE;
}
char pypg_LOG_doc[] =
"LOG level ereport";


PyObj
pypg_DEBUG(PyObj self, PyObj args, PyObj kw)
{
	int code = 0;
	char *msg = NULL;
	char *hint = NULL;
	char *detail = NULL;
	char *context = NULL;

	static char *kwlist[] = {
		"msg", "hint", "detail",
		"context", "code", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kw, "s|sssi", kwlist,
			&msg, &hint, &detail, &context, &code))
		return(NULL);

	/* XXX: specify location relative to caller */
	errstart(DEBUG1, __FILE__, __LINE__, __func__);
	errmsg("%s", msg);
	errcode(code);
	if (hint) errhint("%s", hint);
	if (detail) errdetail("%s", detail);
	if (context) errcontext("%s", context);
	errfinish(0);

	RETURN_NONE;
}
char pypg_DEBUG_doc[] =
"DEBUG level ereport";

/*
 * pypg_query - execute a simple query returning any useful information
 */
static PyObj
pypg_query(PyObj self, PyObj args)
{
	PyObj qstr = NULL, rob = NULL;
	PyObj query = NULL;

	if(!PyArg_ParseTuple(args, "O", &qstr))
		return(NULL);
	
	query = PyPgQuery_New(qstr, NULL);
	DECREF(qstr);

	rob = PyObject_Call(query, NULL, NULL);
	DECREF(query);
	
	return(rob);
}
static char pypg_query_doc[] = "Run an SQL query directly on the server";

/*
 * pypg_xid - get the current transaction id
 */
static PyObj
pypg_xid(void)
{
	PyObj rob;
	rob = PYULLONG((unsigned long long)GetCurrentTransactionId());
	return(rob);
}
static char pypg_xid_doc[] = "Get the current transaction identifier";


#ifdef SUBTRANSACTIONS
PyObj
pypg_ABORT(PyObj quantity)
{
	AbortCurrentSubTransaction();
}
static char pypg_ABORT_doc[] = "";

PyObj
pypg_COMMIT(PyObj quantity)
{
	CommitSubTransactionCommand();
}
static char pypg_COMMIT_doc[] = "";

PyObj
pypg_BEGIN(void)
{
	StartSubTransactionCommand();
}
static char pypg_BEGIN_doc[] = "";
#endif


static PyMethodDef PyPgModule_Methods[] = {
	{"elog", (PyCFunction)pypg_elog, METH_VARARGS, pypg_elog_doc},
	{"ereport", (PyCFunction)pypg_ereport,
		METH_VARARGS|METH_KEYWORDS, pypg_ereport_doc},
	{"WARNING", (PyCFunction)pypg_WARNING,
		METH_VARARGS|METH_KEYWORDS, pypg_WARNING_doc},
	{"NOTICE", (PyCFunction)pypg_NOTICE,
		METH_VARARGS|METH_KEYWORDS, pypg_NOTICE_doc},
	{"INFO", (PyCFunction)pypg_INFO,
		METH_VARARGS|METH_KEYWORDS, pypg_INFO_doc},
	{"LOG", (PyCFunction)pypg_LOG,
		METH_VARARGS|METH_KEYWORDS, pypg_LOG_doc},
	{"DEBUG", (PyCFunction)pypg_DEBUG,
		METH_VARARGS|METH_KEYWORDS, pypg_DEBUG_doc},

	{"SQL", (PyCFunction)pypg_query, METH_VARARGS, pypg_query_doc},
	{"Xid", (PyCFunction)pypg_xid, METH_NOARGS, pypg_xid_doc},

#ifdef SUBTRANSACTIONS
	{"ABORT", (PyCFunction)pypg_ABORT, METH_O, pypg_ABORT_doc},
	{"COMMIT", (PyCFunction)pypg_COMMIT, METH_O, pypg_COMMIT_doc},
	{"BEGIN", (PyCFunction)pypg_BEGIN, METH_NOARGS, pypg_BEGIN_doc},
#endif
	{NULL}
};

static void
EOXact(bool isCommit, void *arg)
{
	if (!InError)
	{
		/* XXX: execute transaction hooks */
	}

	/* Clear AFTER transaction hooks */
	PyDict_Clear(PyPgXactDict);
}

static int
pgerr_writer(const char *buf, int len)
{
	if (!ClientAuthInProgress
		&& Warn_restart_ready
		&& whereToSendOutput == Remote)
	{
		StringInfoData msgbuf;
		char *str;
		str = malloc(len + 1);
		memcpy(str, buf, len);
		str[len] = '\0';

		pq_beginmessage(&msgbuf, 'N');
		if (PG_PROTOCOL_MAJOR(FrontendProtocol) >= 3)
		{
			pq_sendbyte(&msgbuf, PG_DIAG_MESSAGE_PRIMARY);
			pq_sendstring(&msgbuf, str);
			pq_sendbyte(&msgbuf, '\0');
		}
		else
			pq_sendstring(&msgbuf, str);
		free(str);

		pq_endmessage(&msgbuf);
		pq_flush();
	}
	else if (whereToSendOutput == Debug)
	{
		write(2, buf, len);
		fflush(stderr);
	}

	return(0);
}

/* This macro makes a proper module init function name based on PGV_MM */
#define MI_FUNC(V) CATLIT(init_pg,V)
#define MODINIT MI_FUNC(PGV_MM)

char PyPgModule_Doc[] = "Postgres Interface Module";
extern PyMODINIT_FUNC
MODINIT(void)
{
	PyObj mod;
	PyObj ob;
	
	mod = Py_InitModule3("_pg"XSTR(PGV_MM), PyPgModule_Methods, PyPgModule_Doc);
	if (mod == NULL)
		return;

	PyExc_PgErr = PyErr_NewException
		("Postgres.Error", PyExc_Exception, NULL);
	if (PyExc_PgErr == NULL)
	{
		DECREF(mod);
		return;
	}
	PyModule_AddObject(mod, "Error", PyExc_PgErr);

	PyPgXactDict = PyDict_New();
	PyModule_AddObject(mod, "XD", PyPgXactDict);
	
	ob = PyDict_New();
#	define TARGET ob
#	define APFUNC PyMapping_SetItemString
#		include "constants.c"
#	undef APFUNC
#	undef TARGET
	PyModule_AddObject(mod, "Const", ob);
	ob = NULL;
	
	if ((PyType_Ready(&PyVoid_Type) < 0)
		|| (PyType_Ready(&PyPStream_Type) < 0)
		|| (PyType_Ready(&PyPgDatum_Type) < 0)
		|| (PyType_Ready(&PyPgTupleDesc_Type) < 0)
		|| (PyType_Ready(&PyPgTuple_Type) < 0)
		|| (PyType_Ready(&PyPgType_Type) < 0)
		|| (PyType_Ready(&PyPgObject_Type) < 0)
		|| (PyType_Ready(&PyPgRelation_Type) < 0)
		|| (PyType_Ready(&PyPgQuery_Type) < 0)
		|| (PyType_Ready(&PyPgPortal_Type) < 0))
		return;

	PyModule_AddObject(mod, "Datum",			(PyObj)&PyPgDatum_Type);
	PyModule_AddObject(mod, "TupleDesc",	(PyObj)&PyPgTupleDesc_Type);
	PyModule_AddObject(mod, "Tuple",			(PyObj)&PyPgTuple_Type);
	PyModule_AddObject(mod, "Type",			(PyObj)&PyPgType_Type);
	PyModule_AddObject(mod, "Object",		(PyObj)&PyPgObject_Type);
	PyModule_AddObject(mod, "Relation",		(PyObj)&PyPgRelation_Type);
	PyModule_AddObject(mod, "Query",			(PyObj)&PyPgQuery_Type);
	PyModule_AddObject(mod, "Portal",		(PyObj)&PyPgPortal_Type);

	PythonMemoryContext = TopMemoryContext;
	
	PyPgTypeTDO = (PyObj)PyPgTupleDesc_New(SysTupleDesc(type));
	PyModule_AddObject(mod, "TypeTDO", PyPgTypeTDO);
	
	PyPgAttrTDO = (PyObj)PyPgTupleDesc_New(SysTupleDesc(attribute));
	PyModule_AddObject(mod, "AttrTDO", PyPgAttrTDO);

	PyPgDEFAULT = PyVoid_New();
	PyModule_AddObject(mod, "DEFAULT", PyPgDEFAULT);

	PyModule_AddObject(mod, "pgerr", PyPStream_New((ps_writer)pgerr_writer));

	RegisterEOXactCallback(EOXact, NULL);
}
