/* $PostgresPy: if/src/portal.c,v 1.6 2004/07/28 11:27:44 flaw Exp $
 *
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 *//*
 * Postgres' Portal Interface [For Python]
 *
 * This implements a Python interface for the Postgres Portal
 */
#include <pputils.h>

#include <postgres.h>
#include <access/heapam.h>
#include <catalog/pg_type.h>
#include <executor/executor.h>
#include <executor/execdesc.h>
#include <executor/tstoreReceiver.h>
#include <nodes/pg_list.h>
#include <nodes/params.h>
#include <tcop/dest.h>
#include <tcop/tcopprot.h>
#include <tcop/pquery.h>
#include <tcop/utility.h>
#include <utils/array.h>
#include <utils/palloc.h>
#include <utils/relcache.h>
#include <utils/tuplestore.h>
#include <utils/portal.h>
#include <pg.h>
#include <PGExcept.h>

#include <Python.h>
#include <structmember.h>
#include <py.h>

#include "datum.h"
#include "tupd.h"
#include "tup.h"
#include "obj.h"
#include "module.h"
#include "utils.h"

#include "query.h"
#include "portal.h"

static const CommandDest PgPortalDest = 0xFEF1;

static void
port_rreceive(HeapTuple tup, TupleDesc td, struct PgPortalReceiver *pr)
{
	MemoryContext oldcxt;
	oldcxt = MemoryContextSwitchTo(PythonMemoryContext);
	pr->self->tup = PyPgTuple_New(heap_copytuple(tup), pr->self->tdo);
	MemoryContextSwitchTo(oldcxt);
}

static void
port_rstartup(struct PgPortalReceiver *pr, int op, TupleDesc td) { }

static void
port_rshutdown(struct PgPortalReceiver *pr) { }

static void
port_rdestroy(struct PgPortalReceiver *pr) { }

static PyObj
port_iternext(PgPortal self)
{
	if (!PortalRun(self->portal, 1, (DestReceiver *)&(self->dest), NULL, NULL))
		return(self->tup);

	return(NULL);
}

static void
port_dealloc(PgPortal self)
{
	PortalDrop(self->portal, false);
	self->portal = NULL;

	DECREF(self->query);
	self->query = NULL;

	DECREF(self->tdo);
	self->tdo = NULL;

	PyObject_Del((PyObj)self);
}

static PyObj
port_getiter(PyObj self)
{
	INCREF(self);
	return(self);
}

static char PyPgPortal_Doc[] = "Postgres Portal";
PyTypeObject PyPgPortal_Type = {
	PyObject_HEAD_INIT(NULL)
	0,										/* ob_size */
	"Postgres.Portal",				/* tp_name */
	sizeof(struct PyPgPortal),		/* tp_basicsize */
	0,										/* tp_itemsize */
	(destructor)port_dealloc,		/* tp_dealloc */
	NULL,									/* tp_print */
	(getattrfunc)NULL,				/* tp_getattr */
	(setattrfunc)NULL,				/* tp_setattr */
	(cmpfunc)NULL,						/* tp_compare */
	(reprfunc)NULL,					/* tp_repr */
	NULL,									/* tp_as_number */
	NULL,									/* tp_as_sequence */
	NULL,									/* tp_as_mapping */
	(hashfunc)NULL,					/* tp_hash */
	(ternaryfunc)NULL,				/* tp_call */
	(reprfunc)NULL,					/* tp_str */
	NULL,									/* tp_getattro */
	NULL,									/* tp_setattro */
	NULL,									/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			   /* tp_flags */
	(char*)PyPgPortal_Doc,			/* tp_doc */
	(traverseproc)NULL,				/* tp_traverse */
	(inquiry)NULL,						/* tp_clear */
	(richcmpfunc)NULL,				/* tp_richcompare */
	(long)0,								/* tp_weaklistoffset */
	(getiterfunc)port_getiter,		/* tp_iter */
	(iternextfunc)port_iternext,	/* tp_iternext */
	NULL,									/* tp_methods */
	NULL,									/* tp_members */
	NULL,									/* tp_getset */
	NULL,									/* tp_base */
	NULL,									/* tp_dict */
	NULL,									/* tp_descr_get */
	NULL,									/* tp_descr_set */
	NULL,									/* tp_dictoffset */
	(initproc)NULL,					/* tp_init */
	NULL,									/* tp_alloc */
	PyType_GenericNew,				/* tp_new */
};

/*
 * PgPortal_New
 * 	Create a portal object based on a query, plan, and parameters.
 */
PgPortal
PgPortal_New(PgQuery pgq, Query *query, Plan *plan, ParamListInfo pli)
{
	Portal p;
	PgPortal self;

	p = CreateNewPortal();
	PortalDefineQuery(p,
			PYASSTR(pgq->str),
			"SELECT",
			list_make1(query),
			list_make1(plan),
			CurrentMemoryContext);

	p->cursorOptions |= CURSOR_OPT_SCROLL;

	PortalStart(p, pli);

	self = PgPortal_NEW();
	self->query = (PyObj)pgq;
	INCREF((PyObj)pgq);

	self->portal = p;

	self->dest.receive = (DRReceive)port_rreceive;
	self->dest.startup = (DRStartup)port_rstartup;
	self->dest.shutdown = (DRShutdown)port_rshutdown;
	self->dest.destroy = (DRDestroy)port_rdestroy;
	self->dest.dest = PgPortalDest;
	self->dest.self = self;

	self->tup = NULL;
	self->tdo = PyPgTupleDesc_New(CreateTupleDescCopy(p->tupDesc));

	return(self);
}
