/* $PostgresPy: if/src/type.h,v 1.4 2004/07/27 16:13:46 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Header for type.c
 */
#ifndef PyPg_TYPE_H
#define PyPg_TYPE_H "type.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgType {
	PyObject_HEAD
	PyObj ob_tuple;
} *PgType;

extern PyTypeObject PyPgType_Type;

#define PgType_NEW() (PyObj) PyPgType_Type.tp_alloc(&PyPgType_Type, 0)
PyObj PyPgType_New(PyObj);
PyObj PgType_FromTypeOid(Oid);
PyObj PgType_FromTuple(PyObj);
PyObj PgType_FromHeapTuple(HeapTuple);
PyObj PgType_FromPyObject(PyObj);

#define PgType(OB) ((PgType)OB)

#define PgType_TypeCheck(OB) (PyObject_TypeCheck(PgType(OB), &PyPgType_Type))
#define PgType_TypeCheckExact(OB) (PgType(OB)->ob_type == &PyPgType_Type)

#define PgType_FetchTuple(OB) (PgType(OB)->ob_tuple)
#define PgType_FetchHT(OB) (PgTup_FetchHT(PgType_FetchTuple(OB)))
#define PgType_FetchOid(OB) (HeapTupleGetOid(PgType_FetchHT(OB)))
#define TOTYPESTRUCT(OB) (TYPESTRUCT(PgType_FetchHT(OB)))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_TYPE_H */
