/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1996  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* ALAS (Allgemeine Lizenz fr Amateurfunk Software).                   */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braundschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

#ifdef __DOS16__

#define WATCH_TIME        60*18         /* 60s Timeout                  */

void reboot_system(void);
void interrupt (*old_timer)(void);      /* Vektor auf Ticker im BIOS    */

/*----------------------------------------------------------------------*/
/* Interrupt Routine, haengt sich in Ticker-Interrupt                   */
/*                    main() setzt watchdog staendig auf 0.             */
/*                    Wenn nicht, dann wird alles neu geladen.          */
/* NEU: Diese Routine wird mit 100 Hz aufgerufen                        */
/*----------------------------------------------------------------------*/
void interrupt timer(void)
{
  static int delay = 0;

  if (watchdog++ >= WATCH_TIME)         /* Timeout..                    */
  {
#ifdef notdef
      FILE *fp;
      if ((fp = fopen("C:\\CRASH.TNN","a")) != NULL)
      {
          fprintf(fp,"\ncrashtime=%s\nlast action=%s\n",
                     ctime(&dos_time),wowarich);
          fclose(fp);
      }
#endif
      reboot_system();
  }

  tic10 += 5;
  if (++delay == 5) {
    delay = 0;
    tic10++;
  }

  old_timer();
} /*** Interrupt-Routine beendet ***/

/*----------------------------------------------------------------------*/
/* Initialisierung des Moduls                                           */
/*----------------------------------------------------------------------*/
void init_timer(void)
{
  watchdog = 0;                         /* Watchdog vorladen            */
  disable();                            /* keine Stoerung zulaessig     */
  old_timer = getvect(0x08);            /* alten Timervektor retten     */
  setvect(0x08, timer);                 /* auf eigenen Vektor setzen    */
  enable();                             /* fertig                       */
}

/*----------------------------------------------------------------------*/
/* zurueck in Ursprungszustand                                          */
/*----------------------------------------------------------------------*/
void exit_timer()
{
  disable();                            /* keine Stoerung zulaessig     */
  setvect(0x08, old_timer);             /* alten Vektor zurueck         */
  enable();
}

/*----------------------------------------------------------------------*/
#endif

/* Ende TIMER_PC.C */

