/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/************************************************************************/
/*                                                                      */
/* "set T2 and xmit RR response"                                        */
/*                                                                      */
/* Timer 2 setzen und nach Ablauf RR als Response senden.               */
/*                                                                      */
/************************************************************************/
void t2rrr(void)
{
  setT2(L2CRR);
}

/************************************************************************/
/*                                                                      */
/* "set T2 and xmit RNR response"                                       */
/*                                                                      */
/* Timer 2 setzen und nach Ablauf RNR als Response senden.              */
/*                                                                      */
/************************************************************************/
void t2rnrr(void)
{
  setT2(L2CRNR);
}

/************************************************************************/
/*                                                                      */
/* "set T2 and xmit REJ response"                                       */
/*                                                                      */
/* Timer 2 setzen und nach Ablauf REJ als Response senden.              */
/*                                                                      */
/************************************************************************/
void t2rejr(void)
{
  setT2(L2CREJ);
}

/************************************************************************/
/*                                                                      */
/* "set T1"                                                             */
/*                                                                      */
/* Den Timer 1 anhand des SRTT setzen. Wenn wir bereits erfolglose      */
/* Versuche hatten (tries != 0), wird der Timer 1 vergrert. Die       */
/* Laufzeitmessung (RTT) wird neu gestartet.                            */
/*                                                                      */
/************************************************************************/
void setT1(void)
{
  /* lnkpoi->T1 = lnkpoi->SRTT * ( (lnkpoi->tries > 3 ?
                                 3 : lnkpoi->tries) + L2_BETA ); */
  lnkpoi->T1 = lnkpoi->SRTT * L2_BETA;
  setRTT();
}

/************************************************************************/
/*                                                                      */
/* "clear T1"                                                           */
/*                                                                      */
/* Timer 1 lschen, es ist eine Reaktion eingetreten. Die Anzahl der    */
/* Fehlversuche (tries) wird gelscht, ebenso der Timer 3 neu gesetzt.  */
/*                                                                      */
/************************************************************************/
void clrT1(void)
{
  lnkpoi->T1 = 0;
  lnkpoi->tries = 0;
  setT3();
}

/************************************************************************/
/*                                                                      */
/* "set T2"                                                             */
/*                                                                      */
/* Timer 2 starten und festlegen, welches Frame nach Ablauf zu senden   */
/* ist.                                                                 */
/*                                                                      */
/************************************************************************/
void setT2(int Stype)
{
  lnkpoi->RStype = Stype;
  lnkpoi->T2 = portpar[lnkpoi->liport].T2;
}

/************************************************************************/
/*                                                                      */
/* "clear T2"                                                           */
/*                                                                      */
/* Timer 2 lschen.                                                     */
/*                                                                      */
/************************************************************************/
void clrT2(void)
{
  lnkpoi->T2 = 0;
  lnkpoi->RStype = 0;
}

/************************************************************************/
/*                                                                      */
/* "set T3"                                                             */
/*                                                                      */
/* Timer 3 mit Defaultwert initialisieren.                              */
/*                                                                      */
/************************************************************************/
void setT3(void)
{
  lnkpoi->T3 = T3par;
}

/************************************************************************/
/*                                                                      */
/* "clear T3"                                                           */
/*                                                                      */
/* Timer 1 lschen.                                                     */
/* Fehlversuche (tries) wird gelscht, ebenso der Timer 3 neu gesetzt.  */
/* Aus der vergangenen Zeit seit dem setzen des T1 wird der RTT und     */
/* damit der SRTT neu berechnet.                                        */
/*                                                                      */
/************************************************************************/
void clrT3(void)
{
  lnkpoi->T3 = 0;
}

/************************************************************************/
/*                                                                      */
/* "set RTT"                                                            */
/*                                                                      */
/* RTT starten und VS merken.                                           */
/*                                                                      */
/************************************************************************/
void setRTT(void)
{
  lnkpoi->RTT = 1;
  lnkpoi->RTTvs = lnkpoi->VS;
}

/************************************************************************/
/*                                                                      */
/* "clear RTT"                                                          */
/*                                                                      */
/* Aus der vergangenen Zeit seit dem setzen des T1 wird der RTT und     */
/* damit der SRTT neu berechnet.                                        */
/*                                                                      */
/************************************************************************/
void clrRTT(void)
{
  /*
   * Nach RTT-Berechnung aus KA9Q's TCP/IP-Paket:
   *
   * SRTT' = (Alpha * SRTT + RTT) / (Alpha + 1)
   *
   * Alpha getrennt parametrisierbar fuer fallendes/steigendes RTT:
   * Alpha1 = steigendes RTT (kleines Alpha -> schnell reagieren)
   * Alpha2 = fallendes  RTT (grosses Alpha -> langsam reagieren)
   *
   */
 LNKBLK *lp   = lnkpoi;
 UWORD   rtt  = lp->RTT,
         srtt = lp->SRTT,
         irtt = portpar[lp->liport].IRTT;

  if(rtt > srtt)
    srtt = (L2_ALPHA1*srtt + rtt)/(L2_ALPHA1+1);
  else
    srtt = (L2_ALPHA2*srtt + rtt)/(L2_ALPHA2+1);

  if (srtt < irtt/10)
    srtt = irtt/10;
  if (srtt > irtt*10)
    srtt = irtt*10;

  lp->RTT = 0;
  lp->SRTT = srtt;
}

/************************************************************************/
/*                                                                      */
/* "xmit null"                                                          */
/*                                                                      */
/* Nichts tun. Leerfunktion fr die Statetable.                         */
/*                                                                      */
/************************************************************************/
void xnull(void)
{
}

/************************************************************************/
/*                                                                      */
/* "xmit RR command"                                                    */
/*                                                                      */
/* RR als Command senden.                                               */
/*                                                                      */
/************************************************************************/
void xrrc(void)
{
  stxcfr();
  sendS(L2CRR);
}

/************************************************************************/
/*                                                                      */
/* "xmit RR response"                                                   */
/*                                                                      */
/* RR als Response senden.                                              */
/*                                                                      */
/************************************************************************/
void xrrr(void)
{
  sendS(L2CRR);
}

/************************************************************************/
/*                                                                      */
/* "xmit RNR command"                                                   */
/*                                                                      */
/* REJ als Command senden.                                              */
/*                                                                      */
/************************************************************************/
void xrnrc(void)
{
  stxcfr();
  xrnrr();
}

/************************************************************************/
/*                                                                      */
/* "xmit RNR response"                                                  */
/*                                                                      */
/* RNR als Response senden.                                             */
/*                                                                      */
/************************************************************************/
void xrnrr(void)
{
  sendS(L2CRNR);
}

/************************************************************************/
/*                                                                      */
/* "xmit REJ response"                                                  */
/*                                                                      */
/* REJ als Response senden.                                             */
/*                                                                      */
/************************************************************************/
void xrejr(void)
{
  sendS(L2CREJ);
}

/************************************************************************/
/*                                                                      */
/* "send supervisory frame"                                             */
/*                                                                      */
/* Ein Supervisory-Frame aufbauen, Timer 2 lschen und das Frame        */
/* an den aktuellen Link senden.                                        */
/*                                                                      */
/************************************************************************/
void sendS(int control)
{
  clrT2();
  txfctl = setNR(control);
  sdl2fr(makfhd((!txfCR ? L2FUS : L2FUS | L2FT1ST)), FALSE);
}

/************************************************************************/
/*                                                                      */
/* "xmit DM"                                                            */
/*                                                                      */
/* Ein DM-Frame generieren und an die aktuelle Adresse (txf...)         */
/* senden.                                                              */
/*                                                                      */
/************************************************************************/
void xdm(void)
{
  txfctl = L2CDM;
  sdl2fr(makfhd(L2FUS), TRUE);
}

/************************************************************************/
/*                                                                      */
/* "xmit UA"                                                            */
/*                                                                      */
/* Ein UA-Frame generieren und an die aktuelle Adresse (txf...)         */
/* senden.                                                              */
/*                                                                      */
/************************************************************************/
void xua(void)
{
  txfctl = L2CUA;
  sdl2fr(makfhd(L2FUS), TRUE);
}

/************************************************************************/
/*                                                                      */
/* "xmit SABM"                                                          */
/*                                                                      */
/* Ein SABM-Frame generieren und an die Adresse des aktuellen Linkblock */
/* senden.                                                              */
/*                                                                      */
/************************************************************************/
void xsabm(void)
{
  stxcfr();
  txfctl = L2CSABM;
  sdl2fr(makfhd((L2FUS|L2FT1ST)), FALSE);
}

/************************************************************************/
/*                                                                      */
/* "xmit DISC"                                                          */
/*                                                                      */
/* Ein DISC-Frame generieren und an die Adresse des aktuellen Linkblock */
/* senden.                                                              */
/*                                                                      */
/************************************************************************/
void xdisc(void)
{
  stxcfr();
  txfctl = L2CDISC;
  sdl2fr(makfhd((L2FUS|L2FT1ST)), FALSE);
}

/************************************************************************/
/*                                                                      */
/* "xmit FRMR"                                                          */
/*                                                                      */
/* FRMR-Frame generieren und mit der RIP-Information aus dem Linkblock  */
/* fllen.                                                              */
/*                                                                      */
/************************************************************************/
void xfrmr(void)
{
  char *frmrip;
  MBHEAD *fbp;

  stxfad();
  txfctl = L2CFRMR;
  fbp = makfhd((L2FUS | L2FT1ST));
  frmrip = lnkpoi->frmr;
  putchr(*frmrip++,fbp);
  putchr(*frmrip++,fbp);
  putchr(*frmrip  ,fbp);
  sdl2fr(fbp, TRUE);
}

/************************************************************************/
/*                                                                      */
/* "set tx command frame"                                               */
/*                                                                      */
/* TX-Frame-Adressierung setzen (siehe stxfad()) und Frame zum Kommando-*/
/* frame machen mit gesetztem Pollbit (txfCR,txfPF).                    */
/*                                                                      */
/************************************************************************/
void stxcfr(void)
{
  stxfad();                             /* Adressierung                 */
  txfCR = L2CCR;                        /* Command !                    */
  txfPF = L2CPF;                        /* Pollbit !                    */
}

/************************************************************************/
/*                                                                      */
/* "set tx frame address"                                               */
/*                                                                      */
/* Adressierung des aktuellen Sendeframes (txfhdr, txfprt) setzen aus   */
/* den im aktuellen Linkblock (lnkpoi) gegebenen Parametern (srcid,     */
/* destid, viaidl, liport).                                             */
/*                                                                      */
/************************************************************************/
void stxfad(void)
{
  cpyid(txfhdr + L2IDLEN,lnkpoi->srcid);        /* von ...              */

  /*
   *    DAMA-Bit loeschen, wenn DAMA-Betrieb (geloeschtes Bit = DAMA !)
   */
  if (dama(lnkpoi->liport))
    txfhdr[L2ILEN-1] &= ~0x20;

  cpyid(txfhdr,lnkpoi->dstid);                  /* nach ...             */
  cpyidl(txfhdr + L2ILEN, lnkpoi->viaidl);      /* ueber ...            */

  txfprt = lnkpoi->liport;                      /* auf Port ...         */
}

/************************************************************************/
/*                                                                      */
/* "set NR"                                                             */
/*                                                                      */
/* Im aktuellen Linkblock (lnkpoi) die zuletzt gesendete N(R) (ltxdNR)  */
/* auf V(R) (VR) setzen und Framecontrolbyte control fuer Frameaus-     */
/* sendung mit der N(R) versehen und zurueckgeben.                      */
/*                                                                      */
/* Return :  control mit N(R) versehen                                  */
/*                                                                      */
/************************************************************************/
WORD setNR(int control)
{
  lnkpoi->ltxdNR = lnkpoi->VR;          /* neue N(R)                    */
  return(((lnkpoi->VR<<5) | control));  /* N(R) ins kontrollfeld        */
}

/************************************************************************/
/*                                                                      */
/* "send level 2 frame"                                                 */
/*                                                                      */
/* Framebuffer, auf dessen Kopf fbp zeigt, rewinden und in die dem Port */
/* (l2port) entsprechende Level-2-Sendeframeliste einhaengen, wenn noch */
/* genug Buffer im System frei sind. Andernfalls nicht senden, sondern  */
/* sofort in die Gesendet-Liste (stfl) einhaengen.                      */
/*                                                                      */
/************************************************************************/
void sdl2fr(fbp, send_immediately)
MBHEAD *fbp;
BOOLEAN send_immediately;
{
  UBYTE port;                           /* Portnummer                   */

  port = fbp->l2port;                   /* Portnummer holen             */

  if (!portenabled(port)) {             /* Wenn Port nicht aktiv, Frame */
    relink((LEHEAD *)fbp,(LEHEAD *)stfl.tail); /* gleich in Gesendet-Liste */
    return;
  }

  if (nmbfre > 14) {                    /* noch genug Buffer ?          */
    rwndmb(fbp);                        /* ja - Framebuffer rewinden    */
                                        /* Frame in Sendeliste          */
    if (dama(port))                     /* DAMA-Frames werden in        */
     {                                  /* timDAMA gesendet             */
      if(send_immediately == FALSE)
        relink((LEHEAD *)fbp,(LEHEAD *)(lnkpoi->damail.tail));
      else
        relink((LEHEAD *)fbp,(LEHEAD *) &damarl[port]);
      return;
     }
    relink((LEHEAD *)fbp,(LEHEAD *)txl2fl[port].tail);
    kicktx(port);                       /* es ist was zu senden !       */
  }
  else                                  /* kein Platz - Frame sofort    */
  {                                     /* als gesendet betrachten      */
    relink((LEHEAD *)fbp,(LEHEAD *)stfl.tail);
  }
}

/************************************************************************/
/*                                                                      */
/* "copy frame buffer"                                                  */
/*                                                                      */
/* Framebuffer, auf den fbp zeigt, komplett mit Inhalt kopieren. Dazu   */
/* freie Buffer allokieren, Portnummer (l1port) wird kopiert, Buffer-   */
/* zeiger und Getcounter (mbgc) werden nicht kopiert, bleiben aber im   */
/* Quellframe erhalten.                                                 */
/*                                                                      */
/* Return :  Zeiger auf Kopf des kopierten Framebuffers                 */
/*                                                                      */
/************************************************************************/
MBHEAD *cpyfb(MBHEAD *fbp)
{
  char huge *savmbbp;                   /* mbbp-Sicherung               */
  WORD savmbgc;                         /* mbgc-Sicherung               */
  MBHEAD *newfbp;                       /* Zeiger auf die Kopie         */

  savmbbp = fbp->mbbp;                  /* mbbp sichern                 */
  savmbgc = fbp->mbgc;                  /* mbgc sichern                 */
  rwndmb(fbp);                          /* Quellframe rewinden          */
  newfbp = (MBHEAD *) allocb();         /* Kopf der Kopie allokieren    */
  while (fbp->mbgc < fbp->mbpc)         /* Daten byteweise kopieren     */
    putchr(getchr(fbp),newfbp);
  newfbp->l2port = fbp->l2port;         /* Portnummer kopieren          */
  fbp->mbbp = savmbbp;                  /* mbbp wieder auf alten Wert   */
  fbp->mbgc = savmbgc;                  /* mbgc wieder auf alten Wert   */
  return (newfbp);                      /* Zeiger auf Kopf der Kopie    */
}

/************************************************************************/
/*                                                                      */
/* "take frame head"                                                    */
/*                                                                      */
/* Adresskopf und Kontrollbyte des Frames aus dem Framebuffer, auf      */
/* dessen Kopf fbp zeigt, analysieren. Diese Funktion ist die erste,    */
/* die auf ein empfangenes Frame angewandt wird.                        */
/*                                                                      */
/*                                                                      */
/* Folgende Parameter werden bei der Analyse gesetzt:                   */
/*                                                                      */
/*    rxfhdr, rxfV2, rxfPF, rxfCR, rxfctl, rxfprt                       */
/*                                                                      */
/*                                                                      */
/* Folgende Parameter werden nach der Analyse gesetzt fuer ein          */
/* moegliches Antwortframe :                                            */
/*                                                                      */
/*   txfhdr  = Quell- und Zielcall aus rxfhdr, aber vertauscht, plus    */
/*             reverse via-Liste aus rxfhdr                             */
/*   txfV2   = rxfV2                                                    */
/*   txfPF   = rxfPF                                                    */
/*   txfCR   = 0, Response !                                            */
/*   txfprt  = rxfprt                                                   */
/*                                                                      */
/*                                                                      */
/* Return :  TRUE  - das Frame hat einen gueltigen AX.25-Framekopf      */
/*           FALSE - sonst                                              */
/*                                                                      */
/************************************************************************/
BOOLEAN takfhd(MBHEAD *fbp)
{
  char    *p;                           /* Zeiger im Header             */
  char    *source;                      /* Quellzeiger Kopien           */
  char    *dest;                        /* Zielzeiger Kopien            */
  int      n;

  rxfprt = fbp->l2port;

  if (!portenabled(rxfprt))             /* Port gesperrt                */
    return(FALSE);

  rwndmb(fbp);                          /* Frame von vorne              */
  for (p = rxfhdr, n = 1; n <= L2INUM+L2VNUM; n++) {
    if (!getfid(p, fbp)) {              /* naechstes Call lesen         */
      INV_FRAME(rxfprt, INVF_ADR);
      return (FALSE);
    }
    p += L2IDLEN;
    if (*(p - 1) & L2CEOA) break;       /* Ende des Addressfeldes       */
  }
  *(p - 1) &= ~L2CEOA;

  if (n < L2INUM) {                     /* Absender und/oder Ziel fehlt */
    INV_FRAME(rxfprt, INVF_ALN);
    return (FALSE);
  }
  if (n > L2VNUM+L2INUM) {              /* Addressfeld zu lang          */
    INV_FRAME(rxfprt, INVF_ALN);
    return (FALSE);
  }
  *p = 0;                               /* Addressfeld terminieren      */

  if (fbp->mbgc == fbp->mbpc) {         /* Control-Feld fehlt?          */
    INV_FRAME(rxfprt, INVF_CTL);
    return (FALSE);
  }

  rxfctl = getchr(fbp);

/* Framelaengencheck UI-Frames: jetzt duerfen noch max. 257 ungelesene  */
/* Bytes im Buffer sein! (PID + 256 Bytes Info)                         */
/* Bei TNN ist das nicht noetig! (hier gibts keinen Hostmode)           */
/* if ((rxfctl == L2CUI) && (fbp->mbpc - fbp->mbgc > 257))              */
/*   return(FALSE);                                                     */
/* Ende Framelaengencheck                                               */

  if ( ((rxfhdr[L2IDLEN - 1] ^ rxfhdr[L2ILEN - 1]) & L2CCR) != 0 ) {
    rxfCR = rxfhdr[L2IDLEN - 1];
    rxfCR &= L2CCR;
    rxfPF = rxfctl & L2CPF;
  } else
    return (rxfctl == L2CUI); /* V1-Frame, nur UI nehmen */

  rxfctl &= ~L2CPF;
  txfCR = 0;
  txfPF = rxfPF;
  txfprt = rxfprt;
  cpyid(txfhdr,rxfhdr + L2IDLEN);
  cpyid(txfhdr + L2IDLEN,rxfhdr);

/* Jetzt wird das via-Feld so umgebaut, wie es bei der Sendung      */
/* aussehen wird.                                                   */

  for (source = rxfhdr + L2ILEN; *source; source += L2IDLEN);
  for (dest = txfhdr + L2ILEN; source != rxfhdr + L2ILEN; dest += L2IDLEN) {
    source -= L2IDLEN;
    memcpy(dest, source, L2IDLEN);          /* Rufzeichen kopieren  */
    dest[L2IDLEN - 1] ^= L2CH;
  }
  *dest = '\0';

  return (TRUE);
}

/************************************************************************/
/*                                                                      */
/* "get frame id"                                                       */
/*                                                                      */
/* Ein Rufzeichen in AX.25-Notation aus einem Buffer lesen.             */
/*                                                                      */
/************************************************************************/
BOOLEAN getfid(char *dest, MBHEAD *mbhd)
{
  char c;
  WORD i;

  if (mbhd->mbpc - mbhd->mbgc < L2IDLEN)
    return (FALSE);
  for (i = 0; i < L2CALEN; ++i) {
    if (((c = getchr(mbhd)) & L2CEOA) != 0)
      return (FALSE);
    *dest++ = (c >> 1) & 0x7F;
  }
  *dest = getchr(mbhd);
  return (TRUE);
}

/************************************************************************/
/*                                                                      */
/* "make frame header"                                                  */
/*                                                                      */
/* Die Header-Daten aus "txf.." werden in einen Buffer geschrieben.     */
/* Sie wurden entweder von getfhd() aus dem Empfangsframe durch         */
/* Spiegelung generiert oder aus dem Linkblock gesetzt.                 */
/*                                                                      */
/************************************************************************/
MBHEAD *makfhd(int fflag)
{
  MBHEAD *fbp;

  txfhdr[L2IDLEN - 1] |= txfCR;
  txfhdr[L2ILEN - 1] |= txfCR ^ L2CCR;

  putfid(txfhdr,fbp = (MBHEAD *) allocb());
  if (dama(txfprt))
    txfhdr[L2ILEN-1] &= ~0x20;
  putfid(txfhdr + L2IDLEN,fbp);
  putvia(txfhdr + L2ILEN,fbp);
  putchr((UBYTE)(txfctl | txfPF),fbp);
  fbp->l2link = lnkpoi;
  fbp->type = 2;
  fbp->l2fflg = fflag;
  fbp->l2port = txfprt;
  return (fbp);
}

/************************************************************************/
/*                                                                      */
/* "put via"                                                            */
/*                                                                      */
/* Eine Rufzeichenliste in AX.25 in einen Frame schreiben. Das letzte   */
/* Rufzeichen erhlt das EOA-Bit.                                       */
/*                                                                      */
/************************************************************************/
void putvia(char *idl, MBHEAD *mbhd)
{
  while (*idl != '\0') {
    putfid(idl,mbhd);
    idl += L2IDLEN;
  }
  *(mbhd->mbbp - 1) |= L2CEOA;
}

/************************************************************************/
/*                                                                      */
/* "put frame id"                                                       */
/*                                                                      */
/* Ein Rufzeichen in AX.25-Notation in einen Buffer schreiben.          */
/*                                                                      */
/************************************************************************/
void putfid(char *id, MBHEAD *mbhd)
{
  WORD i;

  for (i = 0; i < L2CALEN; ++i)
    putchr((UBYTE)(*id++ << 1),mbhd);
  putchr(*id,mbhd);
}

/************************************************************************/
/*                                                                      */
/* "is to me"                                                           */
/*                                                                      */
/* Ist das bergebene Rufzeichen unser myid oder alias? Der Alias kann  */
/* mit beliebiger SSID connected werden.                                */
/*                                                                      */
/************************************************************************/
BOOLEAN istome(char *id)
{
  return (   cmpid(myid,id)             /* Stimmt Rufzeichen?   */
          || cmpcal(alias,id)           /* oder ALIAS?          */
         );
}

/************************************************************************/
/*                                                                      */
/* "compare call"                                                       */
/*                                                                      */
/* Rufzeichen vergleichen. EOA und H-Bit werden ignoriert.              */
/*                                                                      */
/************************************************************************/
BOOLEAN cmpcal(char *id1, char *id2)
{
  return (strncmp(id1, id2, L2CALEN) == 0);
}

/************************************************************************/
/*                                                                      */
/* "compare id"                                                         */
/*                                                                      */
/* Rufzeichen und SSID vergleichen. EOA und H-Bit werden ignoriert.     */
/*                                                                      */
/************************************************************************/
BOOLEAN cmpid(char *id1, char *id2)
{
  return (   cmpcal(id1, id2)
          && (id2[L2CALEN]&0x1E) == (id1[L2CALEN]&0x1E));
}

/************************************************************************/
/*                                                                      */
/* "compare id list"                                                    */
/*                                                                      */
/* Zwei Rufzeichenlisten werden verglichen. Die H-Bits muessen in allen */
/* Rufzeichen bereinstimmen.                                           */
/*                                                                      */
/************************************************************************/
BOOLEAN cmpidl(char *idl1, char *idl2)
{
  while (*idl2 != '\0') {
    if (memcmp(idl1,idl2,L2IDLEN))
      return (FALSE);
    idl2 += L2IDLEN;
    idl1 += L2IDLEN;
  }
  return ( (*idl1 == '\0') ? TRUE : FALSE );
}

/************************************************************************/
/*                                                                      */
/* "copy id list"                                                       */
/*                                                                      */
/* Rufzeichenliste kopieren. EOA und H Bit bleiben erhalten.            */
/*                                                                      */
/************************************************************************/
void cpyidl(char *dest, char *source)
{
  while (*source != '\0') {
    memcpy(dest,source,L2IDLEN);
    source += L2IDLEN;
    dest += L2IDLEN;
  }
  *dest = '\0';
}

/************************************************************************/
/*                                                                      */
/* "copy id"                                                            */
/*                                                                      */
/* Rufzeichen kopieren. End-of-Address und Has-been-digipeated Bit      */
/* werden gelscht.                                                     */
/*                                                                      */
/************************************************************************/
void cpyid(char *dest, char *source)
{
  memcpy(dest, source, L2CALEN);
  dest[L2IDLEN-1] = source[L2IDLEN-1] & ~(L2CEOA | L2CCR);
}

/************************************************************************/
/*                                                                      */
/* "add id"                                                             */
/*                                                                      */
/* An eine Rufzeichenliste ein Call anhngen.                           */
/*                                                                      */
/************************************************************************/
void addid(char *dest, char *source)
{
  char *cp;

  cp = (char *)strchr((char *)dest, 0);
  if (&cp[0] < &dest[L2VLEN]) {
    memcpy(cp, source, L2IDLEN);
    cp[L2IDLEN] = 0;
  }
}

/************************************************************************/
/*                                                                      */
/* "add id list"                                                        */
/*                                                                      */
/* An eine Rufzeichenliste eine andere Call anhngen.                   */
/*                                                                      */
/************************************************************************/
void addidl(char *dest, char *source)
{
  char *cp;
  cp = (char *)strchr((char *)dest, 0);
  if (&cp[strlen((char *)source)] <= &dest[L2VLEN])
    cpyidl(cp, source);
}

/************************************************************************/
/*                                                                      */
/* "first not digipeated"                                               */
/*                                                                      */
/* Das erste Call aus einer Rufzeichenliste lesen, das noch nicht       */
/* gedigipeated hat. Es darf weder unser Call sein noch ein gesetztes   */
/* H-Bit haben.                                                         */
/*                                                                      */
/************************************************************************/
char *ndigipt(char *rxfhdr) {
  char *viap;

  for (viap = rxfhdr; *viap; viap += L2IDLEN)
    if ((viap[L2IDLEN - 1] & L2CH) == 0) break;
  if (*viap)
    if (istome(viap))
      viap += L2IDLEN;
  return (viap);
}

/************************************************************************/
/*                                                                      */
/* "is to me or via me?"                                                */
/*                                                                      */
/* Pruefen, ob wir als naechster an der Reihe sind mit Digipeaten. Dazu */
/* schauen wir uns das erste Call an, das kein gesetztes Hbit hat, dass */
/* muessen wir selber sein oder wir schmeissen das Frame weg,           */
/* andernfalls duerfen wir das Frame auswerten.                         */
/*                                                                      */
/************************************************************************/
int istomev(void) {
  char *viap;

  for (viap = rxfhdr + L2ILEN; *viap; viap += L2IDLEN)
    if (!(viap[L2IDLEN-1] & L2CH))
      return (   istome(viap)              /* Verbindung via uns?       */
              ?  2 : 0);
  /* hier angekommen haben entweder alle schon gedigipeated oder es     */
  /* gibt keine via's, auf jeden Fall duerfen wir den Link nehmen, wenn */
  /* er direkt an uns gerichtet ist.                                    */
  return (istome(rxfhdr) ? 1 : 0);
}

/************************************************************************/
/*                                                                      */
/* "level 2 to level x"                                                 */
/*                                                                      */
/* Meldung msg (L2M...) an Layer 3 und hoehere Layer weitergeben.       */
/*                                                                      */
/************************************************************************/
void l2tolx(WORD msg)
{
  if (!l2tol3(msg))                         /* Layer 2 -> Layer 3       */
    l2tol7(msg, lnkpoi, L2_USER);           /* Layer 2 -> Layer 7       */
}

/* End of L2C.C */
