/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hash.MurmurHash3;

public final class ThetaUtil {
    public static final int MIN_LG_NOM_LONGS = 4;
    public static final int MAX_LG_NOM_LONGS = 26;
    public static final double REBUILD_THRESHOLD = 0.9375;
    public static final double RESIZE_THRESHOLD = 0.5;
    public static final int DEFAULT_NOMINAL_ENTRIES = 4096;
    public static final long DEFAULT_UPDATE_SEED = 9001L;
    public static final int MIN_LG_ARR_LONGS = 5;

    private ThetaUtil() {
    }

    public static short checkSeedHashes(short seedHashA, short seedHashB) {
        if (seedHashA != seedHashB) {
            throw new SketchesArgumentException("Incompatible Seed Hashes. " + Integer.toHexString(seedHashA & 0xFFFF) + ", " + Integer.toHexString(seedHashB & 0xFFFF));
        }
        return seedHashA;
    }

    public static short computeSeedHash(long seed) {
        long[] seedArr = new long[]{seed};
        short seedHash = (short)(MurmurHash3.hash(seedArr, 0L)[0] & 0xFFFFL);
        if (seedHash == 0) {
            throw new SketchesArgumentException("The given seed: " + seed + " produced a seedHash of zero. You must choose a different seed.");
        }
        return seedHash;
    }

    public static int startingSubMultiple(int lgTarget, int lgRF, int lgMin) {
        return lgTarget <= lgMin ? lgMin : (lgRF == 0 ? lgTarget : (lgTarget - lgMin) % lgRF + lgMin);
    }

    public static int checkNomLongs(int nomLongs) {
        int lgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingIntPowerOf2(nomLongs));
        if (lgNomLongs > 26 || lgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomLongs);
        }
        return lgNomLongs;
    }
}

