/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MetricsProducer {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsProducer.class);
    public static final String METRICS_SERVER_IDLE = "accumulo.server.idle";
    public static final String METRICS_COMPACTOR_PREFIX = "accumulo.compactor.";
    public static final String METRICS_COMPACTOR_MAJC_STUCK = "accumulo.compactor.majc.stuck";
    public static final String METRICS_COMPACTOR_ENTRIES_READ = "accumulo.compactor.entries.read";
    public static final String METRICS_COMPACTOR_ENTRIES_WRITTEN = "accumulo.compactor.entries.written";
    public static final String METRICS_COMPACTOR_COMPACTIONS_CANCELLED = "accumulo.compactor.majc.cancelled";
    public static final String METRICS_COMPACTOR_COMPACTIONS_COMPLETED = "accumulo.compactor.majc.completed";
    public static final String METRICS_COMPACTOR_COMPACTIONS_FAILED = "accumulo.compactor.majc.failed";
    public static final String METRICS_COMPACTOR_FAILURES_CONSECUTIVE = "accumulo.compactor.majc.failures.consecutive";
    public static final String METRICS_COMPACTOR_FAILURES_TERMINATION = "accumulo.compactor.terminated";
    public static final String METRICS_FATE_PREFIX = "accumulo.fate.";
    public static final String METRICS_FATE_TYPE_IN_PROGRESS = "accumulo.fate.ops.in.progress.by.type";
    public static final String METRICS_FATE_OPS = "accumulo.fate.ops";
    public static final String METRICS_FATE_OPS_ACTIVITY = "accumulo.fate.ops.activity";
    public static final String METRICS_FATE_ERRORS = "accumulo.fate.errors";
    public static final String METRICS_FATE_TX = "accumulo.fate.tx";
    public static final String METRICS_GC_PREFIX = "accumulo.gc.";
    public static final String METRICS_GC_STARTED = "accumulo.gc.started";
    public static final String METRICS_GC_FINISHED = "accumulo.gc.finished";
    public static final String METRICS_GC_CANDIDATES = "accumulo.gc.candidates";
    public static final String METRICS_GC_IN_USE = "accumulo.gc.in.use";
    public static final String METRICS_GC_DELETED = "accumulo.gc.deleted";
    public static final String METRICS_GC_ERRORS = "accumulo.gc.errors";
    public static final String METRICS_GC_WAL_STARTED = "accumulo.gc.wal.started";
    public static final String METRICS_GC_WAL_FINISHED = "accumulo.gc.wal.finished";
    public static final String METRICS_GC_WAL_CANDIDATES = "accumulo.gc.wal.candidates";
    public static final String METRICS_GC_WAL_IN_USE = "accumulo.gc.wal.in.use";
    public static final String METRICS_GC_WAL_DELETED = "accumulo.gc.wal.deleted";
    public static final String METRICS_GC_WAL_ERRORS = "accumulo.gc.wal.errors";
    public static final String METRICS_GC_POST_OP_DURATION = "accumulo.gc.post.op.duration";
    public static final String METRICS_GC_RUN_CYCLE = "accumulo.gc.run.cycle";
    public static final String METRICS_MAJC_PREFIX = "accumulo.tserver.compactions.majc.";
    public static final String METRICS_MAJC_QUEUED = "accumulo.tserver.compactions.majc.queued";
    public static final String METRICS_MAJC_RUNNING = "accumulo.tserver.compactions.majc.running";
    public static final String METRICS_MINC_PREFIX = "accumulo.tserver.compactions.minc.";
    public static final String METRICS_MINC_QUEUED = "accumulo.tserver.compactions.minc.queued";
    public static final String METRICS_MINC_RUNNING = "accumulo.tserver.compactions.minc.running";
    public static final String METRICS_REPLICATION_PREFIX = "accumulo.replication.";
    public static final String METRICS_REPLICATION_QUEUE = "accumulo.replication.queue";
    public static final String METRICS_REPLICATION_PENDING_FILES = "accumulo.replication.files.pending";
    public static final String METRICS_REPLICATION_PEERS = "accumulo.replication.peers";
    public static final String METRICS_REPLICATION_THREADS = "accumulo.replication.threads";
    public static final String METRICS_SCAN_PREFIX = "accumulo.scan.";
    public static final String METRICS_SCAN_TIMES = "accumulo.scan.times";
    public static final String METRICS_SCAN_OPEN_FILES = "accumulo.scan.files.open";
    public static final String METRICS_SCAN_RESULTS = "accumulo.scan.result";
    public static final String METRICS_SCAN_YIELDS = "accumulo.scan.yields";
    public static final String METRICS_SCAN_START = "accumulo.scan.start";
    public static final String METRICS_SCAN_CONTINUE = "accumulo.scan.continue";
    public static final String METRICS_SCAN_CLOSE = "accumulo.scan.close";
    public static final String METRICS_SCAN_RESERVATION_TOTAL_TIMER = "accumulo.scan.reservation.total.timer";
    public static final String METRICS_SCAN_RESERVATION_WRITEOUT_TIMER = "accumulo.scan.reservation.writeout.timer";
    public static final String METRICS_SCAN_BUSY_TIMEOUT_COUNTER = "accumulo.scan.busy.timeout.count";
    public static final String METRICS_SCAN_RESERVATION_CONFLICT_COUNTER = "accumulo.scan.reservation.conflict.count";
    public static final String METRICS_SCAN_QUERIES = "accumulo.scan.queries";
    public static final String METRICS_SCAN_QUERY_SCAN_RESULTS = "accumulo.scan.query.results";
    public static final String METRICS_SCAN_QUERY_SCAN_RESULTS_BYTES = "accumulo.scan.query.results.bytes";
    public static final String METRICS_SCAN_SCANNED_ENTRIES = "accumulo.scan.query.scanned.entries";
    public static final String METRICS_SCAN_ZOMBIE_THREADS = "accumulo.scan.zombie.threads";
    public static final String METRICS_SCAN_TABLET_METADATA_CACHE = "accumulo.scan.tablet.metadata.cache";
    public static final String METRICS_TSERVER_PREFIX = "accumulo.tserver.";
    public static final String METRICS_TSERVER_ENTRIES = "accumulo.tserver.entries";
    public static final String METRICS_TSERVER_MEM_ENTRIES = "accumulo.tserver.entries.mem";
    public static final String METRICS_TSERVER_MAJC_QUEUED = "accumulo.tserver.majc.queued";
    public static final String METRICS_TSERVER_MAJC_RUNNING = "accumulo.tserver.majc.running";
    public static final String METRICS_TSERVER_MAJC_STUCK = "accumulo.tserver.majc.stuck";
    public static final String METRICS_TSERVER_MINC_QUEUED = "accumulo.tserver.minc.queued";
    public static final String METRICS_TSERVER_MINC_RUNNING = "accumulo.tserver.minc.running";
    public static final String METRICS_TSERVER_MINC_TOTAL = "accumulo.tserver.minc.total";
    public static final String METRICS_TSERVER_TABLETS_LONG_ASSIGNMENTS = "accumulo.tserver.tablets.assignments.warning";
    public static final String METRICS_TSERVER_TABLETS_ONLINE = "accumulo.tserver.tablets.online";
    public static final String METRICS_TSERVER_TABLETS_OPENING = "accumulo.tserver.tablets.opening";
    public static final String METRICS_TSERVER_TABLETS_UNOPENED = "accumulo.tserver.tablets.unopened";
    public static final String METRICS_TSERVER_TABLETS_FILES = "accumulo.tserver.tablets.files";
    public static final String METRICS_TSERVER_HOLD = "accumulo.tserver.hold";
    public static final String METRICS_TSERVER_INGEST_MUTATIONS = "accumulo.tserver.ingest.mutations";
    public static final String METRICS_TSERVER_INGEST_BYTES = "accumulo.tserver.ingest.bytes";
    public static final String METRICS_THRIFT_PREFIX = "accumulo.thrift.";
    public static final String METRICS_THRIFT_EXECUTE = "accumulo.thrift.execute";
    public static final String METRICS_THRIFT_IDLE = "accumulo.thrift.idle";
    public static final String METRICS_UPDATE_PREFIX = "accumulo.tserver.updates.";
    public static final String METRICS_UPDATE_ERRORS = "accumulo.tserver.updates.error";
    public static final String METRICS_UPDATE_COMMIT = "accumulo.tserver.updates.commit";
    public static final String METRICS_UPDATE_COMMIT_PREP = "accumulo.tserver.updates.commit.prep";
    public static final String METRICS_UPDATE_WALOG_WRITE = "accumulo.tserver.updates.walog.write";
    public static final String METRICS_UPDATE_MUTATION_ARRAY_SIZE = "accumulo.tserver.updates.mutation.arrays.size";
    public static final String METRICS_BLOCKCACHE_PREFIX = "accumulo.blockcache.";
    public static final String METRICS_BLOCKCACHE_INDEX_HITCOUNT = "accumulo.blockcache.index.hitcount";
    public static final String METRICS_BLOCKCACHE_INDEX_REQUESTCOUNT = "accumulo.blockcache.index.requestcount";
    public static final String METRICS_BLOCKCACHE_DATA_HITCOUNT = "accumulo.blockcache.data.hitcount";
    public static final String METRICS_BLOCKCACHE_DATA_REQUESTCOUNT = "accumulo.blockcache.data.requestcount";
    public static final String METRICS_BLOCKCACHE_SUMMARY_HITCOUNT = "accumulo.blockcache.summary.hitcount";
    public static final String METRICS_BLOCKCACHE_SUMMARY_REQUESTCOUNT = "accumulo.blockcache.summary.requestcount";
    public static final String METRICS_MANAGER_BALANCER_MIGRATIONS_NEEDED = "accumulo.manager.balancer.migrations.needed";

    public void registerMetrics(MeterRegistry var1);

    default public Map<String, String> getMetricFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Field f : MetricsProducer.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(String.class) || f.getName().contains("PREFIX")) continue;
            try {
                fields.put((String)f.get(MetricsProducer.class), f.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOG.error("Error getting metric value for field: {}", (Object)f.getName());
            }
        }
        return fields;
    }
}

