/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.restrictor.policy;

import java.util.HashSet;
import java.util.Set;
import org.jolokia.restrictor.policy.AbstractChecker;
import org.jolokia.util.HttpMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpMethodChecker
extends AbstractChecker<HttpMethod> {
    private Set<String> httpMethodsSet;

    public HttpMethodChecker(Document pPolicy) {
        NodeList nodes = pPolicy.getElementsByTagName("http");
        if (nodes.getLength() > 0) {
            this.httpMethodsSet = new HashSet<String>();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node commandNode = childs.item(j);
                if (commandNode.getNodeType() != 1) continue;
                this.assertNodeName(commandNode, "method");
                String methodName = commandNode.getTextContent().trim().toLowerCase();
                if (!methodName.equals("post") && !methodName.equals("get")) {
                    throw new SecurityException("HTTP method must be either GET or POST, but not " + methodName.toUpperCase());
                }
                this.httpMethodsSet.add(methodName);
            }
        }
    }

    @Override
    public boolean check(HttpMethod pMethod) {
        return this.httpMethodsSet == null || this.httpMethodsSet.contains(pMethod.getMethod());
    }
}

